// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSensorsGetParams creates a new SensorsGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSensorsGetParams() *SensorsGetParams {
	return &SensorsGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSensorsGetParamsWithTimeout creates a new SensorsGetParams object
// with the ability to set a timeout on a request.
func NewSensorsGetParamsWithTimeout(timeout time.Duration) *SensorsGetParams {
	return &SensorsGetParams{
		timeout: timeout,
	}
}

// NewSensorsGetParamsWithContext creates a new SensorsGetParams object
// with the ability to set a context for a request.
func NewSensorsGetParamsWithContext(ctx context.Context) *SensorsGetParams {
	return &SensorsGetParams{
		Context: ctx,
	}
}

// NewSensorsGetParamsWithHTTPClient creates a new SensorsGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewSensorsGetParamsWithHTTPClient(client *http.Client) *SensorsGetParams {
	return &SensorsGetParams{
		HTTPClient: client,
	}
}

/*
SensorsGetParams contains all the parameters to send to the API endpoint

	for the sensors get operation.

	Typically these are written to a http.Request.
*/
type SensorsGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* Index.

	   Filter by index
	*/
	Index string

	/* NodeUUID.

	   Filter by node.uuid
	*/
	NodeUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the sensors get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SensorsGetParams) WithDefaults() *SensorsGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the sensors get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SensorsGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the sensors get params
func (o *SensorsGetParams) WithTimeout(timeout time.Duration) *SensorsGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the sensors get params
func (o *SensorsGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the sensors get params
func (o *SensorsGetParams) WithContext(ctx context.Context) *SensorsGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the sensors get params
func (o *SensorsGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the sensors get params
func (o *SensorsGetParams) WithHTTPClient(client *http.Client) *SensorsGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the sensors get params
func (o *SensorsGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the sensors get params
func (o *SensorsGetParams) WithFields(fields []string) *SensorsGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the sensors get params
func (o *SensorsGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithIndex adds the index to the sensors get params
func (o *SensorsGetParams) WithIndex(index string) *SensorsGetParams {
	o.SetIndex(index)
	return o
}

// SetIndex adds the index to the sensors get params
func (o *SensorsGetParams) SetIndex(index string) {
	o.Index = index
}

// WithNodeUUID adds the nodeUUID to the sensors get params
func (o *SensorsGetParams) WithNodeUUID(nodeUUID string) *SensorsGetParams {
	o.SetNodeUUID(nodeUUID)
	return o
}

// SetNodeUUID adds the nodeUuid to the sensors get params
func (o *SensorsGetParams) SetNodeUUID(nodeUUID string) {
	o.NodeUUID = nodeUUID
}

// WriteToRequest writes these params to a swagger request
func (o *SensorsGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param index
	if err := r.SetPathParam("index", o.Index); err != nil {
		return err
	}

	// path param node.uuid
	if err := r.SetPathParam("node.uuid", o.NodeUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamSensorsGet binds the parameter fields
func (o *SensorsGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
