// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSoftwareDownloadGetParams creates a new SoftwareDownloadGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSoftwareDownloadGetParams() *SoftwareDownloadGetParams {
	return &SoftwareDownloadGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSoftwareDownloadGetParamsWithTimeout creates a new SoftwareDownloadGetParams object
// with the ability to set a timeout on a request.
func NewSoftwareDownloadGetParamsWithTimeout(timeout time.Duration) *SoftwareDownloadGetParams {
	return &SoftwareDownloadGetParams{
		timeout: timeout,
	}
}

// NewSoftwareDownloadGetParamsWithContext creates a new SoftwareDownloadGetParams object
// with the ability to set a context for a request.
func NewSoftwareDownloadGetParamsWithContext(ctx context.Context) *SoftwareDownloadGetParams {
	return &SoftwareDownloadGetParams{
		Context: ctx,
	}
}

// NewSoftwareDownloadGetParamsWithHTTPClient creates a new SoftwareDownloadGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewSoftwareDownloadGetParamsWithHTTPClient(client *http.Client) *SoftwareDownloadGetParams {
	return &SoftwareDownloadGetParams{
		HTTPClient: client,
	}
}

/*
SoftwareDownloadGetParams contains all the parameters to send to the API endpoint

	for the software download get operation.

	Typically these are written to a http.Request.
*/
type SoftwareDownloadGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the software download get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SoftwareDownloadGetParams) WithDefaults() *SoftwareDownloadGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the software download get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SoftwareDownloadGetParams) SetDefaults() {
	var (
		returnTimeoutDefault = int64(15)
	)

	val := SoftwareDownloadGetParams{
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the software download get params
func (o *SoftwareDownloadGetParams) WithTimeout(timeout time.Duration) *SoftwareDownloadGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the software download get params
func (o *SoftwareDownloadGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the software download get params
func (o *SoftwareDownloadGetParams) WithContext(ctx context.Context) *SoftwareDownloadGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the software download get params
func (o *SoftwareDownloadGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the software download get params
func (o *SoftwareDownloadGetParams) WithHTTPClient(client *http.Client) *SoftwareDownloadGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the software download get params
func (o *SoftwareDownloadGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the software download get params
func (o *SoftwareDownloadGetParams) WithFields(fields []string) *SoftwareDownloadGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the software download get params
func (o *SoftwareDownloadGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithReturnTimeout adds the returnTimeout to the software download get params
func (o *SoftwareDownloadGetParams) WithReturnTimeout(returnTimeout *int64) *SoftwareDownloadGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the software download get params
func (o *SoftwareDownloadGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WriteToRequest writes these params to a swagger request
func (o *SoftwareDownloadGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamSoftwareDownloadGet binds the parameter fields
func (o *SoftwareDownloadGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
