// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSoftwareGetParams creates a new SoftwareGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSoftwareGetParams() *SoftwareGetParams {
	return &SoftwareGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSoftwareGetParamsWithTimeout creates a new SoftwareGetParams object
// with the ability to set a timeout on a request.
func NewSoftwareGetParamsWithTimeout(timeout time.Duration) *SoftwareGetParams {
	return &SoftwareGetParams{
		timeout: timeout,
	}
}

// NewSoftwareGetParamsWithContext creates a new SoftwareGetParams object
// with the ability to set a context for a request.
func NewSoftwareGetParamsWithContext(ctx context.Context) *SoftwareGetParams {
	return &SoftwareGetParams{
		Context: ctx,
	}
}

// NewSoftwareGetParamsWithHTTPClient creates a new SoftwareGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewSoftwareGetParamsWithHTTPClient(client *http.Client) *SoftwareGetParams {
	return &SoftwareGetParams{
		HTTPClient: client,
	}
}

/*
SoftwareGetParams contains all the parameters to send to the API endpoint

	for the software get operation.

	Typically these are written to a http.Request.
*/
type SoftwareGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the software get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SoftwareGetParams) WithDefaults() *SoftwareGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the software get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SoftwareGetParams) SetDefaults() {
	var (
		returnTimeoutDefault = int64(15)
	)

	val := SoftwareGetParams{
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the software get params
func (o *SoftwareGetParams) WithTimeout(timeout time.Duration) *SoftwareGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the software get params
func (o *SoftwareGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the software get params
func (o *SoftwareGetParams) WithContext(ctx context.Context) *SoftwareGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the software get params
func (o *SoftwareGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the software get params
func (o *SoftwareGetParams) WithHTTPClient(client *http.Client) *SoftwareGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the software get params
func (o *SoftwareGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the software get params
func (o *SoftwareGetParams) WithFields(fields []string) *SoftwareGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the software get params
func (o *SoftwareGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithReturnTimeout adds the returnTimeout to the software get params
func (o *SoftwareGetParams) WithReturnTimeout(returnTimeout *int64) *SoftwareGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the software get params
func (o *SoftwareGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WriteToRequest writes these params to a swagger request
func (o *SoftwareGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamSoftwareGet binds the parameter fields
func (o *SoftwareGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
