// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SoftwareGetReader is a Reader for the SoftwareGet structure.
type SoftwareGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SoftwareGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSoftwareGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSoftwareGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSoftwareGetOK creates a SoftwareGetOK with default headers values
func NewSoftwareGetOK() *SoftwareGetOK {
	return &SoftwareGetOK{}
}

/*
SoftwareGetOK describes a response with status code 200, with default header values.

OK
*/
type SoftwareGetOK struct {
	Payload *models.SoftwareReference
}

// IsSuccess returns true when this software get o k response has a 2xx status code
func (o *SoftwareGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this software get o k response has a 3xx status code
func (o *SoftwareGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this software get o k response has a 4xx status code
func (o *SoftwareGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this software get o k response has a 5xx status code
func (o *SoftwareGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this software get o k response a status code equal to that given
func (o *SoftwareGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the software get o k response
func (o *SoftwareGetOK) Code() int {
	return 200
}

func (o *SoftwareGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cluster/software][%d] softwareGetOK %s", 200, payload)
}

func (o *SoftwareGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cluster/software][%d] softwareGetOK %s", 200, payload)
}

func (o *SoftwareGetOK) GetPayload() *models.SoftwareReference {
	return o.Payload
}

func (o *SoftwareGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SoftwareReference)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSoftwareGetDefault creates a SoftwareGetDefault with default headers values
func NewSoftwareGetDefault(code int) *SoftwareGetDefault {
	return &SoftwareGetDefault{
		_statusCode: code,
	}
}

/*
	SoftwareGetDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 1048576 | Error initializing software image information. |
| 1048577 | Software image information not initialized. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type SoftwareGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this software get default response has a 2xx status code
func (o *SoftwareGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this software get default response has a 3xx status code
func (o *SoftwareGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this software get default response has a 4xx status code
func (o *SoftwareGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this software get default response has a 5xx status code
func (o *SoftwareGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this software get default response a status code equal to that given
func (o *SoftwareGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the software get default response
func (o *SoftwareGetDefault) Code() int {
	return o._statusCode
}

func (o *SoftwareGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cluster/software][%d] software_get default %s", o._statusCode, payload)
}

func (o *SoftwareGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cluster/software][%d] software_get default %s", o._statusCode, payload)
}

func (o *SoftwareGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SoftwareGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
