// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SoftwareHistoryCollectionGetReader is a Reader for the SoftwareHistoryCollectionGet structure.
type SoftwareHistoryCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SoftwareHistoryCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSoftwareHistoryCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSoftwareHistoryCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSoftwareHistoryCollectionGetOK creates a SoftwareHistoryCollectionGetOK with default headers values
func NewSoftwareHistoryCollectionGetOK() *SoftwareHistoryCollectionGetOK {
	return &SoftwareHistoryCollectionGetOK{}
}

/*
SoftwareHistoryCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type SoftwareHistoryCollectionGetOK struct {
	Payload *models.SoftwareHistoryResponse
}

// IsSuccess returns true when this software history collection get o k response has a 2xx status code
func (o *SoftwareHistoryCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this software history collection get o k response has a 3xx status code
func (o *SoftwareHistoryCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this software history collection get o k response has a 4xx status code
func (o *SoftwareHistoryCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this software history collection get o k response has a 5xx status code
func (o *SoftwareHistoryCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this software history collection get o k response a status code equal to that given
func (o *SoftwareHistoryCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the software history collection get o k response
func (o *SoftwareHistoryCollectionGetOK) Code() int {
	return 200
}

func (o *SoftwareHistoryCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cluster/software/history][%d] softwareHistoryCollectionGetOK %s", 200, payload)
}

func (o *SoftwareHistoryCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cluster/software/history][%d] softwareHistoryCollectionGetOK %s", 200, payload)
}

func (o *SoftwareHistoryCollectionGetOK) GetPayload() *models.SoftwareHistoryResponse {
	return o.Payload
}

func (o *SoftwareHistoryCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SoftwareHistoryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSoftwareHistoryCollectionGetDefault creates a SoftwareHistoryCollectionGetDefault with default headers values
func NewSoftwareHistoryCollectionGetDefault(code int) *SoftwareHistoryCollectionGetDefault {
	return &SoftwareHistoryCollectionGetDefault{
		_statusCode: code,
	}
}

/*
SoftwareHistoryCollectionGetDefault describes a response with status code -1, with default header values.

Error
*/
type SoftwareHistoryCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this software history collection get default response has a 2xx status code
func (o *SoftwareHistoryCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this software history collection get default response has a 3xx status code
func (o *SoftwareHistoryCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this software history collection get default response has a 4xx status code
func (o *SoftwareHistoryCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this software history collection get default response has a 5xx status code
func (o *SoftwareHistoryCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this software history collection get default response a status code equal to that given
func (o *SoftwareHistoryCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the software history collection get default response
func (o *SoftwareHistoryCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *SoftwareHistoryCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cluster/software/history][%d] software_history_collection_get default %s", o._statusCode, payload)
}

func (o *SoftwareHistoryCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cluster/software/history][%d] software_history_collection_get default %s", o._statusCode, payload)
}

func (o *SoftwareHistoryCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SoftwareHistoryCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
