// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSoftwarePackageDeleteCollectionParams creates a new SoftwarePackageDeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSoftwarePackageDeleteCollectionParams() *SoftwarePackageDeleteCollectionParams {
	return &SoftwarePackageDeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSoftwarePackageDeleteCollectionParamsWithTimeout creates a new SoftwarePackageDeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewSoftwarePackageDeleteCollectionParamsWithTimeout(timeout time.Duration) *SoftwarePackageDeleteCollectionParams {
	return &SoftwarePackageDeleteCollectionParams{
		timeout: timeout,
	}
}

// NewSoftwarePackageDeleteCollectionParamsWithContext creates a new SoftwarePackageDeleteCollectionParams object
// with the ability to set a context for a request.
func NewSoftwarePackageDeleteCollectionParamsWithContext(ctx context.Context) *SoftwarePackageDeleteCollectionParams {
	return &SoftwarePackageDeleteCollectionParams{
		Context: ctx,
	}
}

// NewSoftwarePackageDeleteCollectionParamsWithHTTPClient creates a new SoftwarePackageDeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewSoftwarePackageDeleteCollectionParamsWithHTTPClient(client *http.Client) *SoftwarePackageDeleteCollectionParams {
	return &SoftwarePackageDeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
SoftwarePackageDeleteCollectionParams contains all the parameters to send to the API endpoint

	for the software package delete collection operation.

	Typically these are written to a http.Request.
*/
type SoftwarePackageDeleteCollectionParams struct {

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* CreateTime.

	   Filter by create_time
	*/
	CreateTime *string

	/* Info.

	   Info specification
	*/
	Info SoftwarePackageDeleteCollectionBody

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* Version.

	   Filter by version
	*/
	Version *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the software package delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SoftwarePackageDeleteCollectionParams) WithDefaults() *SoftwarePackageDeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the software package delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SoftwarePackageDeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := SoftwarePackageDeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the software package delete collection params
func (o *SoftwarePackageDeleteCollectionParams) WithTimeout(timeout time.Duration) *SoftwarePackageDeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the software package delete collection params
func (o *SoftwarePackageDeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the software package delete collection params
func (o *SoftwarePackageDeleteCollectionParams) WithContext(ctx context.Context) *SoftwarePackageDeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the software package delete collection params
func (o *SoftwarePackageDeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the software package delete collection params
func (o *SoftwarePackageDeleteCollectionParams) WithHTTPClient(client *http.Client) *SoftwarePackageDeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the software package delete collection params
func (o *SoftwarePackageDeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithContinueOnFailure adds the continueOnFailure to the software package delete collection params
func (o *SoftwarePackageDeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *SoftwarePackageDeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the software package delete collection params
func (o *SoftwarePackageDeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithCreateTime adds the createTime to the software package delete collection params
func (o *SoftwarePackageDeleteCollectionParams) WithCreateTime(createTime *string) *SoftwarePackageDeleteCollectionParams {
	o.SetCreateTime(createTime)
	return o
}

// SetCreateTime adds the createTime to the software package delete collection params
func (o *SoftwarePackageDeleteCollectionParams) SetCreateTime(createTime *string) {
	o.CreateTime = createTime
}

// WithInfo adds the info to the software package delete collection params
func (o *SoftwarePackageDeleteCollectionParams) WithInfo(info SoftwarePackageDeleteCollectionBody) *SoftwarePackageDeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the software package delete collection params
func (o *SoftwarePackageDeleteCollectionParams) SetInfo(info SoftwarePackageDeleteCollectionBody) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the software package delete collection params
func (o *SoftwarePackageDeleteCollectionParams) WithReturnRecords(returnRecords *bool) *SoftwarePackageDeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the software package delete collection params
func (o *SoftwarePackageDeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the software package delete collection params
func (o *SoftwarePackageDeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *SoftwarePackageDeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the software package delete collection params
func (o *SoftwarePackageDeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the software package delete collection params
func (o *SoftwarePackageDeleteCollectionParams) WithSerialRecords(serialRecords *bool) *SoftwarePackageDeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the software package delete collection params
func (o *SoftwarePackageDeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithVersion adds the version to the software package delete collection params
func (o *SoftwarePackageDeleteCollectionParams) WithVersion(version *string) *SoftwarePackageDeleteCollectionParams {
	o.SetVersion(version)
	return o
}

// SetVersion adds the version to the software package delete collection params
func (o *SoftwarePackageDeleteCollectionParams) SetVersion(version *string) {
	o.Version = version
}

// WriteToRequest writes these params to a swagger request
func (o *SoftwarePackageDeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.CreateTime != nil {

		// query param create_time
		var qrCreateTime string

		if o.CreateTime != nil {
			qrCreateTime = *o.CreateTime
		}
		qCreateTime := qrCreateTime
		if qCreateTime != "" {

			if err := r.SetQueryParam("create_time", qCreateTime); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.Version != nil {

		// query param version
		var qrVersion string

		if o.Version != nil {
			qrVersion = *o.Version
		}
		qVersion := qrVersion
		if qVersion != "" {

			if err := r.SetQueryParam("version", qVersion); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
