// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SoftwarePackageDeleteCollectionReader is a Reader for the SoftwarePackageDeleteCollection structure.
type SoftwarePackageDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SoftwarePackageDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSoftwarePackageDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewSoftwarePackageDeleteCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSoftwarePackageDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSoftwarePackageDeleteCollectionOK creates a SoftwarePackageDeleteCollectionOK with default headers values
func NewSoftwarePackageDeleteCollectionOK() *SoftwarePackageDeleteCollectionOK {
	return &SoftwarePackageDeleteCollectionOK{}
}

/*
SoftwarePackageDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type SoftwarePackageDeleteCollectionOK struct {
	Payload *models.SoftwarePackageJobLinkResponse
}

// IsSuccess returns true when this software package delete collection o k response has a 2xx status code
func (o *SoftwarePackageDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this software package delete collection o k response has a 3xx status code
func (o *SoftwarePackageDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this software package delete collection o k response has a 4xx status code
func (o *SoftwarePackageDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this software package delete collection o k response has a 5xx status code
func (o *SoftwarePackageDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this software package delete collection o k response a status code equal to that given
func (o *SoftwarePackageDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the software package delete collection o k response
func (o *SoftwarePackageDeleteCollectionOK) Code() int {
	return 200
}

func (o *SoftwarePackageDeleteCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /cluster/software/packages][%d] softwarePackageDeleteCollectionOK %s", 200, payload)
}

func (o *SoftwarePackageDeleteCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /cluster/software/packages][%d] softwarePackageDeleteCollectionOK %s", 200, payload)
}

func (o *SoftwarePackageDeleteCollectionOK) GetPayload() *models.SoftwarePackageJobLinkResponse {
	return o.Payload
}

func (o *SoftwarePackageDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SoftwarePackageJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSoftwarePackageDeleteCollectionAccepted creates a SoftwarePackageDeleteCollectionAccepted with default headers values
func NewSoftwarePackageDeleteCollectionAccepted() *SoftwarePackageDeleteCollectionAccepted {
	return &SoftwarePackageDeleteCollectionAccepted{}
}

/*
SoftwarePackageDeleteCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type SoftwarePackageDeleteCollectionAccepted struct {
	Payload *models.SoftwarePackageJobLinkResponse
}

// IsSuccess returns true when this software package delete collection accepted response has a 2xx status code
func (o *SoftwarePackageDeleteCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this software package delete collection accepted response has a 3xx status code
func (o *SoftwarePackageDeleteCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this software package delete collection accepted response has a 4xx status code
func (o *SoftwarePackageDeleteCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this software package delete collection accepted response has a 5xx status code
func (o *SoftwarePackageDeleteCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this software package delete collection accepted response a status code equal to that given
func (o *SoftwarePackageDeleteCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the software package delete collection accepted response
func (o *SoftwarePackageDeleteCollectionAccepted) Code() int {
	return 202
}

func (o *SoftwarePackageDeleteCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /cluster/software/packages][%d] softwarePackageDeleteCollectionAccepted %s", 202, payload)
}

func (o *SoftwarePackageDeleteCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /cluster/software/packages][%d] softwarePackageDeleteCollectionAccepted %s", 202, payload)
}

func (o *SoftwarePackageDeleteCollectionAccepted) GetPayload() *models.SoftwarePackageJobLinkResponse {
	return o.Payload
}

func (o *SoftwarePackageDeleteCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SoftwarePackageJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSoftwarePackageDeleteCollectionDefault creates a SoftwarePackageDeleteCollectionDefault with default headers values
func NewSoftwarePackageDeleteCollectionDefault(code int) *SoftwarePackageDeleteCollectionDefault {
	return &SoftwarePackageDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	SoftwarePackageDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 10551315 | The repository does not contain any packages. |
| 10551322 | An internal error occurred while retrieving the package cleanup status. |
| 10551323 | An internal error occurred while removing the package information on a node. |
| 10551324 | An internal error occurred while removing the package information on multiple nodes. |
| 10551325 | The required package could not be found in the repository. |
| 10551326 | An error occurred while deleting older package cleanup tasks. |
| 10551346 | A validation is in progress, retry command after it is completed. |
| 10551367 | The repository is busy, retry the operation later. |
| 10551388 | The package delete operation timed out. |
| 10551892 | Package delete failed due to an unhealthy node. Restore the node to a healthy state, then retry the operation. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type SoftwarePackageDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this software package delete collection default response has a 2xx status code
func (o *SoftwarePackageDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this software package delete collection default response has a 3xx status code
func (o *SoftwarePackageDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this software package delete collection default response has a 4xx status code
func (o *SoftwarePackageDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this software package delete collection default response has a 5xx status code
func (o *SoftwarePackageDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this software package delete collection default response a status code equal to that given
func (o *SoftwarePackageDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the software package delete collection default response
func (o *SoftwarePackageDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *SoftwarePackageDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /cluster/software/packages][%d] software_package_delete_collection default %s", o._statusCode, payload)
}

func (o *SoftwarePackageDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /cluster/software/packages][%d] software_package_delete_collection default %s", o._statusCode, payload)
}

func (o *SoftwarePackageDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SoftwarePackageDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
SoftwarePackageDeleteCollectionBody software package delete collection body
swagger:model SoftwarePackageDeleteCollectionBody
*/
type SoftwarePackageDeleteCollectionBody struct {

	// software package response inline records
	SoftwarePackageResponseInlineRecords []*models.SoftwarePackage `json:"records,omitempty"`
}

// Validate validates this software package delete collection body
func (o *SoftwarePackageDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSoftwarePackageResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SoftwarePackageDeleteCollectionBody) validateSoftwarePackageResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.SoftwarePackageResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.SoftwarePackageResponseInlineRecords); i++ {
		if swag.IsZero(o.SoftwarePackageResponseInlineRecords[i]) { // not required
			continue
		}

		if o.SoftwarePackageResponseInlineRecords[i] != nil {
			if err := o.SoftwarePackageResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this software package delete collection body based on the context it is used
func (o *SoftwarePackageDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSoftwarePackageResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SoftwarePackageDeleteCollectionBody) contextValidateSoftwarePackageResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.SoftwarePackageResponseInlineRecords); i++ {

		if o.SoftwarePackageResponseInlineRecords[i] != nil {
			if err := o.SoftwarePackageResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *SoftwarePackageDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SoftwarePackageDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res SoftwarePackageDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
