// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SoftwarePackageDeleteReader is a Reader for the SoftwarePackageDelete structure.
type SoftwarePackageDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SoftwarePackageDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSoftwarePackageDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewSoftwarePackageDeleteAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSoftwarePackageDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSoftwarePackageDeleteOK creates a SoftwarePackageDeleteOK with default headers values
func NewSoftwarePackageDeleteOK() *SoftwarePackageDeleteOK {
	return &SoftwarePackageDeleteOK{}
}

/*
SoftwarePackageDeleteOK describes a response with status code 200, with default header values.

OK
*/
type SoftwarePackageDeleteOK struct {
	Payload *models.SoftwarePackageJobLinkResponse
}

// IsSuccess returns true when this software package delete o k response has a 2xx status code
func (o *SoftwarePackageDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this software package delete o k response has a 3xx status code
func (o *SoftwarePackageDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this software package delete o k response has a 4xx status code
func (o *SoftwarePackageDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this software package delete o k response has a 5xx status code
func (o *SoftwarePackageDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this software package delete o k response a status code equal to that given
func (o *SoftwarePackageDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the software package delete o k response
func (o *SoftwarePackageDeleteOK) Code() int {
	return 200
}

func (o *SoftwarePackageDeleteOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /cluster/software/packages/{version}][%d] softwarePackageDeleteOK %s", 200, payload)
}

func (o *SoftwarePackageDeleteOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /cluster/software/packages/{version}][%d] softwarePackageDeleteOK %s", 200, payload)
}

func (o *SoftwarePackageDeleteOK) GetPayload() *models.SoftwarePackageJobLinkResponse {
	return o.Payload
}

func (o *SoftwarePackageDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SoftwarePackageJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSoftwarePackageDeleteAccepted creates a SoftwarePackageDeleteAccepted with default headers values
func NewSoftwarePackageDeleteAccepted() *SoftwarePackageDeleteAccepted {
	return &SoftwarePackageDeleteAccepted{}
}

/*
SoftwarePackageDeleteAccepted describes a response with status code 202, with default header values.

Accepted
*/
type SoftwarePackageDeleteAccepted struct {
	Payload *models.SoftwarePackageJobLinkResponse
}

// IsSuccess returns true when this software package delete accepted response has a 2xx status code
func (o *SoftwarePackageDeleteAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this software package delete accepted response has a 3xx status code
func (o *SoftwarePackageDeleteAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this software package delete accepted response has a 4xx status code
func (o *SoftwarePackageDeleteAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this software package delete accepted response has a 5xx status code
func (o *SoftwarePackageDeleteAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this software package delete accepted response a status code equal to that given
func (o *SoftwarePackageDeleteAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the software package delete accepted response
func (o *SoftwarePackageDeleteAccepted) Code() int {
	return 202
}

func (o *SoftwarePackageDeleteAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /cluster/software/packages/{version}][%d] softwarePackageDeleteAccepted %s", 202, payload)
}

func (o *SoftwarePackageDeleteAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /cluster/software/packages/{version}][%d] softwarePackageDeleteAccepted %s", 202, payload)
}

func (o *SoftwarePackageDeleteAccepted) GetPayload() *models.SoftwarePackageJobLinkResponse {
	return o.Payload
}

func (o *SoftwarePackageDeleteAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SoftwarePackageJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSoftwarePackageDeleteDefault creates a SoftwarePackageDeleteDefault with default headers values
func NewSoftwarePackageDeleteDefault(code int) *SoftwarePackageDeleteDefault {
	return &SoftwarePackageDeleteDefault{
		_statusCode: code,
	}
}

/*
	SoftwarePackageDeleteDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 10551315 | The repository does not contain any packages. |
| 10551322 | An internal error occurred while retrieving the package cleanup status. |
| 10551323 | An internal error occurred while removing the package information on a node. |
| 10551324 | An internal error occurred while removing the package information on multiple nodes. |
| 10551325 | The required package could not be found in the repository. |
| 10551326 | An error occurred while deleting older package cleanup tasks. |
| 10551346 | A validation is in progress, retry command after it is completed. |
| 10551367 | The repository is busy, retry the operation later. |
| 10551388 | The package delete operation timed out. |
| 10551892 | Package delete failed due to an unhealthy node. Restore the node to a healthy state, then retry the operation. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type SoftwarePackageDeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this software package delete default response has a 2xx status code
func (o *SoftwarePackageDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this software package delete default response has a 3xx status code
func (o *SoftwarePackageDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this software package delete default response has a 4xx status code
func (o *SoftwarePackageDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this software package delete default response has a 5xx status code
func (o *SoftwarePackageDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this software package delete default response a status code equal to that given
func (o *SoftwarePackageDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the software package delete default response
func (o *SoftwarePackageDeleteDefault) Code() int {
	return o._statusCode
}

func (o *SoftwarePackageDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /cluster/software/packages/{version}][%d] software_package_delete default %s", o._statusCode, payload)
}

func (o *SoftwarePackageDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /cluster/software/packages/{version}][%d] software_package_delete default %s", o._statusCode, payload)
}

func (o *SoftwarePackageDeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SoftwarePackageDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
