// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// WebGetReader is a Reader for the WebGet structure.
type WebGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WebGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWebGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWebGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWebGetOK creates a WebGetOK with default headers values
func NewWebGetOK() *WebGetOK {
	return &WebGetOK{}
}

/*
WebGetOK describes a response with status code 200, with default header values.

OK
*/
type WebGetOK struct {
	Payload *models.Web
}

// IsSuccess returns true when this web get o k response has a 2xx status code
func (o *WebGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this web get o k response has a 3xx status code
func (o *WebGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this web get o k response has a 4xx status code
func (o *WebGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this web get o k response has a 5xx status code
func (o *WebGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this web get o k response a status code equal to that given
func (o *WebGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the web get o k response
func (o *WebGetOK) Code() int {
	return 200
}

func (o *WebGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cluster/web][%d] webGetOK %s", 200, payload)
}

func (o *WebGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cluster/web][%d] webGetOK %s", 200, payload)
}

func (o *WebGetOK) GetPayload() *models.Web {
	return o.Payload
}

func (o *WebGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Web)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWebGetDefault creates a WebGetDefault with default headers values
func NewWebGetDefault(code int) *WebGetDefault {
	return &WebGetDefault{
		_statusCode: code,
	}
}

/*
WebGetDefault describes a response with status code -1, with default header values.

Error
*/
type WebGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this web get default response has a 2xx status code
func (o *WebGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this web get default response has a 3xx status code
func (o *WebGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this web get default response has a 4xx status code
func (o *WebGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this web get default response has a 5xx status code
func (o *WebGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this web get default response a status code equal to that given
func (o *WebGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the web get default response
func (o *WebGetDefault) Code() int {
	return o._statusCode
}

func (o *WebGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cluster/web][%d] web_get default %s", o._statusCode, payload)
}

func (o *WebGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cluster/web][%d] web_get default %s", o._statusCode, payload)
}

func (o *WebGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *WebGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
