// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewWebModifyParams creates a new WebModifyParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWebModifyParams() *WebModifyParams {
	return &WebModifyParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWebModifyParamsWithTimeout creates a new WebModifyParams object
// with the ability to set a timeout on a request.
func NewWebModifyParamsWithTimeout(timeout time.Duration) *WebModifyParams {
	return &WebModifyParams{
		timeout: timeout,
	}
}

// NewWebModifyParamsWithContext creates a new WebModifyParams object
// with the ability to set a context for a request.
func NewWebModifyParamsWithContext(ctx context.Context) *WebModifyParams {
	return &WebModifyParams{
		Context: ctx,
	}
}

// NewWebModifyParamsWithHTTPClient creates a new WebModifyParams object
// with the ability to set a custom HTTPClient for a request.
func NewWebModifyParamsWithHTTPClient(client *http.Client) *WebModifyParams {
	return &WebModifyParams{
		HTTPClient: client,
	}
}

/*
WebModifyParams contains all the parameters to send to the API endpoint

	for the web modify operation.

	Typically these are written to a http.Request.
*/
type WebModifyParams struct {

	/* Info.

	   Web services information
	*/
	Info *models.Web

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning. When doing a POST, PATCH, or DELETE operation on a single record, the default is 0 seconds.  This means that if an asynchronous operation is started, the server immediately returns HTTP code 202 (Accepted) along with a link to the job.  If a non-zero value is specified for POST, PATCH, or DELETE operations, ONTAP waits that length of time to see if the job completes so it can return something other than 202.
	*/
	ReturnTimeout *int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the web modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WebModifyParams) WithDefaults() *WebModifyParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the web modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WebModifyParams) SetDefaults() {
	var (
		returnTimeoutDefault = int64(0)
	)

	val := WebModifyParams{
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the web modify params
func (o *WebModifyParams) WithTimeout(timeout time.Duration) *WebModifyParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the web modify params
func (o *WebModifyParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the web modify params
func (o *WebModifyParams) WithContext(ctx context.Context) *WebModifyParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the web modify params
func (o *WebModifyParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the web modify params
func (o *WebModifyParams) WithHTTPClient(client *http.Client) *WebModifyParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the web modify params
func (o *WebModifyParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the web modify params
func (o *WebModifyParams) WithInfo(info *models.Web) *WebModifyParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the web modify params
func (o *WebModifyParams) SetInfo(info *models.Web) {
	o.Info = info
}

// WithReturnTimeout adds the returnTimeout to the web modify params
func (o *WebModifyParams) WithReturnTimeout(returnTimeout *int64) *WebModifyParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the web modify params
func (o *WebModifyParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WriteToRequest writes these params to a swagger request
func (o *WebModifyParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
