// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewDataEngineACLCollectionGetParams creates a new DataEngineACLCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDataEngineACLCollectionGetParams() *DataEngineACLCollectionGetParams {
	return &DataEngineACLCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDataEngineACLCollectionGetParamsWithTimeout creates a new DataEngineACLCollectionGetParams object
// with the ability to set a timeout on a request.
func NewDataEngineACLCollectionGetParamsWithTimeout(timeout time.Duration) *DataEngineACLCollectionGetParams {
	return &DataEngineACLCollectionGetParams{
		timeout: timeout,
	}
}

// NewDataEngineACLCollectionGetParamsWithContext creates a new DataEngineACLCollectionGetParams object
// with the ability to set a context for a request.
func NewDataEngineACLCollectionGetParamsWithContext(ctx context.Context) *DataEngineACLCollectionGetParams {
	return &DataEngineACLCollectionGetParams{
		Context: ctx,
	}
}

// NewDataEngineACLCollectionGetParamsWithHTTPClient creates a new DataEngineACLCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewDataEngineACLCollectionGetParamsWithHTTPClient(client *http.Client) *DataEngineACLCollectionGetParams {
	return &DataEngineACLCollectionGetParams{
		HTTPClient: client,
	}
}

/*
DataEngineACLCollectionGetParams contains all the parameters to send to the API endpoint

	for the data engine acl collection get operation.

	Typically these are written to a http.Request.
*/
type DataEngineACLCollectionGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* UserOrGroupAllocationTime.

	   Filter by user_or_group.allocation_time
	*/
	UserOrGroupAllocationTime *string

	/* UserOrGroupName.

	   Filter by user_or_group.name
	*/
	UserOrGroupName *string

	/* WorkspaceName.

	   Filter by workspace.name
	*/
	WorkspaceName *string

	/* WorkspaceUUID.

	   Unique identifier of the workspace.
	*/
	WorkspaceUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the data engine acl collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DataEngineACLCollectionGetParams) WithDefaults() *DataEngineACLCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the data engine acl collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DataEngineACLCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := DataEngineACLCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the data engine acl collection get params
func (o *DataEngineACLCollectionGetParams) WithTimeout(timeout time.Duration) *DataEngineACLCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the data engine acl collection get params
func (o *DataEngineACLCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the data engine acl collection get params
func (o *DataEngineACLCollectionGetParams) WithContext(ctx context.Context) *DataEngineACLCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the data engine acl collection get params
func (o *DataEngineACLCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the data engine acl collection get params
func (o *DataEngineACLCollectionGetParams) WithHTTPClient(client *http.Client) *DataEngineACLCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the data engine acl collection get params
func (o *DataEngineACLCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the data engine acl collection get params
func (o *DataEngineACLCollectionGetParams) WithFields(fields []string) *DataEngineACLCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the data engine acl collection get params
func (o *DataEngineACLCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithMaxRecords adds the maxRecords to the data engine acl collection get params
func (o *DataEngineACLCollectionGetParams) WithMaxRecords(maxRecords *int64) *DataEngineACLCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the data engine acl collection get params
func (o *DataEngineACLCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithOrderBy adds the orderBy to the data engine acl collection get params
func (o *DataEngineACLCollectionGetParams) WithOrderBy(orderBy []string) *DataEngineACLCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the data engine acl collection get params
func (o *DataEngineACLCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the data engine acl collection get params
func (o *DataEngineACLCollectionGetParams) WithReturnRecords(returnRecords *bool) *DataEngineACLCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the data engine acl collection get params
func (o *DataEngineACLCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the data engine acl collection get params
func (o *DataEngineACLCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *DataEngineACLCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the data engine acl collection get params
func (o *DataEngineACLCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithUserOrGroupAllocationTime adds the userOrGroupAllocationTime to the data engine acl collection get params
func (o *DataEngineACLCollectionGetParams) WithUserOrGroupAllocationTime(userOrGroupAllocationTime *string) *DataEngineACLCollectionGetParams {
	o.SetUserOrGroupAllocationTime(userOrGroupAllocationTime)
	return o
}

// SetUserOrGroupAllocationTime adds the userOrGroupAllocationTime to the data engine acl collection get params
func (o *DataEngineACLCollectionGetParams) SetUserOrGroupAllocationTime(userOrGroupAllocationTime *string) {
	o.UserOrGroupAllocationTime = userOrGroupAllocationTime
}

// WithUserOrGroupName adds the userOrGroupName to the data engine acl collection get params
func (o *DataEngineACLCollectionGetParams) WithUserOrGroupName(userOrGroupName *string) *DataEngineACLCollectionGetParams {
	o.SetUserOrGroupName(userOrGroupName)
	return o
}

// SetUserOrGroupName adds the userOrGroupName to the data engine acl collection get params
func (o *DataEngineACLCollectionGetParams) SetUserOrGroupName(userOrGroupName *string) {
	o.UserOrGroupName = userOrGroupName
}

// WithWorkspaceName adds the workspaceName to the data engine acl collection get params
func (o *DataEngineACLCollectionGetParams) WithWorkspaceName(workspaceName *string) *DataEngineACLCollectionGetParams {
	o.SetWorkspaceName(workspaceName)
	return o
}

// SetWorkspaceName adds the workspaceName to the data engine acl collection get params
func (o *DataEngineACLCollectionGetParams) SetWorkspaceName(workspaceName *string) {
	o.WorkspaceName = workspaceName
}

// WithWorkspaceUUID adds the workspaceUUID to the data engine acl collection get params
func (o *DataEngineACLCollectionGetParams) WithWorkspaceUUID(workspaceUUID string) *DataEngineACLCollectionGetParams {
	o.SetWorkspaceUUID(workspaceUUID)
	return o
}

// SetWorkspaceUUID adds the workspaceUuid to the data engine acl collection get params
func (o *DataEngineACLCollectionGetParams) SetWorkspaceUUID(workspaceUUID string) {
	o.WorkspaceUUID = workspaceUUID
}

// WriteToRequest writes these params to a swagger request
func (o *DataEngineACLCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.UserOrGroupAllocationTime != nil {

		// query param user_or_group.allocation_time
		var qrUserOrGroupAllocationTime string

		if o.UserOrGroupAllocationTime != nil {
			qrUserOrGroupAllocationTime = *o.UserOrGroupAllocationTime
		}
		qUserOrGroupAllocationTime := qrUserOrGroupAllocationTime
		if qUserOrGroupAllocationTime != "" {

			if err := r.SetQueryParam("user_or_group.allocation_time", qUserOrGroupAllocationTime); err != nil {
				return err
			}
		}
	}

	if o.UserOrGroupName != nil {

		// query param user_or_group.name
		var qrUserOrGroupName string

		if o.UserOrGroupName != nil {
			qrUserOrGroupName = *o.UserOrGroupName
		}
		qUserOrGroupName := qrUserOrGroupName
		if qUserOrGroupName != "" {

			if err := r.SetQueryParam("user_or_group.name", qUserOrGroupName); err != nil {
				return err
			}
		}
	}

	if o.WorkspaceName != nil {

		// query param workspace.name
		var qrWorkspaceName string

		if o.WorkspaceName != nil {
			qrWorkspaceName = *o.WorkspaceName
		}
		qWorkspaceName := qrWorkspaceName
		if qWorkspaceName != "" {

			if err := r.SetQueryParam("workspace.name", qWorkspaceName); err != nil {
				return err
			}
		}
	}

	// path param workspace.uuid
	if err := r.SetPathParam("workspace.uuid", o.WorkspaceUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamDataEngineACLCollectionGet binds the parameter fields
func (o *DataEngineACLCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamDataEngineACLCollectionGet binds the parameter order_by
func (o *DataEngineACLCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
