// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DataEngineACLCollectionGetReader is a Reader for the DataEngineACLCollectionGet structure.
type DataEngineACLCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DataEngineACLCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDataEngineACLCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDataEngineACLCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDataEngineACLCollectionGetOK creates a DataEngineACLCollectionGetOK with default headers values
func NewDataEngineACLCollectionGetOK() *DataEngineACLCollectionGetOK {
	return &DataEngineACLCollectionGetOK{}
}

/*
DataEngineACLCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type DataEngineACLCollectionGetOK struct {
	Payload *models.DataEngineACLResponse
}

// IsSuccess returns true when this data engine Acl collection get o k response has a 2xx status code
func (o *DataEngineACLCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this data engine Acl collection get o k response has a 3xx status code
func (o *DataEngineACLCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this data engine Acl collection get o k response has a 4xx status code
func (o *DataEngineACLCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this data engine Acl collection get o k response has a 5xx status code
func (o *DataEngineACLCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this data engine Acl collection get o k response a status code equal to that given
func (o *DataEngineACLCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the data engine Acl collection get o k response
func (o *DataEngineACLCollectionGetOK) Code() int {
	return 200
}

func (o *DataEngineACLCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/acls][%d] dataEngineAclCollectionGetOK %s", 200, payload)
}

func (o *DataEngineACLCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/acls][%d] dataEngineAclCollectionGetOK %s", 200, payload)
}

func (o *DataEngineACLCollectionGetOK) GetPayload() *models.DataEngineACLResponse {
	return o.Payload
}

func (o *DataEngineACLCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DataEngineACLResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDataEngineACLCollectionGetDefault creates a DataEngineACLCollectionGetDefault with default headers values
func NewDataEngineACLCollectionGetDefault(code int) *DataEngineACLCollectionGetDefault {
	return &DataEngineACLCollectionGetDefault{
		_statusCode: code,
	}
}

/*
DataEngineACLCollectionGetDefault describes a response with status code -1, with default header values.

Error in retrieving the ACL for the workspace.
*/
type DataEngineACLCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this data engine acl collection get default response has a 2xx status code
func (o *DataEngineACLCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this data engine acl collection get default response has a 3xx status code
func (o *DataEngineACLCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this data engine acl collection get default response has a 4xx status code
func (o *DataEngineACLCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this data engine acl collection get default response has a 5xx status code
func (o *DataEngineACLCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this data engine acl collection get default response a status code equal to that given
func (o *DataEngineACLCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the data engine acl collection get default response
func (o *DataEngineACLCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *DataEngineACLCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/acls][%d] data_engine_acl_collection_get default %s", o._statusCode, payload)
}

func (o *DataEngineACLCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/acls][%d] data_engine_acl_collection_get default %s", o._statusCode, payload)
}

func (o *DataEngineACLCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DataEngineACLCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
