// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewDataEngineACLCreateParams creates a new DataEngineACLCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDataEngineACLCreateParams() *DataEngineACLCreateParams {
	return &DataEngineACLCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDataEngineACLCreateParamsWithTimeout creates a new DataEngineACLCreateParams object
// with the ability to set a timeout on a request.
func NewDataEngineACLCreateParamsWithTimeout(timeout time.Duration) *DataEngineACLCreateParams {
	return &DataEngineACLCreateParams{
		timeout: timeout,
	}
}

// NewDataEngineACLCreateParamsWithContext creates a new DataEngineACLCreateParams object
// with the ability to set a context for a request.
func NewDataEngineACLCreateParamsWithContext(ctx context.Context) *DataEngineACLCreateParams {
	return &DataEngineACLCreateParams{
		Context: ctx,
	}
}

// NewDataEngineACLCreateParamsWithHTTPClient creates a new DataEngineACLCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewDataEngineACLCreateParamsWithHTTPClient(client *http.Client) *DataEngineACLCreateParams {
	return &DataEngineACLCreateParams{
		HTTPClient: client,
	}
}

/*
DataEngineACLCreateParams contains all the parameters to send to the API endpoint

	for the data engine acl create operation.

	Typically these are written to a http.Request.
*/
type DataEngineACLCreateParams struct {

	/* Info.

	   ACL specification
	*/
	Info *models.DataEngineACL

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	/* WorkspaceUUID.

	   Unique identifier of the workspace.
	*/
	WorkspaceUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the data engine acl create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DataEngineACLCreateParams) WithDefaults() *DataEngineACLCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the data engine acl create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DataEngineACLCreateParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)
	)

	val := DataEngineACLCreateParams{
		ReturnRecords: &returnRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the data engine acl create params
func (o *DataEngineACLCreateParams) WithTimeout(timeout time.Duration) *DataEngineACLCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the data engine acl create params
func (o *DataEngineACLCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the data engine acl create params
func (o *DataEngineACLCreateParams) WithContext(ctx context.Context) *DataEngineACLCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the data engine acl create params
func (o *DataEngineACLCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the data engine acl create params
func (o *DataEngineACLCreateParams) WithHTTPClient(client *http.Client) *DataEngineACLCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the data engine acl create params
func (o *DataEngineACLCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the data engine acl create params
func (o *DataEngineACLCreateParams) WithInfo(info *models.DataEngineACL) *DataEngineACLCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the data engine acl create params
func (o *DataEngineACLCreateParams) SetInfo(info *models.DataEngineACL) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the data engine acl create params
func (o *DataEngineACLCreateParams) WithReturnRecords(returnRecords *bool) *DataEngineACLCreateParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the data engine acl create params
func (o *DataEngineACLCreateParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithWorkspaceUUID adds the workspaceUUID to the data engine acl create params
func (o *DataEngineACLCreateParams) WithWorkspaceUUID(workspaceUUID string) *DataEngineACLCreateParams {
	o.SetWorkspaceUUID(workspaceUUID)
	return o
}

// SetWorkspaceUUID adds the workspaceUuid to the data engine acl create params
func (o *DataEngineACLCreateParams) SetWorkspaceUUID(workspaceUUID string) {
	o.WorkspaceUUID = workspaceUUID
}

// WriteToRequest writes these params to a swagger request
func (o *DataEngineACLCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	// path param workspace.uuid
	if err := r.SetPathParam("workspace.uuid", o.WorkspaceUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
