// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DataEngineACLCreateReader is a Reader for the DataEngineACLCreate structure.
type DataEngineACLCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DataEngineACLCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewDataEngineACLCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDataEngineACLCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDataEngineACLCreateCreated creates a DataEngineACLCreateCreated with default headers values
func NewDataEngineACLCreateCreated() *DataEngineACLCreateCreated {
	return &DataEngineACLCreateCreated{}
}

/*
DataEngineACLCreateCreated describes a response with status code 201, with default header values.

Created
*/
type DataEngineACLCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.DataEngineACLResponse
}

// IsSuccess returns true when this data engine Acl create created response has a 2xx status code
func (o *DataEngineACLCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this data engine Acl create created response has a 3xx status code
func (o *DataEngineACLCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this data engine Acl create created response has a 4xx status code
func (o *DataEngineACLCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this data engine Acl create created response has a 5xx status code
func (o *DataEngineACLCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this data engine Acl create created response a status code equal to that given
func (o *DataEngineACLCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the data engine Acl create created response
func (o *DataEngineACLCreateCreated) Code() int {
	return 201
}

func (o *DataEngineACLCreateCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/workspaces/{workspace.uuid}/acls][%d] dataEngineAclCreateCreated %s", 201, payload)
}

func (o *DataEngineACLCreateCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/workspaces/{workspace.uuid}/acls][%d] dataEngineAclCreateCreated %s", 201, payload)
}

func (o *DataEngineACLCreateCreated) GetPayload() *models.DataEngineACLResponse {
	return o.Payload
}

func (o *DataEngineACLCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.DataEngineACLResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDataEngineACLCreateDefault creates a DataEngineACLCreateDefault with default headers values
func NewDataEngineACLCreateDefault(code int) *DataEngineACLCreateDefault {
	return &DataEngineACLCreateDefault{
		_statusCode: code,
	}
}

/*
DataEngineACLCreateDefault describes a response with status code -1, with default header values.

Error in creating the ACL for the workspace.
*/
type DataEngineACLCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this data engine acl create default response has a 2xx status code
func (o *DataEngineACLCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this data engine acl create default response has a 3xx status code
func (o *DataEngineACLCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this data engine acl create default response has a 4xx status code
func (o *DataEngineACLCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this data engine acl create default response has a 5xx status code
func (o *DataEngineACLCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this data engine acl create default response a status code equal to that given
func (o *DataEngineACLCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the data engine acl create default response
func (o *DataEngineACLCreateDefault) Code() int {
	return o._statusCode
}

func (o *DataEngineACLCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/workspaces/{workspace.uuid}/acls][%d] data_engine_acl_create default %s", o._statusCode, payload)
}

func (o *DataEngineACLCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/workspaces/{workspace.uuid}/acls][%d] data_engine_acl_create default %s", o._statusCode, payload)
}

func (o *DataEngineACLCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DataEngineACLCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
