// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewDataEngineACLDeleteCollectionParams creates a new DataEngineACLDeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDataEngineACLDeleteCollectionParams() *DataEngineACLDeleteCollectionParams {
	return &DataEngineACLDeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDataEngineACLDeleteCollectionParamsWithTimeout creates a new DataEngineACLDeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewDataEngineACLDeleteCollectionParamsWithTimeout(timeout time.Duration) *DataEngineACLDeleteCollectionParams {
	return &DataEngineACLDeleteCollectionParams{
		timeout: timeout,
	}
}

// NewDataEngineACLDeleteCollectionParamsWithContext creates a new DataEngineACLDeleteCollectionParams object
// with the ability to set a context for a request.
func NewDataEngineACLDeleteCollectionParamsWithContext(ctx context.Context) *DataEngineACLDeleteCollectionParams {
	return &DataEngineACLDeleteCollectionParams{
		Context: ctx,
	}
}

// NewDataEngineACLDeleteCollectionParamsWithHTTPClient creates a new DataEngineACLDeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewDataEngineACLDeleteCollectionParamsWithHTTPClient(client *http.Client) *DataEngineACLDeleteCollectionParams {
	return &DataEngineACLDeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
DataEngineACLDeleteCollectionParams contains all the parameters to send to the API endpoint

	for the data engine acl delete collection operation.

	Typically these are written to a http.Request.
*/
type DataEngineACLDeleteCollectionParams struct {

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* Info.

	   Info specification
	*/
	Info DataEngineACLDeleteCollectionBody

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* UserOrGroupAllocationTime.

	   Filter by user_or_group.allocation_time
	*/
	UserOrGroupAllocationTime *string

	/* UserOrGroupName.

	   Filter by user_or_group.name
	*/
	UserOrGroupName *string

	/* WorkspaceName.

	   Filter by workspace.name
	*/
	WorkspaceName *string

	/* WorkspaceUUID.

	   Unique identifier of the workspace.
	*/
	WorkspaceUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the data engine acl delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DataEngineACLDeleteCollectionParams) WithDefaults() *DataEngineACLDeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the data engine acl delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DataEngineACLDeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := DataEngineACLDeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the data engine acl delete collection params
func (o *DataEngineACLDeleteCollectionParams) WithTimeout(timeout time.Duration) *DataEngineACLDeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the data engine acl delete collection params
func (o *DataEngineACLDeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the data engine acl delete collection params
func (o *DataEngineACLDeleteCollectionParams) WithContext(ctx context.Context) *DataEngineACLDeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the data engine acl delete collection params
func (o *DataEngineACLDeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the data engine acl delete collection params
func (o *DataEngineACLDeleteCollectionParams) WithHTTPClient(client *http.Client) *DataEngineACLDeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the data engine acl delete collection params
func (o *DataEngineACLDeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithContinueOnFailure adds the continueOnFailure to the data engine acl delete collection params
func (o *DataEngineACLDeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *DataEngineACLDeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the data engine acl delete collection params
func (o *DataEngineACLDeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithInfo adds the info to the data engine acl delete collection params
func (o *DataEngineACLDeleteCollectionParams) WithInfo(info DataEngineACLDeleteCollectionBody) *DataEngineACLDeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the data engine acl delete collection params
func (o *DataEngineACLDeleteCollectionParams) SetInfo(info DataEngineACLDeleteCollectionBody) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the data engine acl delete collection params
func (o *DataEngineACLDeleteCollectionParams) WithReturnRecords(returnRecords *bool) *DataEngineACLDeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the data engine acl delete collection params
func (o *DataEngineACLDeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the data engine acl delete collection params
func (o *DataEngineACLDeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *DataEngineACLDeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the data engine acl delete collection params
func (o *DataEngineACLDeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the data engine acl delete collection params
func (o *DataEngineACLDeleteCollectionParams) WithSerialRecords(serialRecords *bool) *DataEngineACLDeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the data engine acl delete collection params
func (o *DataEngineACLDeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithUserOrGroupAllocationTime adds the userOrGroupAllocationTime to the data engine acl delete collection params
func (o *DataEngineACLDeleteCollectionParams) WithUserOrGroupAllocationTime(userOrGroupAllocationTime *string) *DataEngineACLDeleteCollectionParams {
	o.SetUserOrGroupAllocationTime(userOrGroupAllocationTime)
	return o
}

// SetUserOrGroupAllocationTime adds the userOrGroupAllocationTime to the data engine acl delete collection params
func (o *DataEngineACLDeleteCollectionParams) SetUserOrGroupAllocationTime(userOrGroupAllocationTime *string) {
	o.UserOrGroupAllocationTime = userOrGroupAllocationTime
}

// WithUserOrGroupName adds the userOrGroupName to the data engine acl delete collection params
func (o *DataEngineACLDeleteCollectionParams) WithUserOrGroupName(userOrGroupName *string) *DataEngineACLDeleteCollectionParams {
	o.SetUserOrGroupName(userOrGroupName)
	return o
}

// SetUserOrGroupName adds the userOrGroupName to the data engine acl delete collection params
func (o *DataEngineACLDeleteCollectionParams) SetUserOrGroupName(userOrGroupName *string) {
	o.UserOrGroupName = userOrGroupName
}

// WithWorkspaceName adds the workspaceName to the data engine acl delete collection params
func (o *DataEngineACLDeleteCollectionParams) WithWorkspaceName(workspaceName *string) *DataEngineACLDeleteCollectionParams {
	o.SetWorkspaceName(workspaceName)
	return o
}

// SetWorkspaceName adds the workspaceName to the data engine acl delete collection params
func (o *DataEngineACLDeleteCollectionParams) SetWorkspaceName(workspaceName *string) {
	o.WorkspaceName = workspaceName
}

// WithWorkspaceUUID adds the workspaceUUID to the data engine acl delete collection params
func (o *DataEngineACLDeleteCollectionParams) WithWorkspaceUUID(workspaceUUID string) *DataEngineACLDeleteCollectionParams {
	o.SetWorkspaceUUID(workspaceUUID)
	return o
}

// SetWorkspaceUUID adds the workspaceUuid to the data engine acl delete collection params
func (o *DataEngineACLDeleteCollectionParams) SetWorkspaceUUID(workspaceUUID string) {
	o.WorkspaceUUID = workspaceUUID
}

// WriteToRequest writes these params to a swagger request
func (o *DataEngineACLDeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.UserOrGroupAllocationTime != nil {

		// query param user_or_group.allocation_time
		var qrUserOrGroupAllocationTime string

		if o.UserOrGroupAllocationTime != nil {
			qrUserOrGroupAllocationTime = *o.UserOrGroupAllocationTime
		}
		qUserOrGroupAllocationTime := qrUserOrGroupAllocationTime
		if qUserOrGroupAllocationTime != "" {

			if err := r.SetQueryParam("user_or_group.allocation_time", qUserOrGroupAllocationTime); err != nil {
				return err
			}
		}
	}

	if o.UserOrGroupName != nil {

		// query param user_or_group.name
		var qrUserOrGroupName string

		if o.UserOrGroupName != nil {
			qrUserOrGroupName = *o.UserOrGroupName
		}
		qUserOrGroupName := qrUserOrGroupName
		if qUserOrGroupName != "" {

			if err := r.SetQueryParam("user_or_group.name", qUserOrGroupName); err != nil {
				return err
			}
		}
	}

	if o.WorkspaceName != nil {

		// query param workspace.name
		var qrWorkspaceName string

		if o.WorkspaceName != nil {
			qrWorkspaceName = *o.WorkspaceName
		}
		qWorkspaceName := qrWorkspaceName
		if qWorkspaceName != "" {

			if err := r.SetQueryParam("workspace.name", qWorkspaceName); err != nil {
				return err
			}
		}
	}

	// path param workspace.uuid
	if err := r.SetPathParam("workspace.uuid", o.WorkspaceUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
