// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DataEngineACLDeleteCollectionReader is a Reader for the DataEngineACLDeleteCollection structure.
type DataEngineACLDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DataEngineACLDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDataEngineACLDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDataEngineACLDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDataEngineACLDeleteCollectionOK creates a DataEngineACLDeleteCollectionOK with default headers values
func NewDataEngineACLDeleteCollectionOK() *DataEngineACLDeleteCollectionOK {
	return &DataEngineACLDeleteCollectionOK{}
}

/*
DataEngineACLDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type DataEngineACLDeleteCollectionOK struct {
}

// IsSuccess returns true when this data engine Acl delete collection o k response has a 2xx status code
func (o *DataEngineACLDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this data engine Acl delete collection o k response has a 3xx status code
func (o *DataEngineACLDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this data engine Acl delete collection o k response has a 4xx status code
func (o *DataEngineACLDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this data engine Acl delete collection o k response has a 5xx status code
func (o *DataEngineACLDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this data engine Acl delete collection o k response a status code equal to that given
func (o *DataEngineACLDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the data engine Acl delete collection o k response
func (o *DataEngineACLDeleteCollectionOK) Code() int {
	return 200
}

func (o *DataEngineACLDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/acls][%d] dataEngineAclDeleteCollectionOK", 200)
}

func (o *DataEngineACLDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/acls][%d] dataEngineAclDeleteCollectionOK", 200)
}

func (o *DataEngineACLDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewDataEngineACLDeleteCollectionDefault creates a DataEngineACLDeleteCollectionDefault with default headers values
func NewDataEngineACLDeleteCollectionDefault(code int) *DataEngineACLDeleteCollectionDefault {
	return &DataEngineACLDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
DataEngineACLDeleteCollectionDefault describes a response with status code -1, with default header values.

Error in deleting the ACL for the workspace.
*/
type DataEngineACLDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this data engine acl delete collection default response has a 2xx status code
func (o *DataEngineACLDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this data engine acl delete collection default response has a 3xx status code
func (o *DataEngineACLDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this data engine acl delete collection default response has a 4xx status code
func (o *DataEngineACLDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this data engine acl delete collection default response has a 5xx status code
func (o *DataEngineACLDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this data engine acl delete collection default response a status code equal to that given
func (o *DataEngineACLDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the data engine acl delete collection default response
func (o *DataEngineACLDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *DataEngineACLDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/acls][%d] data_engine_acl_delete_collection default %s", o._statusCode, payload)
}

func (o *DataEngineACLDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/acls][%d] data_engine_acl_delete_collection default %s", o._statusCode, payload)
}

func (o *DataEngineACLDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DataEngineACLDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
DataEngineACLDeleteCollectionBody Defines the structure of the response for data engine workspace ACL requests.
swagger:model DataEngineACLDeleteCollectionBody
*/
type DataEngineACLDeleteCollectionBody struct {

	// data engine acl response inline records
	DataEngineACLResponseInlineRecords []*models.DataEngineACL `json:"records,omitempty"`

	// The total number of ACL records available.
	// Example: 100
	// Read Only: true
	TotalRecords *int64 `json:"total_records,omitempty"`
}

// Validate validates this data engine ACL delete collection body
func (o *DataEngineACLDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateDataEngineACLResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DataEngineACLDeleteCollectionBody) validateDataEngineACLResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.DataEngineACLResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.DataEngineACLResponseInlineRecords); i++ {
		if swag.IsZero(o.DataEngineACLResponseInlineRecords[i]) { // not required
			continue
		}

		if o.DataEngineACLResponseInlineRecords[i] != nil {
			if err := o.DataEngineACLResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this data engine ACL delete collection body based on the context it is used
func (o *DataEngineACLDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateDataEngineACLResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTotalRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DataEngineACLDeleteCollectionBody) contextValidateDataEngineACLResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.DataEngineACLResponseInlineRecords); i++ {

		if o.DataEngineACLResponseInlineRecords[i] != nil {
			if err := o.DataEngineACLResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *DataEngineACLDeleteCollectionBody) contextValidateTotalRecords(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"total_records", "body", o.TotalRecords); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *DataEngineACLDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *DataEngineACLDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res DataEngineACLDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
