// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DataEngineACLDeleteReader is a Reader for the DataEngineACLDelete structure.
type DataEngineACLDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DataEngineACLDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDataEngineACLDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDataEngineACLDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDataEngineACLDeleteOK creates a DataEngineACLDeleteOK with default headers values
func NewDataEngineACLDeleteOK() *DataEngineACLDeleteOK {
	return &DataEngineACLDeleteOK{}
}

/*
DataEngineACLDeleteOK describes a response with status code 200, with default header values.

OK
*/
type DataEngineACLDeleteOK struct {
}

// IsSuccess returns true when this data engine Acl delete o k response has a 2xx status code
func (o *DataEngineACLDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this data engine Acl delete o k response has a 3xx status code
func (o *DataEngineACLDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this data engine Acl delete o k response has a 4xx status code
func (o *DataEngineACLDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this data engine Acl delete o k response has a 5xx status code
func (o *DataEngineACLDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this data engine Acl delete o k response a status code equal to that given
func (o *DataEngineACLDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the data engine Acl delete o k response
func (o *DataEngineACLDeleteOK) Code() int {
	return 200
}

func (o *DataEngineACLDeleteOK) Error() string {
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/acls/{user_or_group.name}][%d] dataEngineAclDeleteOK", 200)
}

func (o *DataEngineACLDeleteOK) String() string {
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/acls/{user_or_group.name}][%d] dataEngineAclDeleteOK", 200)
}

func (o *DataEngineACLDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewDataEngineACLDeleteDefault creates a DataEngineACLDeleteDefault with default headers values
func NewDataEngineACLDeleteDefault(code int) *DataEngineACLDeleteDefault {
	return &DataEngineACLDeleteDefault{
		_statusCode: code,
	}
}

/*
DataEngineACLDeleteDefault describes a response with status code -1, with default header values.

Error in deleting the ACL for the workspace.
*/
type DataEngineACLDeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this data engine acl delete default response has a 2xx status code
func (o *DataEngineACLDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this data engine acl delete default response has a 3xx status code
func (o *DataEngineACLDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this data engine acl delete default response has a 4xx status code
func (o *DataEngineACLDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this data engine acl delete default response has a 5xx status code
func (o *DataEngineACLDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this data engine acl delete default response a status code equal to that given
func (o *DataEngineACLDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the data engine acl delete default response
func (o *DataEngineACLDeleteDefault) Code() int {
	return o._statusCode
}

func (o *DataEngineACLDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/acls/{user_or_group.name}][%d] data_engine_acl_delete default %s", o._statusCode, payload)
}

func (o *DataEngineACLDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/acls/{user_or_group.name}][%d] data_engine_acl_delete default %s", o._statusCode, payload)
}

func (o *DataEngineACLDeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DataEngineACLDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
