// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewDataEngineACLGetParams creates a new DataEngineACLGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDataEngineACLGetParams() *DataEngineACLGetParams {
	return &DataEngineACLGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDataEngineACLGetParamsWithTimeout creates a new DataEngineACLGetParams object
// with the ability to set a timeout on a request.
func NewDataEngineACLGetParamsWithTimeout(timeout time.Duration) *DataEngineACLGetParams {
	return &DataEngineACLGetParams{
		timeout: timeout,
	}
}

// NewDataEngineACLGetParamsWithContext creates a new DataEngineACLGetParams object
// with the ability to set a context for a request.
func NewDataEngineACLGetParamsWithContext(ctx context.Context) *DataEngineACLGetParams {
	return &DataEngineACLGetParams{
		Context: ctx,
	}
}

// NewDataEngineACLGetParamsWithHTTPClient creates a new DataEngineACLGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewDataEngineACLGetParamsWithHTTPClient(client *http.Client) *DataEngineACLGetParams {
	return &DataEngineACLGetParams{
		HTTPClient: client,
	}
}

/*
DataEngineACLGetParams contains all the parameters to send to the API endpoint

	for the data engine acl get operation.

	Typically these are written to a http.Request.
*/
type DataEngineACLGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* UserOrGroupName.

	   User or group name associated with the ACL.
	*/
	UserOrGroupName string

	/* WorkspaceUUID.

	   Unique identifier of the workspace.
	*/
	WorkspaceUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the data engine acl get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DataEngineACLGetParams) WithDefaults() *DataEngineACLGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the data engine acl get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DataEngineACLGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the data engine acl get params
func (o *DataEngineACLGetParams) WithTimeout(timeout time.Duration) *DataEngineACLGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the data engine acl get params
func (o *DataEngineACLGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the data engine acl get params
func (o *DataEngineACLGetParams) WithContext(ctx context.Context) *DataEngineACLGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the data engine acl get params
func (o *DataEngineACLGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the data engine acl get params
func (o *DataEngineACLGetParams) WithHTTPClient(client *http.Client) *DataEngineACLGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the data engine acl get params
func (o *DataEngineACLGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the data engine acl get params
func (o *DataEngineACLGetParams) WithFields(fields []string) *DataEngineACLGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the data engine acl get params
func (o *DataEngineACLGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithUserOrGroupName adds the userOrGroupName to the data engine acl get params
func (o *DataEngineACLGetParams) WithUserOrGroupName(userOrGroupName string) *DataEngineACLGetParams {
	o.SetUserOrGroupName(userOrGroupName)
	return o
}

// SetUserOrGroupName adds the userOrGroupName to the data engine acl get params
func (o *DataEngineACLGetParams) SetUserOrGroupName(userOrGroupName string) {
	o.UserOrGroupName = userOrGroupName
}

// WithWorkspaceUUID adds the workspaceUUID to the data engine acl get params
func (o *DataEngineACLGetParams) WithWorkspaceUUID(workspaceUUID string) *DataEngineACLGetParams {
	o.SetWorkspaceUUID(workspaceUUID)
	return o
}

// SetWorkspaceUUID adds the workspaceUuid to the data engine acl get params
func (o *DataEngineACLGetParams) SetWorkspaceUUID(workspaceUUID string) {
	o.WorkspaceUUID = workspaceUUID
}

// WriteToRequest writes these params to a swagger request
func (o *DataEngineACLGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param user_or_group.name
	if err := r.SetPathParam("user_or_group.name", o.UserOrGroupName); err != nil {
		return err
	}

	// path param workspace.uuid
	if err := r.SetPathParam("workspace.uuid", o.WorkspaceUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamDataEngineACLGet binds the parameter fields
func (o *DataEngineACLGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
