// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DataEngineACLGetReader is a Reader for the DataEngineACLGet structure.
type DataEngineACLGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DataEngineACLGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDataEngineACLGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDataEngineACLGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDataEngineACLGetOK creates a DataEngineACLGetOK with default headers values
func NewDataEngineACLGetOK() *DataEngineACLGetOK {
	return &DataEngineACLGetOK{}
}

/*
DataEngineACLGetOK describes a response with status code 200, with default header values.

OK
*/
type DataEngineACLGetOK struct {
	Payload *models.DataEngineACL
}

// IsSuccess returns true when this data engine Acl get o k response has a 2xx status code
func (o *DataEngineACLGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this data engine Acl get o k response has a 3xx status code
func (o *DataEngineACLGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this data engine Acl get o k response has a 4xx status code
func (o *DataEngineACLGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this data engine Acl get o k response has a 5xx status code
func (o *DataEngineACLGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this data engine Acl get o k response a status code equal to that given
func (o *DataEngineACLGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the data engine Acl get o k response
func (o *DataEngineACLGetOK) Code() int {
	return 200
}

func (o *DataEngineACLGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/acls/{user_or_group.name}][%d] dataEngineAclGetOK %s", 200, payload)
}

func (o *DataEngineACLGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/acls/{user_or_group.name}][%d] dataEngineAclGetOK %s", 200, payload)
}

func (o *DataEngineACLGetOK) GetPayload() *models.DataEngineACL {
	return o.Payload
}

func (o *DataEngineACLGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DataEngineACL)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDataEngineACLGetDefault creates a DataEngineACLGetDefault with default headers values
func NewDataEngineACLGetDefault(code int) *DataEngineACLGetDefault {
	return &DataEngineACLGetDefault{
		_statusCode: code,
	}
}

/*
DataEngineACLGetDefault describes a response with status code -1, with default header values.

Error in retrieving the ACL for the workspace.
*/
type DataEngineACLGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this data engine acl get default response has a 2xx status code
func (o *DataEngineACLGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this data engine acl get default response has a 3xx status code
func (o *DataEngineACLGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this data engine acl get default response has a 4xx status code
func (o *DataEngineACLGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this data engine acl get default response has a 5xx status code
func (o *DataEngineACLGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this data engine acl get default response a status code equal to that given
func (o *DataEngineACLGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the data engine acl get default response
func (o *DataEngineACLGetDefault) Code() int {
	return o._statusCode
}

func (o *DataEngineACLGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/acls/{user_or_group.name}][%d] data_engine_acl_get default %s", o._statusCode, payload)
}

func (o *DataEngineACLGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/acls/{user_or_group.name}][%d] data_engine_acl_get default %s", o._statusCode, payload)
}

func (o *DataEngineACLGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DataEngineACLGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
