// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new data engine API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for data engine API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	DataEngineACLCollectionGet(params *DataEngineACLCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineACLCollectionGetOK, error)

	DataEngineACLCreate(params *DataEngineACLCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineACLCreateCreated, error)

	DataEngineACLDelete(params *DataEngineACLDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineACLDeleteOK, error)

	DataEngineACLDeleteCollection(params *DataEngineACLDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineACLDeleteCollectionOK, error)

	DataEngineACLGet(params *DataEngineACLGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineACLGetOK, error)

	DataEngineDatacollectionACLCollectionGet(params *DataEngineDatacollectionACLCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineDatacollectionACLCollectionGetOK, error)

	DataEngineDatacollectionACLCreate(params *DataEngineDatacollectionACLCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineDatacollectionACLCreateCreated, error)

	DataEngineDatacollectionACLDelete(params *DataEngineDatacollectionACLDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineDatacollectionACLDeleteOK, error)

	DataEngineDatacollectionACLDeleteCollection(params *DataEngineDatacollectionACLDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineDatacollectionACLDeleteCollectionOK, error)

	DataEngineDatacollectionACLGet(params *DataEngineDatacollectionACLGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineDatacollectionACLGetOK, error)

	DataEngineEntityCollectionGet(params *DataEngineEntityCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineEntityCollectionGetOK, error)

	DataEngineEntityCustomAttributeCollectionGet(params *DataEngineEntityCustomAttributeCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineEntityCustomAttributeCollectionGetOK, error)

	DataEngineEntityCustomAttributeCreate(params *DataEngineEntityCustomAttributeCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineEntityCustomAttributeCreateCreated, error)

	DataEngineEntityCustomAttributeDelete(params *DataEngineEntityCustomAttributeDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineEntityCustomAttributeDeleteOK, error)

	DataEngineEntityCustomAttributeDeleteCollection(params *DataEngineEntityCustomAttributeDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineEntityCustomAttributeDeleteCollectionOK, error)

	DataEngineEntityCustomAttributeGet(params *DataEngineEntityCustomAttributeGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineEntityCustomAttributeGetOK, error)

	DataEngineEntityGet(params *DataEngineEntityGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineEntityGetOK, error)

	DataEngineEventCollectionGet(params *DataEngineEventCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineEventCollectionGetOK, error)

	DataEngineEventGet(params *DataEngineEventGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineEventGetOK, error)

	DataEngineGet(params *DataEngineGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineGetOK, error)

	DataEngineGovernanceAuditCountGet(params *DataEngineGovernanceAuditCountGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineGovernanceAuditCountGetOK, error)

	DataEngineGovernanceAuditImpactedFilesCollectionGet(params *DataEngineGovernanceAuditImpactedFilesCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineGovernanceAuditImpactedFilesCollectionGetOK, error)

	DataEngineGovernanceFilePreviewFileContentPost(params *DataEngineGovernanceFilePreviewFileContentPostParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineGovernanceFilePreviewFileContentPostOK, error)

	DataEngineGovernanceFilePreviewJobCreate(params *DataEngineGovernanceFilePreviewJobCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineGovernanceFilePreviewJobCreateCreated, error)

	DataEngineGovernanceFilePreviewJobGet(params *DataEngineGovernanceFilePreviewJobGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineGovernanceFilePreviewJobGetOK, error)

	DataEngineGovernancePoliciesClassificationCategoryCollectionGet(params *DataEngineGovernancePoliciesClassificationCategoryCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineGovernancePoliciesClassificationCategoryCollectionGetOK, error)

	DataEngineGovernancePoliciesClassificationCategoryCreate(params *DataEngineGovernancePoliciesClassificationCategoryCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineGovernancePoliciesClassificationCategoryCreateCreated, error)

	DataEngineGovernancePoliciesClassificationCategoryDelete(params *DataEngineGovernancePoliciesClassificationCategoryDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineGovernancePoliciesClassificationCategoryDeleteOK, error)

	DataEngineGovernancePoliciesClassificationCategoryDeleteCollection(params *DataEngineGovernancePoliciesClassificationCategoryDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineGovernancePoliciesClassificationCategoryDeleteCollectionOK, error)

	DataEngineGovernancePoliciesClassificationCategoryGet(params *DataEngineGovernancePoliciesClassificationCategoryGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineGovernancePoliciesClassificationCategoryGetOK, error)

	DataEngineGovernancePoliciesClassificationCategoryModify(params *DataEngineGovernancePoliciesClassificationCategoryModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineGovernancePoliciesClassificationCategoryModifyOK, error)

	DataEngineGovernancePoliciesClassificationCategoryModifyCollection(params *DataEngineGovernancePoliciesClassificationCategoryModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineGovernancePoliciesClassificationCategoryModifyCollectionOK, error)

	DataEngineGovernancePoliciesClassificationClassifierCollectionGet(params *DataEngineGovernancePoliciesClassificationClassifierCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineGovernancePoliciesClassificationClassifierCollectionGetOK, error)

	DataEngineGovernancePoliciesClassificationClassifierGet(params *DataEngineGovernancePoliciesClassificationClassifierGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineGovernancePoliciesClassificationClassifierGetOK, error)

	DataEngineGovernancePoliciesClassificationClassifierModify(params *DataEngineGovernancePoliciesClassificationClassifierModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineGovernancePoliciesClassificationClassifierModifyOK, error)

	DataEngineGovernancePoliciesClassificationClassifierModifyCollection(params *DataEngineGovernancePoliciesClassificationClassifierModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineGovernancePoliciesClassificationClassifierModifyCollectionOK, error)

	DataEngineGovernancePoliciesGuardrailCollectionGet(params *DataEngineGovernancePoliciesGuardrailCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineGovernancePoliciesGuardrailCollectionGetOK, error)

	DataEngineGovernancePoliciesGuardrailCreate(params *DataEngineGovernancePoliciesGuardrailCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineGovernancePoliciesGuardrailCreateCreated, error)

	DataEngineGovernancePoliciesGuardrailDelete(params *DataEngineGovernancePoliciesGuardrailDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineGovernancePoliciesGuardrailDeleteOK, error)

	DataEngineGovernancePoliciesGuardrailDeleteCollection(params *DataEngineGovernancePoliciesGuardrailDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineGovernancePoliciesGuardrailDeleteCollectionOK, error)

	DataEngineGovernancePoliciesGuardrailGet(params *DataEngineGovernancePoliciesGuardrailGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineGovernancePoliciesGuardrailGetOK, error)

	DataEngineGovernancePoliciesGuardrailModify(params *DataEngineGovernancePoliciesGuardrailModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineGovernancePoliciesGuardrailModifyOK, error)

	DataEngineGovernancePoliciesGuardrailModifyCollection(params *DataEngineGovernancePoliciesGuardrailModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineGovernancePoliciesGuardrailModifyCollectionOK, error)

	DataEngineJobCollectionGet(params *DataEngineJobCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineJobCollectionGetOK, error)

	DataEngineJobGet(params *DataEngineJobGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineJobGetOK, error)

	DataEnginePolicyCollectionGet(params *DataEnginePolicyCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEnginePolicyCollectionGetOK, error)

	DataEnginePolicyGet(params *DataEnginePolicyGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEnginePolicyGetOK, error)

	DataEnginePolicyModify(params *DataEnginePolicyModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEnginePolicyModifyOK, error)

	DataEnginePolicyModifyCollection(params *DataEnginePolicyModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEnginePolicyModifyCollectionOK, error)

	DataEnginePolicyVersionCollectionGet(params *DataEnginePolicyVersionCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEnginePolicyVersionCollectionGetOK, error)

	DataEnginePolicyVersionGet(params *DataEnginePolicyVersionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEnginePolicyVersionGetOK, error)

	DataSourceCollectionGet(params *DataSourceCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataSourceCollectionGetOK, error)

	DataSourceGet(params *DataSourceGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataSourceGetOK, error)

	DatacollectionCollectionGet(params *DatacollectionCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DatacollectionCollectionGetOK, error)

	DatacollectionCreate(params *DatacollectionCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DatacollectionCreateCreated, *DatacollectionCreateAccepted, error)

	DatacollectionDelete(params *DatacollectionDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DatacollectionDeleteOK, *DatacollectionDeleteAccepted, error)

	DatacollectionDeleteCollection(params *DatacollectionDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DatacollectionDeleteCollectionOK, *DatacollectionDeleteCollectionAccepted, error)

	DatacollectionEntityCollectionGet(params *DatacollectionEntityCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DatacollectionEntityCollectionGetOK, error)

	DatacollectionEntityCreate(params *DatacollectionEntityCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DatacollectionEntityCreateCreated, *DatacollectionEntityCreateAccepted, error)

	DatacollectionEntityDelete(params *DatacollectionEntityDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DatacollectionEntityDeleteOK, *DatacollectionEntityDeleteAccepted, error)

	DatacollectionEntityDeleteCollection(params *DatacollectionEntityDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DatacollectionEntityDeleteCollectionOK, *DatacollectionEntityDeleteCollectionAccepted, error)

	DatacollectionEntityGet(params *DatacollectionEntityGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DatacollectionEntityGetOK, error)

	DatacollectionGet(params *DatacollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DatacollectionGetOK, error)

	DatacollectionModify(params *DatacollectionModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DatacollectionModifyOK, *DatacollectionModifyAccepted, error)

	DatacollectionModifyCollection(params *DatacollectionModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DatacollectionModifyCollectionOK, *DatacollectionModifyCollectionAccepted, error)

	DatacollectionSearchDataGet(params *DatacollectionSearchDataGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DatacollectionSearchDataGetOK, error)

	DatacollectionVersionCollectionGet(params *DatacollectionVersionCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DatacollectionVersionCollectionGetOK, error)

	DatacollectionVersionDiffCollectionGet(params *DatacollectionVersionDiffCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DatacollectionVersionDiffCollectionGetOK, error)

	DatacollectionVersionDiffCreate(params *DatacollectionVersionDiffCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DatacollectionVersionDiffCreateCreated, *DatacollectionVersionDiffCreateAccepted, error)

	DatacollectionVersionGet(params *DatacollectionVersionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DatacollectionVersionGetOK, error)

	GovernanceAggregationsGet(params *GovernanceAggregationsGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GovernanceAggregationsGetOK, error)

	GovernanceWorkspaceAggregationsCollectionGet(params *GovernanceWorkspaceAggregationsCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GovernanceWorkspaceAggregationsCollectionGetOK, error)

	GovernanceWorkspaceAggregationsGet(params *GovernanceWorkspaceAggregationsGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GovernanceWorkspaceAggregationsGetOK, error)

	WorkspaceCollectionGet(params *WorkspaceCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WorkspaceCollectionGetOK, error)

	WorkspaceCreate(params *WorkspaceCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WorkspaceCreateCreated, *WorkspaceCreateAccepted, error)

	WorkspaceDataSourceCollectionGet(params *WorkspaceDataSourceCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WorkspaceDataSourceCollectionGetOK, error)

	WorkspaceDataSourceCreate(params *WorkspaceDataSourceCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WorkspaceDataSourceCreateCreated, *WorkspaceDataSourceCreateAccepted, error)

	WorkspaceDataSourceDelete(params *WorkspaceDataSourceDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WorkspaceDataSourceDeleteOK, *WorkspaceDataSourceDeleteAccepted, error)

	WorkspaceDataSourceDeleteCollection(params *WorkspaceDataSourceDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WorkspaceDataSourceDeleteCollectionOK, *WorkspaceDataSourceDeleteCollectionAccepted, error)

	WorkspaceDataSourceGet(params *WorkspaceDataSourceGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WorkspaceDataSourceGetOK, error)

	WorkspaceDelete(params *WorkspaceDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WorkspaceDeleteOK, *WorkspaceDeleteAccepted, error)

	WorkspaceDeleteCollection(params *WorkspaceDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WorkspaceDeleteCollectionOK, *WorkspaceDeleteCollectionAccepted, error)

	WorkspaceGet(params *WorkspaceGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WorkspaceGetOK, error)

	WorkspaceModify(params *WorkspaceModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WorkspaceModifyOK, *WorkspaceModifyAccepted, error)

	WorkspaceModifyCollection(params *WorkspaceModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WorkspaceModifyCollectionOK, *WorkspaceModifyCollectionAccepted, error)

	WorkspaceQueryCollectionGet(params *WorkspaceQueryCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WorkspaceQueryCollectionGetOK, error)

	WorkspaceQueryCreate(params *WorkspaceQueryCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WorkspaceQueryCreateCreated, error)

	WorkspaceQueryDelete(params *WorkspaceQueryDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WorkspaceQueryDeleteOK, error)

	WorkspaceQueryDeleteCollection(params *WorkspaceQueryDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WorkspaceQueryDeleteCollectionOK, error)

	WorkspaceQueryEntityCollectionGet(params *WorkspaceQueryEntityCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WorkspaceQueryEntityCollectionGetOK, error)

	WorkspaceQueryGet(params *WorkspaceQueryGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WorkspaceQueryGetOK, error)

	WorkspaceQueryModify(params *WorkspaceQueryModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WorkspaceQueryModifyOK, error)

	WorkspaceQueryModifyCollection(params *WorkspaceQueryModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WorkspaceQueryModifyCollectionOK, error)

	WorkspaceVersionCollectionGet(params *WorkspaceVersionCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WorkspaceVersionCollectionGetOK, error)

	WorkspaceVersionDiffCollectionGet(params *WorkspaceVersionDiffCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WorkspaceVersionDiffCollectionGetOK, error)

	WorkspaceVersionDiffCreate(params *WorkspaceVersionDiffCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WorkspaceVersionDiffCreateCreated, *WorkspaceVersionDiffCreateAccepted, error)

	WorkspaceVersionGet(params *WorkspaceVersionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WorkspaceVersionGetOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
DataEngineACLCollectionGet Retrieves a list of ACLs for the workspace.
*/
func (a *Client) DataEngineACLCollectionGet(params *DataEngineACLCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineACLCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDataEngineACLCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "data_engine_acl_collection_get",
		Method:             "GET",
		PathPattern:        "/data-engine/workspaces/{workspace.uuid}/acls",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DataEngineACLCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DataEngineACLCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DataEngineACLCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	DataEngineACLCreate Access to workspaces is controlled by configuring ACLs (Access Control Lists) on the workspace.

In order to call a REST API on the workspace, the user must be using a role that has access to the REST API.
In addition, users that do not have the "admin" role must be listed in the ACL to be allowed access.
*/
func (a *Client) DataEngineACLCreate(params *DataEngineACLCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineACLCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDataEngineACLCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "data_engine_acl_create",
		Method:             "POST",
		PathPattern:        "/data-engine/workspaces/{workspace.uuid}/acls",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DataEngineACLCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DataEngineACLCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DataEngineACLCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DataEngineACLDelete Deletes the ACL for the workspace.
*/
func (a *Client) DataEngineACLDelete(params *DataEngineACLDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineACLDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDataEngineACLDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "data_engine_acl_delete",
		Method:             "DELETE",
		PathPattern:        "/data-engine/workspaces/{workspace.uuid}/acls/{user_or_group.name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DataEngineACLDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DataEngineACLDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DataEngineACLDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DataEngineACLDeleteCollection data engine acl delete collection API
*/
func (a *Client) DataEngineACLDeleteCollection(params *DataEngineACLDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineACLDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDataEngineACLDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "data_engine_acl_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/data-engine/workspaces/{workspace.uuid}/acls",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DataEngineACLDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DataEngineACLDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DataEngineACLDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DataEngineACLGet Retrieves an ACL for the workspace.
*/
func (a *Client) DataEngineACLGet(params *DataEngineACLGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineACLGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDataEngineACLGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "data_engine_acl_get",
		Method:             "GET",
		PathPattern:        "/data-engine/workspaces/{workspace.uuid}/acls/{user_or_group.name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DataEngineACLGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DataEngineACLGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DataEngineACLGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DataEngineDatacollectionACLCollectionGet Retrieves a list of ACLs for the data collection.
*/
func (a *Client) DataEngineDatacollectionACLCollectionGet(params *DataEngineDatacollectionACLCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineDatacollectionACLCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDataEngineDatacollectionACLCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "data_engine_datacollection_acl_collection_get",
		Method:             "GET",
		PathPattern:        "/data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/acls",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DataEngineDatacollectionACLCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DataEngineDatacollectionACLCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DataEngineDatacollectionACLCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	DataEngineDatacollectionACLCreate Access to data collections in a workspace is controlled by configuring ACLs (Access Control Lists) on the data collection.

In order to call a REST API on the data collection, the user must be using a role that has access to the REST API.
In addition, users that do not have the "admin" role must be listed in the ACL to be allowed access.
*/
func (a *Client) DataEngineDatacollectionACLCreate(params *DataEngineDatacollectionACLCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineDatacollectionACLCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDataEngineDatacollectionACLCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "data_engine_datacollection_acl_create",
		Method:             "POST",
		PathPattern:        "/data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/acls",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DataEngineDatacollectionACLCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DataEngineDatacollectionACLCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DataEngineDatacollectionACLCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DataEngineDatacollectionACLDelete Deletes the ACL for the data collection.
*/
func (a *Client) DataEngineDatacollectionACLDelete(params *DataEngineDatacollectionACLDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineDatacollectionACLDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDataEngineDatacollectionACLDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "data_engine_datacollection_acl_delete",
		Method:             "DELETE",
		PathPattern:        "/data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/acls/{user_or_group.name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DataEngineDatacollectionACLDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DataEngineDatacollectionACLDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DataEngineDatacollectionACLDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DataEngineDatacollectionACLDeleteCollection data engine datacollection acl delete collection API
*/
func (a *Client) DataEngineDatacollectionACLDeleteCollection(params *DataEngineDatacollectionACLDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineDatacollectionACLDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDataEngineDatacollectionACLDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "data_engine_datacollection_acl_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/acls",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DataEngineDatacollectionACLDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DataEngineDatacollectionACLDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DataEngineDatacollectionACLDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DataEngineDatacollectionACLGet Retrieves an ACL for the data collection.
*/
func (a *Client) DataEngineDatacollectionACLGet(params *DataEngineDatacollectionACLGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineDatacollectionACLGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDataEngineDatacollectionACLGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "data_engine_datacollection_acl_get",
		Method:             "GET",
		PathPattern:        "/data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/acls/{user_or_group.name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DataEngineDatacollectionACLGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DataEngineDatacollectionACLGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DataEngineDatacollectionACLGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DataEngineEntityCollectionGet Retrieves a list of entities within a workspace.
*/
func (a *Client) DataEngineEntityCollectionGet(params *DataEngineEntityCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineEntityCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDataEngineEntityCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "data_engine_entity_collection_get",
		Method:             "GET",
		PathPattern:        "/data-engine/workspaces/{workspace.uuid}/entities",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DataEngineEntityCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DataEngineEntityCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DataEngineEntityCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DataEngineEntityCustomAttributeCollectionGet Retrieves custom attributes of an entity in a workspace.
*/
func (a *Client) DataEngineEntityCustomAttributeCollectionGet(params *DataEngineEntityCustomAttributeCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineEntityCustomAttributeCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDataEngineEntityCustomAttributeCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "data_engine_entity_custom_attribute_collection_get",
		Method:             "GET",
		PathPattern:        "/data-engine/workspaces/{workspace.uuid}/entities/{data_engine_entity.uuid}/custom-attributes",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DataEngineEntityCustomAttributeCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DataEngineEntityCustomAttributeCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DataEngineEntityCustomAttributeCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	DataEngineEntityCustomAttributeCreate Adds a custom attribute to an entity in a workspace.

### Required properties
* `key` - The key of the attribute to add.
* `value` - The value of the attribute to add.
*/
func (a *Client) DataEngineEntityCustomAttributeCreate(params *DataEngineEntityCustomAttributeCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineEntityCustomAttributeCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDataEngineEntityCustomAttributeCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "data_engine_entity_custom_attribute_create",
		Method:             "POST",
		PathPattern:        "/data-engine/workspaces/{workspace.uuid}/entities/{data_engine_entity.uuid}/custom-attributes",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DataEngineEntityCustomAttributeCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DataEngineEntityCustomAttributeCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DataEngineEntityCustomAttributeCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DataEngineEntityCustomAttributeDelete Deletes a custom attribute of an entity in a workspace.
*/
func (a *Client) DataEngineEntityCustomAttributeDelete(params *DataEngineEntityCustomAttributeDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineEntityCustomAttributeDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDataEngineEntityCustomAttributeDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "data_engine_entity_custom_attribute_delete",
		Method:             "DELETE",
		PathPattern:        "/data-engine/workspaces/{workspace.uuid}/entities/{data_engine_entity.uuid}/custom-attributes/{key}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DataEngineEntityCustomAttributeDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DataEngineEntityCustomAttributeDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DataEngineEntityCustomAttributeDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DataEngineEntityCustomAttributeDeleteCollection data engine entity custom attribute delete collection API
*/
func (a *Client) DataEngineEntityCustomAttributeDeleteCollection(params *DataEngineEntityCustomAttributeDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineEntityCustomAttributeDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDataEngineEntityCustomAttributeDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "data_engine_entity_custom_attribute_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/data-engine/workspaces/{workspace.uuid}/entities/{data_engine_entity.uuid}/custom-attributes",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DataEngineEntityCustomAttributeDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DataEngineEntityCustomAttributeDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DataEngineEntityCustomAttributeDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DataEngineEntityCustomAttributeGet Retrieves a custom attribute of an entity in a workspace.
*/
func (a *Client) DataEngineEntityCustomAttributeGet(params *DataEngineEntityCustomAttributeGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineEntityCustomAttributeGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDataEngineEntityCustomAttributeGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "data_engine_entity_custom_attribute_get",
		Method:             "GET",
		PathPattern:        "/data-engine/workspaces/{workspace.uuid}/entities/{data_engine_entity.uuid}/custom-attributes/{key}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DataEngineEntityCustomAttributeGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DataEngineEntityCustomAttributeGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DataEngineEntityCustomAttributeGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DataEngineEntityGet Retrieves an entity in a workspace.
*/
func (a *Client) DataEngineEntityGet(params *DataEngineEntityGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineEntityGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDataEngineEntityGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "data_engine_entity_get",
		Method:             "GET",
		PathPattern:        "/data-engine/workspaces/{workspace.uuid}/entities/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DataEngineEntityGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DataEngineEntityGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DataEngineEntityGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DataEngineEventCollectionGet Retrieves a list of data engine events.
*/
func (a *Client) DataEngineEventCollectionGet(params *DataEngineEventCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineEventCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDataEngineEventCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "data_engine_event_collection_get",
		Method:             "GET",
		PathPattern:        "/data-engine/events",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DataEngineEventCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DataEngineEventCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DataEngineEventCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DataEngineEventGet Retrieves the details of a specific data engine event.
*/
func (a *Client) DataEngineEventGet(params *DataEngineEventGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineEventGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDataEngineEventGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "data_engine_event_get",
		Method:             "GET",
		PathPattern:        "/data-engine/events/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DataEngineEventGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DataEngineEventGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DataEngineEventGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DataEngineGet Retrieves data engine information and cluster level metrics.
*/
func (a *Client) DataEngineGet(params *DataEngineGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDataEngineGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "data_engine_get",
		Method:             "GET",
		PathPattern:        "/data-engine",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DataEngineGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DataEngineGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DataEngineGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DataEngineGovernanceAuditCountGet Retrieves the governance audit impacted files count.
*/
func (a *Client) DataEngineGovernanceAuditCountGet(params *DataEngineGovernanceAuditCountGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineGovernanceAuditCountGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDataEngineGovernanceAuditCountGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "data_engine_governance_audit_count_get",
		Method:             "GET",
		PathPattern:        "/data-engine/governance/impacted-files/{workspace.uuid}/{guardrail_policy.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DataEngineGovernanceAuditCountGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DataEngineGovernanceAuditCountGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DataEngineGovernanceAuditCountGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DataEngineGovernanceAuditImpactedFilesCollectionGet Retrieves the governance audit information.
*/
func (a *Client) DataEngineGovernanceAuditImpactedFilesCollectionGet(params *DataEngineGovernanceAuditImpactedFilesCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineGovernanceAuditImpactedFilesCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDataEngineGovernanceAuditImpactedFilesCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "data_engine_governance_audit_impacted_files_collection_get",
		Method:             "GET",
		PathPattern:        "/data-engine/governance/impacted-files/{workspace.uuid}/{guardrail_policy.uuid}/files",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DataEngineGovernanceAuditImpactedFilesCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DataEngineGovernanceAuditImpactedFilesCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DataEngineGovernanceAuditImpactedFilesCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	DataEngineGovernanceFilePreviewFileContentPost Retrieves the anonymized content of a file.

### Required properties
* `file.uuid`: UUID of the entity.
* `file.path`: Path of the entity.
* `file.format`: Format of the entity.
* `workspace.uuid`: UUID of the workspace in which the entity is present.
*/
func (a *Client) DataEngineGovernanceFilePreviewFileContentPost(params *DataEngineGovernanceFilePreviewFileContentPostParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineGovernanceFilePreviewFileContentPostOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDataEngineGovernanceFilePreviewFileContentPostParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "data_engine_governance_file_preview_file_content_post",
		Method:             "POST",
		PathPattern:        "/data-engine/governance/file-preview/file-content",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DataEngineGovernanceFilePreviewFileContentPostReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DataEngineGovernanceFilePreviewFileContentPostOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DataEngineGovernanceFilePreviewFileContentPostDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	DataEngineGovernanceFilePreviewJobCreate Creates a job for retrieving file information.

### Required properties
* `file.uuid`: UUID of the entity.
* `file.path`: Path of the entity.
* `file.format`: Format of the entity.
* `workspace.uuid`: UUID of the workspace in which the entity is present.
*/
func (a *Client) DataEngineGovernanceFilePreviewJobCreate(params *DataEngineGovernanceFilePreviewJobCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineGovernanceFilePreviewJobCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDataEngineGovernanceFilePreviewJobCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "data_engine_governance_file_preview_job_create",
		Method:             "POST",
		PathPattern:        "/data-engine/governance/file-preview/jobs",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DataEngineGovernanceFilePreviewJobCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DataEngineGovernanceFilePreviewJobCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DataEngineGovernanceFilePreviewJobCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DataEngineGovernanceFilePreviewJobGet Retrieves information about a file preview job by its UUID.
*/
func (a *Client) DataEngineGovernanceFilePreviewJobGet(params *DataEngineGovernanceFilePreviewJobGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineGovernanceFilePreviewJobGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDataEngineGovernanceFilePreviewJobGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "data_engine_governance_file_preview_job_get",
		Method:             "GET",
		PathPattern:        "/data-engine/governance/file-preview/jobs/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DataEngineGovernanceFilePreviewJobGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DataEngineGovernanceFilePreviewJobGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DataEngineGovernanceFilePreviewJobGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DataEngineGovernancePoliciesClassificationCategoryCollectionGet Retrieves a list of categories.
*/
func (a *Client) DataEngineGovernancePoliciesClassificationCategoryCollectionGet(params *DataEngineGovernancePoliciesClassificationCategoryCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineGovernancePoliciesClassificationCategoryCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDataEngineGovernancePoliciesClassificationCategoryCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "data_engine_governance_policies_classification_category_collection_get",
		Method:             "GET",
		PathPattern:        "/data-engine/governance/policies/classification/categories",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DataEngineGovernancePoliciesClassificationCategoryCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DataEngineGovernancePoliciesClassificationCategoryCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DataEngineGovernancePoliciesClassificationCategoryCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	DataEngineGovernancePoliciesClassificationCategoryCreate Creates a new category.

### Required properties
* `name`: Name of the category.
* `description`: Description of the category.
* `tag`: Tag associated with the category.
* `classifiers`: List of classifiers associated with the category.
* `status`: Status of the category.
* `custom`: Specifies if the category is user-defined.
* `type`: Type of the category.
*/
func (a *Client) DataEngineGovernancePoliciesClassificationCategoryCreate(params *DataEngineGovernancePoliciesClassificationCategoryCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineGovernancePoliciesClassificationCategoryCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDataEngineGovernancePoliciesClassificationCategoryCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "data_engine_governance_policies_classification_category_create",
		Method:             "POST",
		PathPattern:        "/data-engine/governance/policies/classification/categories",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DataEngineGovernancePoliciesClassificationCategoryCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DataEngineGovernancePoliciesClassificationCategoryCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DataEngineGovernancePoliciesClassificationCategoryCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DataEngineGovernancePoliciesClassificationCategoryDelete Deletes a category.
*/
func (a *Client) DataEngineGovernancePoliciesClassificationCategoryDelete(params *DataEngineGovernancePoliciesClassificationCategoryDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineGovernancePoliciesClassificationCategoryDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDataEngineGovernancePoliciesClassificationCategoryDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "data_engine_governance_policies_classification_category_delete",
		Method:             "DELETE",
		PathPattern:        "/data-engine/governance/policies/classification/categories/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DataEngineGovernancePoliciesClassificationCategoryDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DataEngineGovernancePoliciesClassificationCategoryDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DataEngineGovernancePoliciesClassificationCategoryDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DataEngineGovernancePoliciesClassificationCategoryDeleteCollection data engine governance policies classification category delete collection API
*/
func (a *Client) DataEngineGovernancePoliciesClassificationCategoryDeleteCollection(params *DataEngineGovernancePoliciesClassificationCategoryDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineGovernancePoliciesClassificationCategoryDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDataEngineGovernancePoliciesClassificationCategoryDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "data_engine_governance_policies_classification_category_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/data-engine/governance/policies/classification/categories",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DataEngineGovernancePoliciesClassificationCategoryDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DataEngineGovernancePoliciesClassificationCategoryDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DataEngineGovernancePoliciesClassificationCategoryDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DataEngineGovernancePoliciesClassificationCategoryGet Retrieves the details of the specified category.
*/
func (a *Client) DataEngineGovernancePoliciesClassificationCategoryGet(params *DataEngineGovernancePoliciesClassificationCategoryGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineGovernancePoliciesClassificationCategoryGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDataEngineGovernancePoliciesClassificationCategoryGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "data_engine_governance_policies_classification_category_get",
		Method:             "GET",
		PathPattern:        "/data-engine/governance/policies/classification/categories/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DataEngineGovernancePoliciesClassificationCategoryGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DataEngineGovernancePoliciesClassificationCategoryGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DataEngineGovernancePoliciesClassificationCategoryGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DataEngineGovernancePoliciesClassificationCategoryModify Updates the specified category.
*/
func (a *Client) DataEngineGovernancePoliciesClassificationCategoryModify(params *DataEngineGovernancePoliciesClassificationCategoryModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineGovernancePoliciesClassificationCategoryModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDataEngineGovernancePoliciesClassificationCategoryModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "data_engine_governance_policies_classification_category_modify",
		Method:             "PATCH",
		PathPattern:        "/data-engine/governance/policies/classification/categories/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DataEngineGovernancePoliciesClassificationCategoryModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DataEngineGovernancePoliciesClassificationCategoryModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DataEngineGovernancePoliciesClassificationCategoryModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DataEngineGovernancePoliciesClassificationCategoryModifyCollection data engine governance policies classification category modify collection API
*/
func (a *Client) DataEngineGovernancePoliciesClassificationCategoryModifyCollection(params *DataEngineGovernancePoliciesClassificationCategoryModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineGovernancePoliciesClassificationCategoryModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDataEngineGovernancePoliciesClassificationCategoryModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "data_engine_governance_policies_classification_category_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/data-engine/governance/policies/classification/categories",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DataEngineGovernancePoliciesClassificationCategoryModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DataEngineGovernancePoliciesClassificationCategoryModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DataEngineGovernancePoliciesClassificationCategoryModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DataEngineGovernancePoliciesClassificationClassifierCollectionGet Retrieves a list of classifiers.
*/
func (a *Client) DataEngineGovernancePoliciesClassificationClassifierCollectionGet(params *DataEngineGovernancePoliciesClassificationClassifierCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineGovernancePoliciesClassificationClassifierCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDataEngineGovernancePoliciesClassificationClassifierCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "data_engine_governance_policies_classification_classifier_collection_get",
		Method:             "GET",
		PathPattern:        "/data-engine/governance/policies/classification/classifiers",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DataEngineGovernancePoliciesClassificationClassifierCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DataEngineGovernancePoliciesClassificationClassifierCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DataEngineGovernancePoliciesClassificationClassifierCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DataEngineGovernancePoliciesClassificationClassifierGet Retrieves the details of the specified classifier.
*/
func (a *Client) DataEngineGovernancePoliciesClassificationClassifierGet(params *DataEngineGovernancePoliciesClassificationClassifierGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineGovernancePoliciesClassificationClassifierGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDataEngineGovernancePoliciesClassificationClassifierGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "data_engine_governance_policies_classification_classifier_get",
		Method:             "GET",
		PathPattern:        "/data-engine/governance/policies/classification/classifiers/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DataEngineGovernancePoliciesClassificationClassifierGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DataEngineGovernancePoliciesClassificationClassifierGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DataEngineGovernancePoliciesClassificationClassifierGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DataEngineGovernancePoliciesClassificationClassifierModify Updates the specified classifier.
*/
func (a *Client) DataEngineGovernancePoliciesClassificationClassifierModify(params *DataEngineGovernancePoliciesClassificationClassifierModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineGovernancePoliciesClassificationClassifierModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDataEngineGovernancePoliciesClassificationClassifierModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "data_engine_governance_policies_classification_classifier_modify",
		Method:             "PATCH",
		PathPattern:        "/data-engine/governance/policies/classification/classifiers/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DataEngineGovernancePoliciesClassificationClassifierModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DataEngineGovernancePoliciesClassificationClassifierModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DataEngineGovernancePoliciesClassificationClassifierModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DataEngineGovernancePoliciesClassificationClassifierModifyCollection data engine governance policies classification classifier modify collection API
*/
func (a *Client) DataEngineGovernancePoliciesClassificationClassifierModifyCollection(params *DataEngineGovernancePoliciesClassificationClassifierModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineGovernancePoliciesClassificationClassifierModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDataEngineGovernancePoliciesClassificationClassifierModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "data_engine_governance_policies_classification_classifier_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/data-engine/governance/policies/classification/classifiers",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DataEngineGovernancePoliciesClassificationClassifierModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DataEngineGovernancePoliciesClassificationClassifierModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DataEngineGovernancePoliciesClassificationClassifierModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DataEngineGovernancePoliciesGuardrailCollectionGet Retrieves a list of guardrails.
*/
func (a *Client) DataEngineGovernancePoliciesGuardrailCollectionGet(params *DataEngineGovernancePoliciesGuardrailCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineGovernancePoliciesGuardrailCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDataEngineGovernancePoliciesGuardrailCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "data_engine_governance_policies_guardrail_collection_get",
		Method:             "GET",
		PathPattern:        "/data-engine/governance/policies/guardrails",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DataEngineGovernancePoliciesGuardrailCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DataEngineGovernancePoliciesGuardrailCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DataEngineGovernancePoliciesGuardrailCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	DataEngineGovernancePoliciesGuardrailCreate Creates a new guardrail.

### Required properties
* `name`: Name of the guardrail.
* `description`: Description of the guardrail.
* `condition`: Condition under which the guardrail is applied.
* `action`: Action to be performed by the guardrail.
* `status`: Status of the guardrail.
*/
func (a *Client) DataEngineGovernancePoliciesGuardrailCreate(params *DataEngineGovernancePoliciesGuardrailCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineGovernancePoliciesGuardrailCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDataEngineGovernancePoliciesGuardrailCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "data_engine_governance_policies_guardrail_create",
		Method:             "POST",
		PathPattern:        "/data-engine/governance/policies/guardrails",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DataEngineGovernancePoliciesGuardrailCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DataEngineGovernancePoliciesGuardrailCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DataEngineGovernancePoliciesGuardrailCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DataEngineGovernancePoliciesGuardrailDelete Deletes a guardrail.
*/
func (a *Client) DataEngineGovernancePoliciesGuardrailDelete(params *DataEngineGovernancePoliciesGuardrailDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineGovernancePoliciesGuardrailDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDataEngineGovernancePoliciesGuardrailDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "data_engine_governance_policies_guardrail_delete",
		Method:             "DELETE",
		PathPattern:        "/data-engine/governance/policies/guardrails/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DataEngineGovernancePoliciesGuardrailDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DataEngineGovernancePoliciesGuardrailDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DataEngineGovernancePoliciesGuardrailDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DataEngineGovernancePoliciesGuardrailDeleteCollection data engine governance policies guardrail delete collection API
*/
func (a *Client) DataEngineGovernancePoliciesGuardrailDeleteCollection(params *DataEngineGovernancePoliciesGuardrailDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineGovernancePoliciesGuardrailDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDataEngineGovernancePoliciesGuardrailDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "data_engine_governance_policies_guardrail_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/data-engine/governance/policies/guardrails",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DataEngineGovernancePoliciesGuardrailDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DataEngineGovernancePoliciesGuardrailDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DataEngineGovernancePoliciesGuardrailDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DataEngineGovernancePoliciesGuardrailGet Retrieves the details of the specified guardrail.
*/
func (a *Client) DataEngineGovernancePoliciesGuardrailGet(params *DataEngineGovernancePoliciesGuardrailGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineGovernancePoliciesGuardrailGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDataEngineGovernancePoliciesGuardrailGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "data_engine_governance_policies_guardrail_get",
		Method:             "GET",
		PathPattern:        "/data-engine/governance/policies/guardrails/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DataEngineGovernancePoliciesGuardrailGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DataEngineGovernancePoliciesGuardrailGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DataEngineGovernancePoliciesGuardrailGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DataEngineGovernancePoliciesGuardrailModify Updates the specified guardrail.
*/
func (a *Client) DataEngineGovernancePoliciesGuardrailModify(params *DataEngineGovernancePoliciesGuardrailModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineGovernancePoliciesGuardrailModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDataEngineGovernancePoliciesGuardrailModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "data_engine_governance_policies_guardrail_modify",
		Method:             "PATCH",
		PathPattern:        "/data-engine/governance/policies/guardrails/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DataEngineGovernancePoliciesGuardrailModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DataEngineGovernancePoliciesGuardrailModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DataEngineGovernancePoliciesGuardrailModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DataEngineGovernancePoliciesGuardrailModifyCollection data engine governance policies guardrail modify collection API
*/
func (a *Client) DataEngineGovernancePoliciesGuardrailModifyCollection(params *DataEngineGovernancePoliciesGuardrailModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineGovernancePoliciesGuardrailModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDataEngineGovernancePoliciesGuardrailModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "data_engine_governance_policies_guardrail_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/data-engine/governance/policies/guardrails",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DataEngineGovernancePoliciesGuardrailModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DataEngineGovernancePoliciesGuardrailModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DataEngineGovernancePoliciesGuardrailModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DataEngineJobCollectionGet Retrieves a list of DCN jobs.
*/
func (a *Client) DataEngineJobCollectionGet(params *DataEngineJobCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineJobCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDataEngineJobCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "data_engine_job_collection_get",
		Method:             "GET",
		PathPattern:        "/data-engine/jobs",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DataEngineJobCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DataEngineJobCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DataEngineJobCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DataEngineJobGet Retrieves the details of a specific DCN job.
*/
func (a *Client) DataEngineJobGet(params *DataEngineJobGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEngineJobGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDataEngineJobGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "data_engine_job_get",
		Method:             "GET",
		PathPattern:        "/data-engine/jobs/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DataEngineJobGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DataEngineJobGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DataEngineJobGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DataEnginePolicyCollectionGet Retrieves a list of policies.
*/
func (a *Client) DataEnginePolicyCollectionGet(params *DataEnginePolicyCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEnginePolicyCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDataEnginePolicyCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "data_engine_policy_collection_get",
		Method:             "GET",
		PathPattern:        "/data-engine/policies",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DataEnginePolicyCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DataEnginePolicyCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DataEnginePolicyCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DataEnginePolicyGet Retrieves the details of the specified data engine policy.
*/
func (a *Client) DataEnginePolicyGet(params *DataEnginePolicyGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEnginePolicyGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDataEnginePolicyGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "data_engine_policy_get",
		Method:             "GET",
		PathPattern:        "/data-engine/policies/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DataEnginePolicyGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DataEnginePolicyGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DataEnginePolicyGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DataEnginePolicyModify Updates a data engine policy. Every update to the data engine policy creates a new version of the policy.
*/
func (a *Client) DataEnginePolicyModify(params *DataEnginePolicyModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEnginePolicyModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDataEnginePolicyModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "data_engine_policy_modify",
		Method:             "PATCH",
		PathPattern:        "/data-engine/policies/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DataEnginePolicyModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DataEnginePolicyModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DataEnginePolicyModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DataEnginePolicyModifyCollection data engine policy modify collection API
*/
func (a *Client) DataEnginePolicyModifyCollection(params *DataEnginePolicyModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEnginePolicyModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDataEnginePolicyModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "data_engine_policy_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/data-engine/policies",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DataEnginePolicyModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DataEnginePolicyModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DataEnginePolicyModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DataEnginePolicyVersionCollectionGet Retrieves all the versions of the specified data engine policy.
*/
func (a *Client) DataEnginePolicyVersionCollectionGet(params *DataEnginePolicyVersionCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEnginePolicyVersionCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDataEnginePolicyVersionCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "data_engine_policy_version_collection_get",
		Method:             "GET",
		PathPattern:        "/data-engine/policies/{data_engine_policy.uuid}/versions",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DataEnginePolicyVersionCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DataEnginePolicyVersionCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DataEnginePolicyVersionCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DataEnginePolicyVersionGet Retrieves the details of the specified version of the data engine policy.
*/
func (a *Client) DataEnginePolicyVersionGet(params *DataEnginePolicyVersionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataEnginePolicyVersionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDataEnginePolicyVersionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "data_engine_policy_version_get",
		Method:             "GET",
		PathPattern:        "/data-engine/policies/{data_engine_policy.uuid}/versions/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DataEnginePolicyVersionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DataEnginePolicyVersionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DataEnginePolicyVersionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DataSourceCollectionGet Retrieves a list of data sources.
*/
func (a *Client) DataSourceCollectionGet(params *DataSourceCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataSourceCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDataSourceCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "data_source_collection_get",
		Method:             "GET",
		PathPattern:        "/data-engine/data-sources",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DataSourceCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DataSourceCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DataSourceCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DataSourceGet Retrieves a data source by UUID.
*/
func (a *Client) DataSourceGet(params *DataSourceGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DataSourceGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDataSourceGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "data_source_get",
		Method:             "GET",
		PathPattern:        "/data-engine/data-sources/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DataSourceGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DataSourceGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DataSourceGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DatacollectionCollectionGet Retrieves all data collections in a workspace.
*/
func (a *Client) DatacollectionCollectionGet(params *DatacollectionCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DatacollectionCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDatacollectionCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "datacollection_collection_get",
		Method:             "GET",
		PathPattern:        "/data-engine/workspaces/{workspace.uuid}/data-collections",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DatacollectionCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DatacollectionCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DatacollectionCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DatacollectionCreate Creates a data collection in a workspace.
*/
func (a *Client) DatacollectionCreate(params *DatacollectionCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DatacollectionCreateCreated, *DatacollectionCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDatacollectionCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "datacollection_create",
		Method:             "POST",
		PathPattern:        "/data-engine/workspaces/{workspace.uuid}/data-collections",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DatacollectionCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *DatacollectionCreateCreated:
		return value, nil, nil
	case *DatacollectionCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DatacollectionCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DatacollectionDelete Deletes a data collection in a workspace.
*/
func (a *Client) DatacollectionDelete(params *DatacollectionDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DatacollectionDeleteOK, *DatacollectionDeleteAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDatacollectionDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "datacollection_delete",
		Method:             "DELETE",
		PathPattern:        "/data-engine/workspaces/{workspace.uuid}/data-collections/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DatacollectionDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *DatacollectionDeleteOK:
		return value, nil, nil
	case *DatacollectionDeleteAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DatacollectionDeleteDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DatacollectionDeleteCollection datacollection delete collection API
*/
func (a *Client) DatacollectionDeleteCollection(params *DatacollectionDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DatacollectionDeleteCollectionOK, *DatacollectionDeleteCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDatacollectionDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "datacollection_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/data-engine/workspaces/{workspace.uuid}/data-collections",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DatacollectionDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *DatacollectionDeleteCollectionOK:
		return value, nil, nil
	case *DatacollectionDeleteCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DatacollectionDeleteCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DatacollectionEntityCollectionGet Retrieves all entities in a data collection.
*/
func (a *Client) DatacollectionEntityCollectionGet(params *DatacollectionEntityCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DatacollectionEntityCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDatacollectionEntityCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "datacollection_entity_collection_get",
		Method:             "GET",
		PathPattern:        "/data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/entities",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DatacollectionEntityCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DatacollectionEntityCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DatacollectionEntityCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	DatacollectionEntityCreate Creates a new entity in a data collection.

### Required properties
* type `uuid` - Unique identifier of the entity
*/
func (a *Client) DatacollectionEntityCreate(params *DatacollectionEntityCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DatacollectionEntityCreateCreated, *DatacollectionEntityCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDatacollectionEntityCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "datacollection_entity_create",
		Method:             "POST",
		PathPattern:        "/data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/entities",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DatacollectionEntityCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *DatacollectionEntityCreateCreated:
		return value, nil, nil
	case *DatacollectionEntityCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DatacollectionEntityCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DatacollectionEntityDelete Deletes an entity in a data collection.
*/
func (a *Client) DatacollectionEntityDelete(params *DatacollectionEntityDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DatacollectionEntityDeleteOK, *DatacollectionEntityDeleteAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDatacollectionEntityDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "datacollection_entity_delete",
		Method:             "DELETE",
		PathPattern:        "/data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/entities/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DatacollectionEntityDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *DatacollectionEntityDeleteOK:
		return value, nil, nil
	case *DatacollectionEntityDeleteAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DatacollectionEntityDeleteDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DatacollectionEntityDeleteCollection datacollection entity delete collection API
*/
func (a *Client) DatacollectionEntityDeleteCollection(params *DatacollectionEntityDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DatacollectionEntityDeleteCollectionOK, *DatacollectionEntityDeleteCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDatacollectionEntityDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "datacollection_entity_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/entities",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DatacollectionEntityDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *DatacollectionEntityDeleteCollectionOK:
		return value, nil, nil
	case *DatacollectionEntityDeleteCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DatacollectionEntityDeleteCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DatacollectionEntityGet Retrieves an entity in a data collection.
*/
func (a *Client) DatacollectionEntityGet(params *DatacollectionEntityGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DatacollectionEntityGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDatacollectionEntityGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "datacollection_entity_get",
		Method:             "GET",
		PathPattern:        "/data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/entities/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DatacollectionEntityGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DatacollectionEntityGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DatacollectionEntityGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DatacollectionGet Retrieves a data collection in a workspace.
*/
func (a *Client) DatacollectionGet(params *DatacollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DatacollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDatacollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "datacollection_get",
		Method:             "GET",
		PathPattern:        "/data-engine/workspaces/{workspace.uuid}/data-collections/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DatacollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DatacollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DatacollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DatacollectionModify Updates a data collection in a workspace.
*/
func (a *Client) DatacollectionModify(params *DatacollectionModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DatacollectionModifyOK, *DatacollectionModifyAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDatacollectionModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "datacollection_modify",
		Method:             "PATCH",
		PathPattern:        "/data-engine/workspaces/{workspace.uuid}/data-collections/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DatacollectionModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *DatacollectionModifyOK:
		return value, nil, nil
	case *DatacollectionModifyAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DatacollectionModifyDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DatacollectionModifyCollection datacollection modify collection API
*/
func (a *Client) DatacollectionModifyCollection(params *DatacollectionModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DatacollectionModifyCollectionOK, *DatacollectionModifyCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDatacollectionModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "datacollection_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/data-engine/workspaces/{workspace.uuid}/data-collections",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DatacollectionModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *DatacollectionModifyCollectionOK:
		return value, nil, nil
	case *DatacollectionModifyCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DatacollectionModifyCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DatacollectionSearchDataGet Performs a similarity search of the given prompt against the entities in a data collection.
*/
func (a *Client) DatacollectionSearchDataGet(params *DatacollectionSearchDataGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DatacollectionSearchDataGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDatacollectionSearchDataGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "datacollection_search_data_get",
		Method:             "GET",
		PathPattern:        "/data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/search",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DatacollectionSearchDataGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DatacollectionSearchDataGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DatacollectionSearchDataGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DatacollectionVersionCollectionGet Retrieves all versions of a data collection in a workspace.
*/
func (a *Client) DatacollectionVersionCollectionGet(params *DatacollectionVersionCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DatacollectionVersionCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDatacollectionVersionCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "datacollection_version_collection_get",
		Method:             "GET",
		PathPattern:        "/data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/versions",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DatacollectionVersionCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DatacollectionVersionCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DatacollectionVersionCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DatacollectionVersionDiffCollectionGet Retrieves all data collection version diffs.
*/
func (a *Client) DatacollectionVersionDiffCollectionGet(params *DatacollectionVersionDiffCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DatacollectionVersionDiffCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDatacollectionVersionDiffCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "datacollection_version_diff_collection_get",
		Method:             "GET",
		PathPattern:        "/data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/versions/{datacollection_version.uuid}/diffs",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DatacollectionVersionDiffCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DatacollectionVersionDiffCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DatacollectionVersionDiffCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DatacollectionVersionDiffCreate Creates a data collection version diff in a workspace.
*/
func (a *Client) DatacollectionVersionDiffCreate(params *DatacollectionVersionDiffCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DatacollectionVersionDiffCreateCreated, *DatacollectionVersionDiffCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDatacollectionVersionDiffCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "datacollection_version_diff_create",
		Method:             "POST",
		PathPattern:        "/data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/versions/{datacollection_version.uuid}/diffs",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DatacollectionVersionDiffCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *DatacollectionVersionDiffCreateCreated:
		return value, nil, nil
	case *DatacollectionVersionDiffCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DatacollectionVersionDiffCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DatacollectionVersionGet Retrieves a data collection version in a workspace.
*/
func (a *Client) DatacollectionVersionGet(params *DatacollectionVersionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DatacollectionVersionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDatacollectionVersionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "datacollection_version_get",
		Method:             "GET",
		PathPattern:        "/data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/versions/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DatacollectionVersionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DatacollectionVersionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DatacollectionVersionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GovernanceAggregationsGet Retrieves aggregation data across all workspaces.
*/
func (a *Client) GovernanceAggregationsGet(params *GovernanceAggregationsGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GovernanceAggregationsGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGovernanceAggregationsGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "governance_aggregations_get",
		Method:             "GET",
		PathPattern:        "/data-engine/governance/aggregation",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GovernanceAggregationsGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GovernanceAggregationsGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GovernanceAggregationsGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GovernanceWorkspaceAggregationsCollectionGet Retrieves aggregation data for workspaces.
*/
func (a *Client) GovernanceWorkspaceAggregationsCollectionGet(params *GovernanceWorkspaceAggregationsCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GovernanceWorkspaceAggregationsCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGovernanceWorkspaceAggregationsCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "governance_workspace_aggregations_collection_get",
		Method:             "GET",
		PathPattern:        "/data-engine/governance/aggregation/workspaces",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GovernanceWorkspaceAggregationsCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GovernanceWorkspaceAggregationsCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GovernanceWorkspaceAggregationsCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GovernanceWorkspaceAggregationsGet Retrieves aggregation data for workspaces.
*/
func (a *Client) GovernanceWorkspaceAggregationsGet(params *GovernanceWorkspaceAggregationsGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GovernanceWorkspaceAggregationsGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGovernanceWorkspaceAggregationsGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "governance_workspace_aggregations_get",
		Method:             "GET",
		PathPattern:        "/data-engine/governance/aggregation/workspaces/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GovernanceWorkspaceAggregationsGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GovernanceWorkspaceAggregationsGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GovernanceWorkspaceAggregationsGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WorkspaceCollectionGet Retrieves a list of workspaces.
*/
func (a *Client) WorkspaceCollectionGet(params *WorkspaceCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WorkspaceCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWorkspaceCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "workspace_collection_get",
		Method:             "GET",
		PathPattern:        "/data-engine/workspaces",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WorkspaceCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WorkspaceCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WorkspaceCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	 WorkspaceCreate Creates a workspace.
	### Required properties

* `name` - The name for the workspace.
* `data_sources` - The data sources to be added to the workspace.
*/
func (a *Client) WorkspaceCreate(params *WorkspaceCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WorkspaceCreateCreated, *WorkspaceCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWorkspaceCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "workspace_create",
		Method:             "POST",
		PathPattern:        "/data-engine/workspaces",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WorkspaceCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *WorkspaceCreateCreated:
		return value, nil, nil
	case *WorkspaceCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WorkspaceCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WorkspaceDataSourceCollectionGet Retrieves data sources in a workspace.
*/
func (a *Client) WorkspaceDataSourceCollectionGet(params *WorkspaceDataSourceCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WorkspaceDataSourceCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWorkspaceDataSourceCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "workspace_data_source_collection_get",
		Method:             "GET",
		PathPattern:        "/data-engine/workspaces/{workspace.uuid}/data-sources",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WorkspaceDataSourceCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WorkspaceDataSourceCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WorkspaceDataSourceCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	WorkspaceDataSourceCreate Creates a data source in a workspace.

### Required properties
* `type` - Type of the data source
* `local_storage` - Local storage configuration. For remote data sources, only the SVM details are required.
*/
func (a *Client) WorkspaceDataSourceCreate(params *WorkspaceDataSourceCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WorkspaceDataSourceCreateCreated, *WorkspaceDataSourceCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWorkspaceDataSourceCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "workspace_data_source_create",
		Method:             "POST",
		PathPattern:        "/data-engine/workspaces/{workspace.uuid}/data-sources",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WorkspaceDataSourceCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *WorkspaceDataSourceCreateCreated:
		return value, nil, nil
	case *WorkspaceDataSourceCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WorkspaceDataSourceCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WorkspaceDataSourceDelete Deletes a data source in a workspace.
*/
func (a *Client) WorkspaceDataSourceDelete(params *WorkspaceDataSourceDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WorkspaceDataSourceDeleteOK, *WorkspaceDataSourceDeleteAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWorkspaceDataSourceDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "workspace_data_source_delete",
		Method:             "DELETE",
		PathPattern:        "/data-engine/workspaces/{workspace.uuid}/data-sources/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WorkspaceDataSourceDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *WorkspaceDataSourceDeleteOK:
		return value, nil, nil
	case *WorkspaceDataSourceDeleteAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WorkspaceDataSourceDeleteDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WorkspaceDataSourceDeleteCollection workspace data source delete collection API
*/
func (a *Client) WorkspaceDataSourceDeleteCollection(params *WorkspaceDataSourceDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WorkspaceDataSourceDeleteCollectionOK, *WorkspaceDataSourceDeleteCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWorkspaceDataSourceDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "workspace_data_source_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/data-engine/workspaces/{workspace.uuid}/data-sources",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WorkspaceDataSourceDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *WorkspaceDataSourceDeleteCollectionOK:
		return value, nil, nil
	case *WorkspaceDataSourceDeleteCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WorkspaceDataSourceDeleteCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WorkspaceDataSourceGet Retrieves a data source within workspaces.
*/
func (a *Client) WorkspaceDataSourceGet(params *WorkspaceDataSourceGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WorkspaceDataSourceGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWorkspaceDataSourceGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "workspace_data_source_get",
		Method:             "GET",
		PathPattern:        "/data-engine/workspaces/{workspace.uuid}/data-sources/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WorkspaceDataSourceGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WorkspaceDataSourceGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WorkspaceDataSourceGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WorkspaceDelete Deletes a workspace.
*/
func (a *Client) WorkspaceDelete(params *WorkspaceDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WorkspaceDeleteOK, *WorkspaceDeleteAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWorkspaceDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "workspace_delete",
		Method:             "DELETE",
		PathPattern:        "/data-engine/workspaces/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WorkspaceDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *WorkspaceDeleteOK:
		return value, nil, nil
	case *WorkspaceDeleteAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WorkspaceDeleteDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WorkspaceDeleteCollection workspace delete collection API
*/
func (a *Client) WorkspaceDeleteCollection(params *WorkspaceDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WorkspaceDeleteCollectionOK, *WorkspaceDeleteCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWorkspaceDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "workspace_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/data-engine/workspaces",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WorkspaceDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *WorkspaceDeleteCollectionOK:
		return value, nil, nil
	case *WorkspaceDeleteCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WorkspaceDeleteCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WorkspaceGet Retrieves a workspace.
*/
func (a *Client) WorkspaceGet(params *WorkspaceGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WorkspaceGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWorkspaceGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "workspace_get",
		Method:             "GET",
		PathPattern:        "/data-engine/workspaces/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WorkspaceGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WorkspaceGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WorkspaceGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WorkspaceModify Modifies a workspace.
*/
func (a *Client) WorkspaceModify(params *WorkspaceModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WorkspaceModifyOK, *WorkspaceModifyAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWorkspaceModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "workspace_modify",
		Method:             "PATCH",
		PathPattern:        "/data-engine/workspaces/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WorkspaceModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *WorkspaceModifyOK:
		return value, nil, nil
	case *WorkspaceModifyAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WorkspaceModifyDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WorkspaceModifyCollection workspace modify collection API
*/
func (a *Client) WorkspaceModifyCollection(params *WorkspaceModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WorkspaceModifyCollectionOK, *WorkspaceModifyCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWorkspaceModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "workspace_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/data-engine/workspaces",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WorkspaceModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *WorkspaceModifyCollectionOK:
		return value, nil, nil
	case *WorkspaceModifyCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WorkspaceModifyCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WorkspaceQueryCollectionGet Retrieves a list of queries in a workspace.
*/
func (a *Client) WorkspaceQueryCollectionGet(params *WorkspaceQueryCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WorkspaceQueryCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWorkspaceQueryCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "workspace_query_collection_get",
		Method:             "GET",
		PathPattern:        "/data-engine/workspaces/{workspace.uuid}/queries",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WorkspaceQueryCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WorkspaceQueryCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WorkspaceQueryCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WorkspaceQueryCreate Creates a query in a workspace.
*/
func (a *Client) WorkspaceQueryCreate(params *WorkspaceQueryCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WorkspaceQueryCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWorkspaceQueryCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "workspace_query_create",
		Method:             "POST",
		PathPattern:        "/data-engine/workspaces/{workspace.uuid}/queries",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WorkspaceQueryCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WorkspaceQueryCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WorkspaceQueryCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WorkspaceQueryDelete Deletes a query in a workspace.
*/
func (a *Client) WorkspaceQueryDelete(params *WorkspaceQueryDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WorkspaceQueryDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWorkspaceQueryDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "workspace_query_delete",
		Method:             "DELETE",
		PathPattern:        "/data-engine/workspaces/{workspace.uuid}/queries/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WorkspaceQueryDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WorkspaceQueryDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WorkspaceQueryDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WorkspaceQueryDeleteCollection workspace query delete collection API
*/
func (a *Client) WorkspaceQueryDeleteCollection(params *WorkspaceQueryDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WorkspaceQueryDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWorkspaceQueryDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "workspace_query_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/data-engine/workspaces/{workspace.uuid}/queries",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WorkspaceQueryDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WorkspaceQueryDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WorkspaceQueryDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WorkspaceQueryEntityCollectionGet Retrieves entities from the workspace that match the specified query criteria.
*/
func (a *Client) WorkspaceQueryEntityCollectionGet(params *WorkspaceQueryEntityCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WorkspaceQueryEntityCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWorkspaceQueryEntityCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "workspace_query_entity_collection_get",
		Method:             "GET",
		PathPattern:        "/data-engine/workspaces/{workspace.uuid}/queries/{workspace_query.uuid}/entities",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WorkspaceQueryEntityCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WorkspaceQueryEntityCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WorkspaceQueryEntityCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WorkspaceQueryGet Retrieves a query in a workspace.
*/
func (a *Client) WorkspaceQueryGet(params *WorkspaceQueryGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WorkspaceQueryGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWorkspaceQueryGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "workspace_query_get",
		Method:             "GET",
		PathPattern:        "/data-engine/workspaces/{workspace.uuid}/queries/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WorkspaceQueryGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WorkspaceQueryGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WorkspaceQueryGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WorkspaceQueryModify Updates a query in a workspace. The expression of a query can be modified only if it is not being used in any data collection.
*/
func (a *Client) WorkspaceQueryModify(params *WorkspaceQueryModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WorkspaceQueryModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWorkspaceQueryModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "workspace_query_modify",
		Method:             "PATCH",
		PathPattern:        "/data-engine/workspaces/{workspace.uuid}/queries/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WorkspaceQueryModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WorkspaceQueryModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WorkspaceQueryModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WorkspaceQueryModifyCollection workspace query modify collection API
*/
func (a *Client) WorkspaceQueryModifyCollection(params *WorkspaceQueryModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WorkspaceQueryModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWorkspaceQueryModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "workspace_query_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/data-engine/workspaces/{workspace.uuid}/queries",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WorkspaceQueryModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WorkspaceQueryModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WorkspaceQueryModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WorkspaceVersionCollectionGet Retrieves a list of workspace versions.
*/
func (a *Client) WorkspaceVersionCollectionGet(params *WorkspaceVersionCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WorkspaceVersionCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWorkspaceVersionCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "workspace_version_collection_get",
		Method:             "GET",
		PathPattern:        "/data-engine/workspaces/{workspace.uuid}/versions",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WorkspaceVersionCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WorkspaceVersionCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WorkspaceVersionCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WorkspaceVersionDiffCollectionGet Retrieves all workspace version diffs.
*/
func (a *Client) WorkspaceVersionDiffCollectionGet(params *WorkspaceVersionDiffCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WorkspaceVersionDiffCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWorkspaceVersionDiffCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "workspace_version_diff_collection_get",
		Method:             "GET",
		PathPattern:        "/data-engine/workspaces/{workspace.uuid}/versions/{workspace_version.uuid}/diffs",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WorkspaceVersionDiffCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WorkspaceVersionDiffCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WorkspaceVersionDiffCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WorkspaceVersionDiffCreate Creates a workspace version diff.
*/
func (a *Client) WorkspaceVersionDiffCreate(params *WorkspaceVersionDiffCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WorkspaceVersionDiffCreateCreated, *WorkspaceVersionDiffCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWorkspaceVersionDiffCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "workspace_version_diff_create",
		Method:             "POST",
		PathPattern:        "/data-engine/workspaces/{workspace.uuid}/versions/{workspace_version.uuid}/diffs",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WorkspaceVersionDiffCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *WorkspaceVersionDiffCreateCreated:
		return value, nil, nil
	case *WorkspaceVersionDiffCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WorkspaceVersionDiffCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WorkspaceVersionGet Retrieves a workspace version.
*/
func (a *Client) WorkspaceVersionGet(params *WorkspaceVersionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WorkspaceVersionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWorkspaceVersionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "workspace_version_get",
		Method:             "GET",
		PathPattern:        "/data-engine/workspaces/{workspace.uuid}/versions/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WorkspaceVersionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WorkspaceVersionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WorkspaceVersionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
