// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewDataEngineDatacollectionACLCollectionGetParams creates a new DataEngineDatacollectionACLCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDataEngineDatacollectionACLCollectionGetParams() *DataEngineDatacollectionACLCollectionGetParams {
	return &DataEngineDatacollectionACLCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDataEngineDatacollectionACLCollectionGetParamsWithTimeout creates a new DataEngineDatacollectionACLCollectionGetParams object
// with the ability to set a timeout on a request.
func NewDataEngineDatacollectionACLCollectionGetParamsWithTimeout(timeout time.Duration) *DataEngineDatacollectionACLCollectionGetParams {
	return &DataEngineDatacollectionACLCollectionGetParams{
		timeout: timeout,
	}
}

// NewDataEngineDatacollectionACLCollectionGetParamsWithContext creates a new DataEngineDatacollectionACLCollectionGetParams object
// with the ability to set a context for a request.
func NewDataEngineDatacollectionACLCollectionGetParamsWithContext(ctx context.Context) *DataEngineDatacollectionACLCollectionGetParams {
	return &DataEngineDatacollectionACLCollectionGetParams{
		Context: ctx,
	}
}

// NewDataEngineDatacollectionACLCollectionGetParamsWithHTTPClient creates a new DataEngineDatacollectionACLCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewDataEngineDatacollectionACLCollectionGetParamsWithHTTPClient(client *http.Client) *DataEngineDatacollectionACLCollectionGetParams {
	return &DataEngineDatacollectionACLCollectionGetParams{
		HTTPClient: client,
	}
}

/*
DataEngineDatacollectionACLCollectionGetParams contains all the parameters to send to the API endpoint

	for the data engine datacollection acl collection get operation.

	Typically these are written to a http.Request.
*/
type DataEngineDatacollectionACLCollectionGetParams struct {

	/* DataCollectionName.

	   Filter by data_collection.name
	*/
	DataCollectionName *string

	/* DataCollectionUUID.

	   Filter by data_collection.uuid
	*/
	DataCollectionUUID *string

	/* DatacollectionUUID.

	   Unique identifier of the data collection.
	*/
	DatacollectionUUID string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* UserOrGroupAllocationTime.

	   Filter by user_or_group.allocation_time
	*/
	UserOrGroupAllocationTime *string

	/* UserOrGroupName.

	   Filter by user_or_group.name
	*/
	UserOrGroupName *string

	/* WorkspaceName.

	   Filter by workspace.name
	*/
	WorkspaceName *string

	/* WorkspaceUUID.

	   Unique identifier of the workspace.
	*/
	WorkspaceUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the data engine datacollection acl collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DataEngineDatacollectionACLCollectionGetParams) WithDefaults() *DataEngineDatacollectionACLCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the data engine datacollection acl collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DataEngineDatacollectionACLCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := DataEngineDatacollectionACLCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the data engine datacollection acl collection get params
func (o *DataEngineDatacollectionACLCollectionGetParams) WithTimeout(timeout time.Duration) *DataEngineDatacollectionACLCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the data engine datacollection acl collection get params
func (o *DataEngineDatacollectionACLCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the data engine datacollection acl collection get params
func (o *DataEngineDatacollectionACLCollectionGetParams) WithContext(ctx context.Context) *DataEngineDatacollectionACLCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the data engine datacollection acl collection get params
func (o *DataEngineDatacollectionACLCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the data engine datacollection acl collection get params
func (o *DataEngineDatacollectionACLCollectionGetParams) WithHTTPClient(client *http.Client) *DataEngineDatacollectionACLCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the data engine datacollection acl collection get params
func (o *DataEngineDatacollectionACLCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithDataCollectionName adds the dataCollectionName to the data engine datacollection acl collection get params
func (o *DataEngineDatacollectionACLCollectionGetParams) WithDataCollectionName(dataCollectionName *string) *DataEngineDatacollectionACLCollectionGetParams {
	o.SetDataCollectionName(dataCollectionName)
	return o
}

// SetDataCollectionName adds the dataCollectionName to the data engine datacollection acl collection get params
func (o *DataEngineDatacollectionACLCollectionGetParams) SetDataCollectionName(dataCollectionName *string) {
	o.DataCollectionName = dataCollectionName
}

// WithDataCollectionUUID adds the dataCollectionUUID to the data engine datacollection acl collection get params
func (o *DataEngineDatacollectionACLCollectionGetParams) WithDataCollectionUUID(dataCollectionUUID *string) *DataEngineDatacollectionACLCollectionGetParams {
	o.SetDataCollectionUUID(dataCollectionUUID)
	return o
}

// SetDataCollectionUUID adds the dataCollectionUuid to the data engine datacollection acl collection get params
func (o *DataEngineDatacollectionACLCollectionGetParams) SetDataCollectionUUID(dataCollectionUUID *string) {
	o.DataCollectionUUID = dataCollectionUUID
}

// WithDatacollectionUUID adds the datacollectionUUID to the data engine datacollection acl collection get params
func (o *DataEngineDatacollectionACLCollectionGetParams) WithDatacollectionUUID(datacollectionUUID string) *DataEngineDatacollectionACLCollectionGetParams {
	o.SetDatacollectionUUID(datacollectionUUID)
	return o
}

// SetDatacollectionUUID adds the datacollectionUuid to the data engine datacollection acl collection get params
func (o *DataEngineDatacollectionACLCollectionGetParams) SetDatacollectionUUID(datacollectionUUID string) {
	o.DatacollectionUUID = datacollectionUUID
}

// WithFields adds the fields to the data engine datacollection acl collection get params
func (o *DataEngineDatacollectionACLCollectionGetParams) WithFields(fields []string) *DataEngineDatacollectionACLCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the data engine datacollection acl collection get params
func (o *DataEngineDatacollectionACLCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithMaxRecords adds the maxRecords to the data engine datacollection acl collection get params
func (o *DataEngineDatacollectionACLCollectionGetParams) WithMaxRecords(maxRecords *int64) *DataEngineDatacollectionACLCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the data engine datacollection acl collection get params
func (o *DataEngineDatacollectionACLCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithOrderBy adds the orderBy to the data engine datacollection acl collection get params
func (o *DataEngineDatacollectionACLCollectionGetParams) WithOrderBy(orderBy []string) *DataEngineDatacollectionACLCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the data engine datacollection acl collection get params
func (o *DataEngineDatacollectionACLCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the data engine datacollection acl collection get params
func (o *DataEngineDatacollectionACLCollectionGetParams) WithReturnRecords(returnRecords *bool) *DataEngineDatacollectionACLCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the data engine datacollection acl collection get params
func (o *DataEngineDatacollectionACLCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the data engine datacollection acl collection get params
func (o *DataEngineDatacollectionACLCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *DataEngineDatacollectionACLCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the data engine datacollection acl collection get params
func (o *DataEngineDatacollectionACLCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithUserOrGroupAllocationTime adds the userOrGroupAllocationTime to the data engine datacollection acl collection get params
func (o *DataEngineDatacollectionACLCollectionGetParams) WithUserOrGroupAllocationTime(userOrGroupAllocationTime *string) *DataEngineDatacollectionACLCollectionGetParams {
	o.SetUserOrGroupAllocationTime(userOrGroupAllocationTime)
	return o
}

// SetUserOrGroupAllocationTime adds the userOrGroupAllocationTime to the data engine datacollection acl collection get params
func (o *DataEngineDatacollectionACLCollectionGetParams) SetUserOrGroupAllocationTime(userOrGroupAllocationTime *string) {
	o.UserOrGroupAllocationTime = userOrGroupAllocationTime
}

// WithUserOrGroupName adds the userOrGroupName to the data engine datacollection acl collection get params
func (o *DataEngineDatacollectionACLCollectionGetParams) WithUserOrGroupName(userOrGroupName *string) *DataEngineDatacollectionACLCollectionGetParams {
	o.SetUserOrGroupName(userOrGroupName)
	return o
}

// SetUserOrGroupName adds the userOrGroupName to the data engine datacollection acl collection get params
func (o *DataEngineDatacollectionACLCollectionGetParams) SetUserOrGroupName(userOrGroupName *string) {
	o.UserOrGroupName = userOrGroupName
}

// WithWorkspaceName adds the workspaceName to the data engine datacollection acl collection get params
func (o *DataEngineDatacollectionACLCollectionGetParams) WithWorkspaceName(workspaceName *string) *DataEngineDatacollectionACLCollectionGetParams {
	o.SetWorkspaceName(workspaceName)
	return o
}

// SetWorkspaceName adds the workspaceName to the data engine datacollection acl collection get params
func (o *DataEngineDatacollectionACLCollectionGetParams) SetWorkspaceName(workspaceName *string) {
	o.WorkspaceName = workspaceName
}

// WithWorkspaceUUID adds the workspaceUUID to the data engine datacollection acl collection get params
func (o *DataEngineDatacollectionACLCollectionGetParams) WithWorkspaceUUID(workspaceUUID string) *DataEngineDatacollectionACLCollectionGetParams {
	o.SetWorkspaceUUID(workspaceUUID)
	return o
}

// SetWorkspaceUUID adds the workspaceUuid to the data engine datacollection acl collection get params
func (o *DataEngineDatacollectionACLCollectionGetParams) SetWorkspaceUUID(workspaceUUID string) {
	o.WorkspaceUUID = workspaceUUID
}

// WriteToRequest writes these params to a swagger request
func (o *DataEngineDatacollectionACLCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.DataCollectionName != nil {

		// query param data_collection.name
		var qrDataCollectionName string

		if o.DataCollectionName != nil {
			qrDataCollectionName = *o.DataCollectionName
		}
		qDataCollectionName := qrDataCollectionName
		if qDataCollectionName != "" {

			if err := r.SetQueryParam("data_collection.name", qDataCollectionName); err != nil {
				return err
			}
		}
	}

	if o.DataCollectionUUID != nil {

		// query param data_collection.uuid
		var qrDataCollectionUUID string

		if o.DataCollectionUUID != nil {
			qrDataCollectionUUID = *o.DataCollectionUUID
		}
		qDataCollectionUUID := qrDataCollectionUUID
		if qDataCollectionUUID != "" {

			if err := r.SetQueryParam("data_collection.uuid", qDataCollectionUUID); err != nil {
				return err
			}
		}
	}

	// path param datacollection.uuid
	if err := r.SetPathParam("datacollection.uuid", o.DatacollectionUUID); err != nil {
		return err
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.UserOrGroupAllocationTime != nil {

		// query param user_or_group.allocation_time
		var qrUserOrGroupAllocationTime string

		if o.UserOrGroupAllocationTime != nil {
			qrUserOrGroupAllocationTime = *o.UserOrGroupAllocationTime
		}
		qUserOrGroupAllocationTime := qrUserOrGroupAllocationTime
		if qUserOrGroupAllocationTime != "" {

			if err := r.SetQueryParam("user_or_group.allocation_time", qUserOrGroupAllocationTime); err != nil {
				return err
			}
		}
	}

	if o.UserOrGroupName != nil {

		// query param user_or_group.name
		var qrUserOrGroupName string

		if o.UserOrGroupName != nil {
			qrUserOrGroupName = *o.UserOrGroupName
		}
		qUserOrGroupName := qrUserOrGroupName
		if qUserOrGroupName != "" {

			if err := r.SetQueryParam("user_or_group.name", qUserOrGroupName); err != nil {
				return err
			}
		}
	}

	if o.WorkspaceName != nil {

		// query param workspace.name
		var qrWorkspaceName string

		if o.WorkspaceName != nil {
			qrWorkspaceName = *o.WorkspaceName
		}
		qWorkspaceName := qrWorkspaceName
		if qWorkspaceName != "" {

			if err := r.SetQueryParam("workspace.name", qWorkspaceName); err != nil {
				return err
			}
		}
	}

	// path param workspace.uuid
	if err := r.SetPathParam("workspace.uuid", o.WorkspaceUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamDataEngineDatacollectionACLCollectionGet binds the parameter fields
func (o *DataEngineDatacollectionACLCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamDataEngineDatacollectionACLCollectionGet binds the parameter order_by
func (o *DataEngineDatacollectionACLCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
