// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewDataEngineDatacollectionACLCreateParams creates a new DataEngineDatacollectionACLCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDataEngineDatacollectionACLCreateParams() *DataEngineDatacollectionACLCreateParams {
	return &DataEngineDatacollectionACLCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDataEngineDatacollectionACLCreateParamsWithTimeout creates a new DataEngineDatacollectionACLCreateParams object
// with the ability to set a timeout on a request.
func NewDataEngineDatacollectionACLCreateParamsWithTimeout(timeout time.Duration) *DataEngineDatacollectionACLCreateParams {
	return &DataEngineDatacollectionACLCreateParams{
		timeout: timeout,
	}
}

// NewDataEngineDatacollectionACLCreateParamsWithContext creates a new DataEngineDatacollectionACLCreateParams object
// with the ability to set a context for a request.
func NewDataEngineDatacollectionACLCreateParamsWithContext(ctx context.Context) *DataEngineDatacollectionACLCreateParams {
	return &DataEngineDatacollectionACLCreateParams{
		Context: ctx,
	}
}

// NewDataEngineDatacollectionACLCreateParamsWithHTTPClient creates a new DataEngineDatacollectionACLCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewDataEngineDatacollectionACLCreateParamsWithHTTPClient(client *http.Client) *DataEngineDatacollectionACLCreateParams {
	return &DataEngineDatacollectionACLCreateParams{
		HTTPClient: client,
	}
}

/*
DataEngineDatacollectionACLCreateParams contains all the parameters to send to the API endpoint

	for the data engine datacollection acl create operation.

	Typically these are written to a http.Request.
*/
type DataEngineDatacollectionACLCreateParams struct {

	/* DatacollectionUUID.

	   Unique identifier of the data collection.
	*/
	DatacollectionUUID string

	/* Info.

	   ACL specification
	*/
	Info *models.DataEngineDatacollectionACL

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	/* WorkspaceUUID.

	   Unique identifier of the workspace.
	*/
	WorkspaceUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the data engine datacollection acl create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DataEngineDatacollectionACLCreateParams) WithDefaults() *DataEngineDatacollectionACLCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the data engine datacollection acl create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DataEngineDatacollectionACLCreateParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)
	)

	val := DataEngineDatacollectionACLCreateParams{
		ReturnRecords: &returnRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the data engine datacollection acl create params
func (o *DataEngineDatacollectionACLCreateParams) WithTimeout(timeout time.Duration) *DataEngineDatacollectionACLCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the data engine datacollection acl create params
func (o *DataEngineDatacollectionACLCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the data engine datacollection acl create params
func (o *DataEngineDatacollectionACLCreateParams) WithContext(ctx context.Context) *DataEngineDatacollectionACLCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the data engine datacollection acl create params
func (o *DataEngineDatacollectionACLCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the data engine datacollection acl create params
func (o *DataEngineDatacollectionACLCreateParams) WithHTTPClient(client *http.Client) *DataEngineDatacollectionACLCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the data engine datacollection acl create params
func (o *DataEngineDatacollectionACLCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithDatacollectionUUID adds the datacollectionUUID to the data engine datacollection acl create params
func (o *DataEngineDatacollectionACLCreateParams) WithDatacollectionUUID(datacollectionUUID string) *DataEngineDatacollectionACLCreateParams {
	o.SetDatacollectionUUID(datacollectionUUID)
	return o
}

// SetDatacollectionUUID adds the datacollectionUuid to the data engine datacollection acl create params
func (o *DataEngineDatacollectionACLCreateParams) SetDatacollectionUUID(datacollectionUUID string) {
	o.DatacollectionUUID = datacollectionUUID
}

// WithInfo adds the info to the data engine datacollection acl create params
func (o *DataEngineDatacollectionACLCreateParams) WithInfo(info *models.DataEngineDatacollectionACL) *DataEngineDatacollectionACLCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the data engine datacollection acl create params
func (o *DataEngineDatacollectionACLCreateParams) SetInfo(info *models.DataEngineDatacollectionACL) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the data engine datacollection acl create params
func (o *DataEngineDatacollectionACLCreateParams) WithReturnRecords(returnRecords *bool) *DataEngineDatacollectionACLCreateParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the data engine datacollection acl create params
func (o *DataEngineDatacollectionACLCreateParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithWorkspaceUUID adds the workspaceUUID to the data engine datacollection acl create params
func (o *DataEngineDatacollectionACLCreateParams) WithWorkspaceUUID(workspaceUUID string) *DataEngineDatacollectionACLCreateParams {
	o.SetWorkspaceUUID(workspaceUUID)
	return o
}

// SetWorkspaceUUID adds the workspaceUuid to the data engine datacollection acl create params
func (o *DataEngineDatacollectionACLCreateParams) SetWorkspaceUUID(workspaceUUID string) {
	o.WorkspaceUUID = workspaceUUID
}

// WriteToRequest writes these params to a swagger request
func (o *DataEngineDatacollectionACLCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param datacollection.uuid
	if err := r.SetPathParam("datacollection.uuid", o.DatacollectionUUID); err != nil {
		return err
	}
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	// path param workspace.uuid
	if err := r.SetPathParam("workspace.uuid", o.WorkspaceUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
