// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DataEngineDatacollectionACLCreateReader is a Reader for the DataEngineDatacollectionACLCreate structure.
type DataEngineDatacollectionACLCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DataEngineDatacollectionACLCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewDataEngineDatacollectionACLCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDataEngineDatacollectionACLCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDataEngineDatacollectionACLCreateCreated creates a DataEngineDatacollectionACLCreateCreated with default headers values
func NewDataEngineDatacollectionACLCreateCreated() *DataEngineDatacollectionACLCreateCreated {
	return &DataEngineDatacollectionACLCreateCreated{}
}

/*
DataEngineDatacollectionACLCreateCreated describes a response with status code 201, with default header values.

Created
*/
type DataEngineDatacollectionACLCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.DataEngineDatacollectionACLResponse
}

// IsSuccess returns true when this data engine datacollection Acl create created response has a 2xx status code
func (o *DataEngineDatacollectionACLCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this data engine datacollection Acl create created response has a 3xx status code
func (o *DataEngineDatacollectionACLCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this data engine datacollection Acl create created response has a 4xx status code
func (o *DataEngineDatacollectionACLCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this data engine datacollection Acl create created response has a 5xx status code
func (o *DataEngineDatacollectionACLCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this data engine datacollection Acl create created response a status code equal to that given
func (o *DataEngineDatacollectionACLCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the data engine datacollection Acl create created response
func (o *DataEngineDatacollectionACLCreateCreated) Code() int {
	return 201
}

func (o *DataEngineDatacollectionACLCreateCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/acls][%d] dataEngineDatacollectionAclCreateCreated %s", 201, payload)
}

func (o *DataEngineDatacollectionACLCreateCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/acls][%d] dataEngineDatacollectionAclCreateCreated %s", 201, payload)
}

func (o *DataEngineDatacollectionACLCreateCreated) GetPayload() *models.DataEngineDatacollectionACLResponse {
	return o.Payload
}

func (o *DataEngineDatacollectionACLCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.DataEngineDatacollectionACLResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDataEngineDatacollectionACLCreateDefault creates a DataEngineDatacollectionACLCreateDefault with default headers values
func NewDataEngineDatacollectionACLCreateDefault(code int) *DataEngineDatacollectionACLCreateDefault {
	return &DataEngineDatacollectionACLCreateDefault{
		_statusCode: code,
	}
}

/*
DataEngineDatacollectionACLCreateDefault describes a response with status code -1, with default header values.

Error in creating the ACL for the data collection.
*/
type DataEngineDatacollectionACLCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this data engine datacollection acl create default response has a 2xx status code
func (o *DataEngineDatacollectionACLCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this data engine datacollection acl create default response has a 3xx status code
func (o *DataEngineDatacollectionACLCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this data engine datacollection acl create default response has a 4xx status code
func (o *DataEngineDatacollectionACLCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this data engine datacollection acl create default response has a 5xx status code
func (o *DataEngineDatacollectionACLCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this data engine datacollection acl create default response a status code equal to that given
func (o *DataEngineDatacollectionACLCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the data engine datacollection acl create default response
func (o *DataEngineDatacollectionACLCreateDefault) Code() int {
	return o._statusCode
}

func (o *DataEngineDatacollectionACLCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/acls][%d] data_engine_datacollection_acl_create default %s", o._statusCode, payload)
}

func (o *DataEngineDatacollectionACLCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/acls][%d] data_engine_datacollection_acl_create default %s", o._statusCode, payload)
}

func (o *DataEngineDatacollectionACLCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DataEngineDatacollectionACLCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
