// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewDataEngineDatacollectionACLDeleteCollectionParams creates a new DataEngineDatacollectionACLDeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDataEngineDatacollectionACLDeleteCollectionParams() *DataEngineDatacollectionACLDeleteCollectionParams {
	return &DataEngineDatacollectionACLDeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDataEngineDatacollectionACLDeleteCollectionParamsWithTimeout creates a new DataEngineDatacollectionACLDeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewDataEngineDatacollectionACLDeleteCollectionParamsWithTimeout(timeout time.Duration) *DataEngineDatacollectionACLDeleteCollectionParams {
	return &DataEngineDatacollectionACLDeleteCollectionParams{
		timeout: timeout,
	}
}

// NewDataEngineDatacollectionACLDeleteCollectionParamsWithContext creates a new DataEngineDatacollectionACLDeleteCollectionParams object
// with the ability to set a context for a request.
func NewDataEngineDatacollectionACLDeleteCollectionParamsWithContext(ctx context.Context) *DataEngineDatacollectionACLDeleteCollectionParams {
	return &DataEngineDatacollectionACLDeleteCollectionParams{
		Context: ctx,
	}
}

// NewDataEngineDatacollectionACLDeleteCollectionParamsWithHTTPClient creates a new DataEngineDatacollectionACLDeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewDataEngineDatacollectionACLDeleteCollectionParamsWithHTTPClient(client *http.Client) *DataEngineDatacollectionACLDeleteCollectionParams {
	return &DataEngineDatacollectionACLDeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
DataEngineDatacollectionACLDeleteCollectionParams contains all the parameters to send to the API endpoint

	for the data engine datacollection acl delete collection operation.

	Typically these are written to a http.Request.
*/
type DataEngineDatacollectionACLDeleteCollectionParams struct {

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* DataCollectionName.

	   Filter by data_collection.name
	*/
	DataCollectionName *string

	/* DataCollectionUUID.

	   Filter by data_collection.uuid
	*/
	DataCollectionUUID *string

	/* DatacollectionUUID.

	   Unique identifier of the data collection.
	*/
	DatacollectionUUID string

	/* Info.

	   Info specification
	*/
	Info DataEngineDatacollectionACLDeleteCollectionBody

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* UserOrGroupAllocationTime.

	   Filter by user_or_group.allocation_time
	*/
	UserOrGroupAllocationTime *string

	/* UserOrGroupName.

	   Filter by user_or_group.name
	*/
	UserOrGroupName *string

	/* WorkspaceName.

	   Filter by workspace.name
	*/
	WorkspaceName *string

	/* WorkspaceUUID.

	   Unique identifier of the workspace.
	*/
	WorkspaceUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the data engine datacollection acl delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DataEngineDatacollectionACLDeleteCollectionParams) WithDefaults() *DataEngineDatacollectionACLDeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the data engine datacollection acl delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DataEngineDatacollectionACLDeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := DataEngineDatacollectionACLDeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the data engine datacollection acl delete collection params
func (o *DataEngineDatacollectionACLDeleteCollectionParams) WithTimeout(timeout time.Duration) *DataEngineDatacollectionACLDeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the data engine datacollection acl delete collection params
func (o *DataEngineDatacollectionACLDeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the data engine datacollection acl delete collection params
func (o *DataEngineDatacollectionACLDeleteCollectionParams) WithContext(ctx context.Context) *DataEngineDatacollectionACLDeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the data engine datacollection acl delete collection params
func (o *DataEngineDatacollectionACLDeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the data engine datacollection acl delete collection params
func (o *DataEngineDatacollectionACLDeleteCollectionParams) WithHTTPClient(client *http.Client) *DataEngineDatacollectionACLDeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the data engine datacollection acl delete collection params
func (o *DataEngineDatacollectionACLDeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithContinueOnFailure adds the continueOnFailure to the data engine datacollection acl delete collection params
func (o *DataEngineDatacollectionACLDeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *DataEngineDatacollectionACLDeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the data engine datacollection acl delete collection params
func (o *DataEngineDatacollectionACLDeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithDataCollectionName adds the dataCollectionName to the data engine datacollection acl delete collection params
func (o *DataEngineDatacollectionACLDeleteCollectionParams) WithDataCollectionName(dataCollectionName *string) *DataEngineDatacollectionACLDeleteCollectionParams {
	o.SetDataCollectionName(dataCollectionName)
	return o
}

// SetDataCollectionName adds the dataCollectionName to the data engine datacollection acl delete collection params
func (o *DataEngineDatacollectionACLDeleteCollectionParams) SetDataCollectionName(dataCollectionName *string) {
	o.DataCollectionName = dataCollectionName
}

// WithDataCollectionUUID adds the dataCollectionUUID to the data engine datacollection acl delete collection params
func (o *DataEngineDatacollectionACLDeleteCollectionParams) WithDataCollectionUUID(dataCollectionUUID *string) *DataEngineDatacollectionACLDeleteCollectionParams {
	o.SetDataCollectionUUID(dataCollectionUUID)
	return o
}

// SetDataCollectionUUID adds the dataCollectionUuid to the data engine datacollection acl delete collection params
func (o *DataEngineDatacollectionACLDeleteCollectionParams) SetDataCollectionUUID(dataCollectionUUID *string) {
	o.DataCollectionUUID = dataCollectionUUID
}

// WithDatacollectionUUID adds the datacollectionUUID to the data engine datacollection acl delete collection params
func (o *DataEngineDatacollectionACLDeleteCollectionParams) WithDatacollectionUUID(datacollectionUUID string) *DataEngineDatacollectionACLDeleteCollectionParams {
	o.SetDatacollectionUUID(datacollectionUUID)
	return o
}

// SetDatacollectionUUID adds the datacollectionUuid to the data engine datacollection acl delete collection params
func (o *DataEngineDatacollectionACLDeleteCollectionParams) SetDatacollectionUUID(datacollectionUUID string) {
	o.DatacollectionUUID = datacollectionUUID
}

// WithInfo adds the info to the data engine datacollection acl delete collection params
func (o *DataEngineDatacollectionACLDeleteCollectionParams) WithInfo(info DataEngineDatacollectionACLDeleteCollectionBody) *DataEngineDatacollectionACLDeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the data engine datacollection acl delete collection params
func (o *DataEngineDatacollectionACLDeleteCollectionParams) SetInfo(info DataEngineDatacollectionACLDeleteCollectionBody) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the data engine datacollection acl delete collection params
func (o *DataEngineDatacollectionACLDeleteCollectionParams) WithReturnRecords(returnRecords *bool) *DataEngineDatacollectionACLDeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the data engine datacollection acl delete collection params
func (o *DataEngineDatacollectionACLDeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the data engine datacollection acl delete collection params
func (o *DataEngineDatacollectionACLDeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *DataEngineDatacollectionACLDeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the data engine datacollection acl delete collection params
func (o *DataEngineDatacollectionACLDeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the data engine datacollection acl delete collection params
func (o *DataEngineDatacollectionACLDeleteCollectionParams) WithSerialRecords(serialRecords *bool) *DataEngineDatacollectionACLDeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the data engine datacollection acl delete collection params
func (o *DataEngineDatacollectionACLDeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithUserOrGroupAllocationTime adds the userOrGroupAllocationTime to the data engine datacollection acl delete collection params
func (o *DataEngineDatacollectionACLDeleteCollectionParams) WithUserOrGroupAllocationTime(userOrGroupAllocationTime *string) *DataEngineDatacollectionACLDeleteCollectionParams {
	o.SetUserOrGroupAllocationTime(userOrGroupAllocationTime)
	return o
}

// SetUserOrGroupAllocationTime adds the userOrGroupAllocationTime to the data engine datacollection acl delete collection params
func (o *DataEngineDatacollectionACLDeleteCollectionParams) SetUserOrGroupAllocationTime(userOrGroupAllocationTime *string) {
	o.UserOrGroupAllocationTime = userOrGroupAllocationTime
}

// WithUserOrGroupName adds the userOrGroupName to the data engine datacollection acl delete collection params
func (o *DataEngineDatacollectionACLDeleteCollectionParams) WithUserOrGroupName(userOrGroupName *string) *DataEngineDatacollectionACLDeleteCollectionParams {
	o.SetUserOrGroupName(userOrGroupName)
	return o
}

// SetUserOrGroupName adds the userOrGroupName to the data engine datacollection acl delete collection params
func (o *DataEngineDatacollectionACLDeleteCollectionParams) SetUserOrGroupName(userOrGroupName *string) {
	o.UserOrGroupName = userOrGroupName
}

// WithWorkspaceName adds the workspaceName to the data engine datacollection acl delete collection params
func (o *DataEngineDatacollectionACLDeleteCollectionParams) WithWorkspaceName(workspaceName *string) *DataEngineDatacollectionACLDeleteCollectionParams {
	o.SetWorkspaceName(workspaceName)
	return o
}

// SetWorkspaceName adds the workspaceName to the data engine datacollection acl delete collection params
func (o *DataEngineDatacollectionACLDeleteCollectionParams) SetWorkspaceName(workspaceName *string) {
	o.WorkspaceName = workspaceName
}

// WithWorkspaceUUID adds the workspaceUUID to the data engine datacollection acl delete collection params
func (o *DataEngineDatacollectionACLDeleteCollectionParams) WithWorkspaceUUID(workspaceUUID string) *DataEngineDatacollectionACLDeleteCollectionParams {
	o.SetWorkspaceUUID(workspaceUUID)
	return o
}

// SetWorkspaceUUID adds the workspaceUuid to the data engine datacollection acl delete collection params
func (o *DataEngineDatacollectionACLDeleteCollectionParams) SetWorkspaceUUID(workspaceUUID string) {
	o.WorkspaceUUID = workspaceUUID
}

// WriteToRequest writes these params to a swagger request
func (o *DataEngineDatacollectionACLDeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.DataCollectionName != nil {

		// query param data_collection.name
		var qrDataCollectionName string

		if o.DataCollectionName != nil {
			qrDataCollectionName = *o.DataCollectionName
		}
		qDataCollectionName := qrDataCollectionName
		if qDataCollectionName != "" {

			if err := r.SetQueryParam("data_collection.name", qDataCollectionName); err != nil {
				return err
			}
		}
	}

	if o.DataCollectionUUID != nil {

		// query param data_collection.uuid
		var qrDataCollectionUUID string

		if o.DataCollectionUUID != nil {
			qrDataCollectionUUID = *o.DataCollectionUUID
		}
		qDataCollectionUUID := qrDataCollectionUUID
		if qDataCollectionUUID != "" {

			if err := r.SetQueryParam("data_collection.uuid", qDataCollectionUUID); err != nil {
				return err
			}
		}
	}

	// path param datacollection.uuid
	if err := r.SetPathParam("datacollection.uuid", o.DatacollectionUUID); err != nil {
		return err
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.UserOrGroupAllocationTime != nil {

		// query param user_or_group.allocation_time
		var qrUserOrGroupAllocationTime string

		if o.UserOrGroupAllocationTime != nil {
			qrUserOrGroupAllocationTime = *o.UserOrGroupAllocationTime
		}
		qUserOrGroupAllocationTime := qrUserOrGroupAllocationTime
		if qUserOrGroupAllocationTime != "" {

			if err := r.SetQueryParam("user_or_group.allocation_time", qUserOrGroupAllocationTime); err != nil {
				return err
			}
		}
	}

	if o.UserOrGroupName != nil {

		// query param user_or_group.name
		var qrUserOrGroupName string

		if o.UserOrGroupName != nil {
			qrUserOrGroupName = *o.UserOrGroupName
		}
		qUserOrGroupName := qrUserOrGroupName
		if qUserOrGroupName != "" {

			if err := r.SetQueryParam("user_or_group.name", qUserOrGroupName); err != nil {
				return err
			}
		}
	}

	if o.WorkspaceName != nil {

		// query param workspace.name
		var qrWorkspaceName string

		if o.WorkspaceName != nil {
			qrWorkspaceName = *o.WorkspaceName
		}
		qWorkspaceName := qrWorkspaceName
		if qWorkspaceName != "" {

			if err := r.SetQueryParam("workspace.name", qWorkspaceName); err != nil {
				return err
			}
		}
	}

	// path param workspace.uuid
	if err := r.SetPathParam("workspace.uuid", o.WorkspaceUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
