// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DataEngineDatacollectionACLDeleteCollectionReader is a Reader for the DataEngineDatacollectionACLDeleteCollection structure.
type DataEngineDatacollectionACLDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DataEngineDatacollectionACLDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDataEngineDatacollectionACLDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDataEngineDatacollectionACLDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDataEngineDatacollectionACLDeleteCollectionOK creates a DataEngineDatacollectionACLDeleteCollectionOK with default headers values
func NewDataEngineDatacollectionACLDeleteCollectionOK() *DataEngineDatacollectionACLDeleteCollectionOK {
	return &DataEngineDatacollectionACLDeleteCollectionOK{}
}

/*
DataEngineDatacollectionACLDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type DataEngineDatacollectionACLDeleteCollectionOK struct {
}

// IsSuccess returns true when this data engine datacollection Acl delete collection o k response has a 2xx status code
func (o *DataEngineDatacollectionACLDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this data engine datacollection Acl delete collection o k response has a 3xx status code
func (o *DataEngineDatacollectionACLDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this data engine datacollection Acl delete collection o k response has a 4xx status code
func (o *DataEngineDatacollectionACLDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this data engine datacollection Acl delete collection o k response has a 5xx status code
func (o *DataEngineDatacollectionACLDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this data engine datacollection Acl delete collection o k response a status code equal to that given
func (o *DataEngineDatacollectionACLDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the data engine datacollection Acl delete collection o k response
func (o *DataEngineDatacollectionACLDeleteCollectionOK) Code() int {
	return 200
}

func (o *DataEngineDatacollectionACLDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/acls][%d] dataEngineDatacollectionAclDeleteCollectionOK", 200)
}

func (o *DataEngineDatacollectionACLDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/acls][%d] dataEngineDatacollectionAclDeleteCollectionOK", 200)
}

func (o *DataEngineDatacollectionACLDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewDataEngineDatacollectionACLDeleteCollectionDefault creates a DataEngineDatacollectionACLDeleteCollectionDefault with default headers values
func NewDataEngineDatacollectionACLDeleteCollectionDefault(code int) *DataEngineDatacollectionACLDeleteCollectionDefault {
	return &DataEngineDatacollectionACLDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
DataEngineDatacollectionACLDeleteCollectionDefault describes a response with status code -1, with default header values.

Error in deleting the ACL for the data collection.
*/
type DataEngineDatacollectionACLDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this data engine datacollection acl delete collection default response has a 2xx status code
func (o *DataEngineDatacollectionACLDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this data engine datacollection acl delete collection default response has a 3xx status code
func (o *DataEngineDatacollectionACLDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this data engine datacollection acl delete collection default response has a 4xx status code
func (o *DataEngineDatacollectionACLDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this data engine datacollection acl delete collection default response has a 5xx status code
func (o *DataEngineDatacollectionACLDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this data engine datacollection acl delete collection default response a status code equal to that given
func (o *DataEngineDatacollectionACLDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the data engine datacollection acl delete collection default response
func (o *DataEngineDatacollectionACLDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *DataEngineDatacollectionACLDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/acls][%d] data_engine_datacollection_acl_delete_collection default %s", o._statusCode, payload)
}

func (o *DataEngineDatacollectionACLDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/acls][%d] data_engine_datacollection_acl_delete_collection default %s", o._statusCode, payload)
}

func (o *DataEngineDatacollectionACLDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DataEngineDatacollectionACLDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
DataEngineDatacollectionACLDeleteCollectionBody Defines the structure of the response for data engine data collection ACL requests.
swagger:model DataEngineDatacollectionACLDeleteCollectionBody
*/
type DataEngineDatacollectionACLDeleteCollectionBody struct {

	// data engine datacollection acl response inline records
	DataEngineDatacollectionACLResponseInlineRecords []*models.DataEngineDatacollectionACL `json:"records,omitempty"`

	// The total number of ACL records available.
	// Example: 100
	// Read Only: true
	TotalRecords *int64 `json:"total_records,omitempty"`
}

// Validate validates this data engine datacollection ACL delete collection body
func (o *DataEngineDatacollectionACLDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateDataEngineDatacollectionACLResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DataEngineDatacollectionACLDeleteCollectionBody) validateDataEngineDatacollectionACLResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.DataEngineDatacollectionACLResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.DataEngineDatacollectionACLResponseInlineRecords); i++ {
		if swag.IsZero(o.DataEngineDatacollectionACLResponseInlineRecords[i]) { // not required
			continue
		}

		if o.DataEngineDatacollectionACLResponseInlineRecords[i] != nil {
			if err := o.DataEngineDatacollectionACLResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this data engine datacollection ACL delete collection body based on the context it is used
func (o *DataEngineDatacollectionACLDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateDataEngineDatacollectionACLResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTotalRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DataEngineDatacollectionACLDeleteCollectionBody) contextValidateDataEngineDatacollectionACLResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.DataEngineDatacollectionACLResponseInlineRecords); i++ {

		if o.DataEngineDatacollectionACLResponseInlineRecords[i] != nil {
			if err := o.DataEngineDatacollectionACLResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *DataEngineDatacollectionACLDeleteCollectionBody) contextValidateTotalRecords(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"total_records", "body", o.TotalRecords); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *DataEngineDatacollectionACLDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *DataEngineDatacollectionACLDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res DataEngineDatacollectionACLDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
