// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewDataEngineDatacollectionACLGetParams creates a new DataEngineDatacollectionACLGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDataEngineDatacollectionACLGetParams() *DataEngineDatacollectionACLGetParams {
	return &DataEngineDatacollectionACLGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDataEngineDatacollectionACLGetParamsWithTimeout creates a new DataEngineDatacollectionACLGetParams object
// with the ability to set a timeout on a request.
func NewDataEngineDatacollectionACLGetParamsWithTimeout(timeout time.Duration) *DataEngineDatacollectionACLGetParams {
	return &DataEngineDatacollectionACLGetParams{
		timeout: timeout,
	}
}

// NewDataEngineDatacollectionACLGetParamsWithContext creates a new DataEngineDatacollectionACLGetParams object
// with the ability to set a context for a request.
func NewDataEngineDatacollectionACLGetParamsWithContext(ctx context.Context) *DataEngineDatacollectionACLGetParams {
	return &DataEngineDatacollectionACLGetParams{
		Context: ctx,
	}
}

// NewDataEngineDatacollectionACLGetParamsWithHTTPClient creates a new DataEngineDatacollectionACLGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewDataEngineDatacollectionACLGetParamsWithHTTPClient(client *http.Client) *DataEngineDatacollectionACLGetParams {
	return &DataEngineDatacollectionACLGetParams{
		HTTPClient: client,
	}
}

/*
DataEngineDatacollectionACLGetParams contains all the parameters to send to the API endpoint

	for the data engine datacollection acl get operation.

	Typically these are written to a http.Request.
*/
type DataEngineDatacollectionACLGetParams struct {

	/* DatacollectionUUID.

	   Unique identifier of the data collection.
	*/
	DatacollectionUUID string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* UserOrGroupName.

	   User or group name associated with the ACL.
	*/
	UserOrGroupName string

	/* WorkspaceUUID.

	   Unique identifier of the workspace.
	*/
	WorkspaceUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the data engine datacollection acl get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DataEngineDatacollectionACLGetParams) WithDefaults() *DataEngineDatacollectionACLGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the data engine datacollection acl get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DataEngineDatacollectionACLGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the data engine datacollection acl get params
func (o *DataEngineDatacollectionACLGetParams) WithTimeout(timeout time.Duration) *DataEngineDatacollectionACLGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the data engine datacollection acl get params
func (o *DataEngineDatacollectionACLGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the data engine datacollection acl get params
func (o *DataEngineDatacollectionACLGetParams) WithContext(ctx context.Context) *DataEngineDatacollectionACLGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the data engine datacollection acl get params
func (o *DataEngineDatacollectionACLGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the data engine datacollection acl get params
func (o *DataEngineDatacollectionACLGetParams) WithHTTPClient(client *http.Client) *DataEngineDatacollectionACLGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the data engine datacollection acl get params
func (o *DataEngineDatacollectionACLGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithDatacollectionUUID adds the datacollectionUUID to the data engine datacollection acl get params
func (o *DataEngineDatacollectionACLGetParams) WithDatacollectionUUID(datacollectionUUID string) *DataEngineDatacollectionACLGetParams {
	o.SetDatacollectionUUID(datacollectionUUID)
	return o
}

// SetDatacollectionUUID adds the datacollectionUuid to the data engine datacollection acl get params
func (o *DataEngineDatacollectionACLGetParams) SetDatacollectionUUID(datacollectionUUID string) {
	o.DatacollectionUUID = datacollectionUUID
}

// WithFields adds the fields to the data engine datacollection acl get params
func (o *DataEngineDatacollectionACLGetParams) WithFields(fields []string) *DataEngineDatacollectionACLGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the data engine datacollection acl get params
func (o *DataEngineDatacollectionACLGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithUserOrGroupName adds the userOrGroupName to the data engine datacollection acl get params
func (o *DataEngineDatacollectionACLGetParams) WithUserOrGroupName(userOrGroupName string) *DataEngineDatacollectionACLGetParams {
	o.SetUserOrGroupName(userOrGroupName)
	return o
}

// SetUserOrGroupName adds the userOrGroupName to the data engine datacollection acl get params
func (o *DataEngineDatacollectionACLGetParams) SetUserOrGroupName(userOrGroupName string) {
	o.UserOrGroupName = userOrGroupName
}

// WithWorkspaceUUID adds the workspaceUUID to the data engine datacollection acl get params
func (o *DataEngineDatacollectionACLGetParams) WithWorkspaceUUID(workspaceUUID string) *DataEngineDatacollectionACLGetParams {
	o.SetWorkspaceUUID(workspaceUUID)
	return o
}

// SetWorkspaceUUID adds the workspaceUuid to the data engine datacollection acl get params
func (o *DataEngineDatacollectionACLGetParams) SetWorkspaceUUID(workspaceUUID string) {
	o.WorkspaceUUID = workspaceUUID
}

// WriteToRequest writes these params to a swagger request
func (o *DataEngineDatacollectionACLGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param datacollection.uuid
	if err := r.SetPathParam("datacollection.uuid", o.DatacollectionUUID); err != nil {
		return err
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param user_or_group.name
	if err := r.SetPathParam("user_or_group.name", o.UserOrGroupName); err != nil {
		return err
	}

	// path param workspace.uuid
	if err := r.SetPathParam("workspace.uuid", o.WorkspaceUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamDataEngineDatacollectionACLGet binds the parameter fields
func (o *DataEngineDatacollectionACLGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
