// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DataEngineDatacollectionACLGetReader is a Reader for the DataEngineDatacollectionACLGet structure.
type DataEngineDatacollectionACLGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DataEngineDatacollectionACLGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDataEngineDatacollectionACLGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDataEngineDatacollectionACLGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDataEngineDatacollectionACLGetOK creates a DataEngineDatacollectionACLGetOK with default headers values
func NewDataEngineDatacollectionACLGetOK() *DataEngineDatacollectionACLGetOK {
	return &DataEngineDatacollectionACLGetOK{}
}

/*
DataEngineDatacollectionACLGetOK describes a response with status code 200, with default header values.

OK
*/
type DataEngineDatacollectionACLGetOK struct {
	Payload *models.DataEngineDatacollectionACL
}

// IsSuccess returns true when this data engine datacollection Acl get o k response has a 2xx status code
func (o *DataEngineDatacollectionACLGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this data engine datacollection Acl get o k response has a 3xx status code
func (o *DataEngineDatacollectionACLGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this data engine datacollection Acl get o k response has a 4xx status code
func (o *DataEngineDatacollectionACLGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this data engine datacollection Acl get o k response has a 5xx status code
func (o *DataEngineDatacollectionACLGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this data engine datacollection Acl get o k response a status code equal to that given
func (o *DataEngineDatacollectionACLGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the data engine datacollection Acl get o k response
func (o *DataEngineDatacollectionACLGetOK) Code() int {
	return 200
}

func (o *DataEngineDatacollectionACLGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/acls/{user_or_group.name}][%d] dataEngineDatacollectionAclGetOK %s", 200, payload)
}

func (o *DataEngineDatacollectionACLGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/acls/{user_or_group.name}][%d] dataEngineDatacollectionAclGetOK %s", 200, payload)
}

func (o *DataEngineDatacollectionACLGetOK) GetPayload() *models.DataEngineDatacollectionACL {
	return o.Payload
}

func (o *DataEngineDatacollectionACLGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DataEngineDatacollectionACL)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDataEngineDatacollectionACLGetDefault creates a DataEngineDatacollectionACLGetDefault with default headers values
func NewDataEngineDatacollectionACLGetDefault(code int) *DataEngineDatacollectionACLGetDefault {
	return &DataEngineDatacollectionACLGetDefault{
		_statusCode: code,
	}
}

/*
DataEngineDatacollectionACLGetDefault describes a response with status code -1, with default header values.

Error in retrieving the ACL for the data collection.
*/
type DataEngineDatacollectionACLGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this data engine datacollection acl get default response has a 2xx status code
func (o *DataEngineDatacollectionACLGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this data engine datacollection acl get default response has a 3xx status code
func (o *DataEngineDatacollectionACLGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this data engine datacollection acl get default response has a 4xx status code
func (o *DataEngineDatacollectionACLGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this data engine datacollection acl get default response has a 5xx status code
func (o *DataEngineDatacollectionACLGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this data engine datacollection acl get default response a status code equal to that given
func (o *DataEngineDatacollectionACLGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the data engine datacollection acl get default response
func (o *DataEngineDatacollectionACLGetDefault) Code() int {
	return o._statusCode
}

func (o *DataEngineDatacollectionACLGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/acls/{user_or_group.name}][%d] data_engine_datacollection_acl_get default %s", o._statusCode, payload)
}

func (o *DataEngineDatacollectionACLGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/acls/{user_or_group.name}][%d] data_engine_datacollection_acl_get default %s", o._statusCode, payload)
}

func (o *DataEngineDatacollectionACLGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DataEngineDatacollectionACLGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
