// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewDataEngineEntityCollectionGetParams creates a new DataEngineEntityCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDataEngineEntityCollectionGetParams() *DataEngineEntityCollectionGetParams {
	return &DataEngineEntityCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDataEngineEntityCollectionGetParamsWithTimeout creates a new DataEngineEntityCollectionGetParams object
// with the ability to set a timeout on a request.
func NewDataEngineEntityCollectionGetParamsWithTimeout(timeout time.Duration) *DataEngineEntityCollectionGetParams {
	return &DataEngineEntityCollectionGetParams{
		timeout: timeout,
	}
}

// NewDataEngineEntityCollectionGetParamsWithContext creates a new DataEngineEntityCollectionGetParams object
// with the ability to set a context for a request.
func NewDataEngineEntityCollectionGetParamsWithContext(ctx context.Context) *DataEngineEntityCollectionGetParams {
	return &DataEngineEntityCollectionGetParams{
		Context: ctx,
	}
}

// NewDataEngineEntityCollectionGetParamsWithHTTPClient creates a new DataEngineEntityCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewDataEngineEntityCollectionGetParamsWithHTTPClient(client *http.Client) *DataEngineEntityCollectionGetParams {
	return &DataEngineEntityCollectionGetParams{
		HTTPClient: client,
	}
}

/*
DataEngineEntityCollectionGetParams contains all the parameters to send to the API endpoint

	for the data engine entity collection get operation.

	Typically these are written to a http.Request.
*/
type DataEngineEntityCollectionGetParams struct {

	/* AccessTime.

	   Filter by access_time
	*/
	AccessTime *string

	/* AttributesContentKey.

	   Filter by attributes.content.key
	*/
	AttributesContentKey *string

	/* AttributesContentValue.

	   Filter by attributes.content.value
	*/
	AttributesContentValue *string

	/* AttributesCustomKey.

	   Filter by attributes.custom.key
	*/
	AttributesCustomKey *string

	/* AttributesCustomValue.

	   Filter by attributes.custom.value
	*/
	AttributesCustomValue *string

	/* AttributesExtendedKey.

	   Filter by attributes.extended.key
	*/
	AttributesExtendedKey *string

	/* AttributesExtendedValue.

	   Filter by attributes.extended.value
	*/
	AttributesExtendedValue *string

	/* AttributesSystemKey.

	   Filter by attributes.system.key
	*/
	AttributesSystemKey *string

	/* AttributesSystemValue.

	   Filter by attributes.system.value
	*/
	AttributesSystemValue *string

	/* CanPreview.

	   Filter by can_preview
	*/
	CanPreview *bool

	/* ContentHash.

	   Filter by content_hash
	*/
	ContentHash *string

	/* CreateTime.

	   Filter by create_time
	*/
	CreateTime *string

	/* DatasourceName.

	   Filter by datasource.name
	*/
	DatasourceName *string

	/* DatasourceUUID.

	   Filter by datasource.uuid
	*/
	DatasourceUUID *string

	/* DatasourceVersionUUID.

	   Filter by datasource.version.uuid
	*/
	DatasourceVersionUUID *string

	/* ErrorsErrorCode.

	   Filter by errors.error.code
	*/
	ErrorsErrorCode *string

	/* ErrorsErrorMessage.

	   Filter by errors.error.message
	*/
	ErrorsErrorMessage *string

	/* ErrorsErrorTarget.

	   Filter by errors.error.target
	*/
	ErrorsErrorTarget *string

	/* Extension.

	   Filter by extension
	*/
	Extension *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* Format.

	   Filter by format
	*/
	Format *string

	/* HasPii.

	   Filter by has_pii
	*/
	HasPii *bool

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* Name.

	   Filter by name
	*/
	Name *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* PermissionsKey.

	   Filter by permissions.key
	*/
	PermissionsKey *string

	/* PermissionsValue.

	   Filter by permissions.value
	*/
	PermissionsValue *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Size.

	   Filter by size
	*/
	Size *int64

	/* Type.

	   Filter by type
	*/
	Type *string

	/* UpdateTime.

	   Filter by update_time
	*/
	UpdateTime *string

	/* URI.

	   Filter by uri
	*/
	URI *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	/* WorkspaceName.

	   Filter by workspace.name
	*/
	WorkspaceName *string

	/* WorkspaceUUID.

	   Unique identifier of the workspace.
	*/
	WorkspaceUUID string

	/* WorkspaceVersionUUID.

	   Filter by workspace.version.uuid
	*/
	WorkspaceVersionUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the data engine entity collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DataEngineEntityCollectionGetParams) WithDefaults() *DataEngineEntityCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the data engine entity collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DataEngineEntityCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := DataEngineEntityCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) WithTimeout(timeout time.Duration) *DataEngineEntityCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) WithContext(ctx context.Context) *DataEngineEntityCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) WithHTTPClient(client *http.Client) *DataEngineEntityCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAccessTime adds the accessTime to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) WithAccessTime(accessTime *string) *DataEngineEntityCollectionGetParams {
	o.SetAccessTime(accessTime)
	return o
}

// SetAccessTime adds the accessTime to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) SetAccessTime(accessTime *string) {
	o.AccessTime = accessTime
}

// WithAttributesContentKey adds the attributesContentKey to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) WithAttributesContentKey(attributesContentKey *string) *DataEngineEntityCollectionGetParams {
	o.SetAttributesContentKey(attributesContentKey)
	return o
}

// SetAttributesContentKey adds the attributesContentKey to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) SetAttributesContentKey(attributesContentKey *string) {
	o.AttributesContentKey = attributesContentKey
}

// WithAttributesContentValue adds the attributesContentValue to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) WithAttributesContentValue(attributesContentValue *string) *DataEngineEntityCollectionGetParams {
	o.SetAttributesContentValue(attributesContentValue)
	return o
}

// SetAttributesContentValue adds the attributesContentValue to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) SetAttributesContentValue(attributesContentValue *string) {
	o.AttributesContentValue = attributesContentValue
}

// WithAttributesCustomKey adds the attributesCustomKey to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) WithAttributesCustomKey(attributesCustomKey *string) *DataEngineEntityCollectionGetParams {
	o.SetAttributesCustomKey(attributesCustomKey)
	return o
}

// SetAttributesCustomKey adds the attributesCustomKey to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) SetAttributesCustomKey(attributesCustomKey *string) {
	o.AttributesCustomKey = attributesCustomKey
}

// WithAttributesCustomValue adds the attributesCustomValue to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) WithAttributesCustomValue(attributesCustomValue *string) *DataEngineEntityCollectionGetParams {
	o.SetAttributesCustomValue(attributesCustomValue)
	return o
}

// SetAttributesCustomValue adds the attributesCustomValue to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) SetAttributesCustomValue(attributesCustomValue *string) {
	o.AttributesCustomValue = attributesCustomValue
}

// WithAttributesExtendedKey adds the attributesExtendedKey to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) WithAttributesExtendedKey(attributesExtendedKey *string) *DataEngineEntityCollectionGetParams {
	o.SetAttributesExtendedKey(attributesExtendedKey)
	return o
}

// SetAttributesExtendedKey adds the attributesExtendedKey to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) SetAttributesExtendedKey(attributesExtendedKey *string) {
	o.AttributesExtendedKey = attributesExtendedKey
}

// WithAttributesExtendedValue adds the attributesExtendedValue to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) WithAttributesExtendedValue(attributesExtendedValue *string) *DataEngineEntityCollectionGetParams {
	o.SetAttributesExtendedValue(attributesExtendedValue)
	return o
}

// SetAttributesExtendedValue adds the attributesExtendedValue to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) SetAttributesExtendedValue(attributesExtendedValue *string) {
	o.AttributesExtendedValue = attributesExtendedValue
}

// WithAttributesSystemKey adds the attributesSystemKey to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) WithAttributesSystemKey(attributesSystemKey *string) *DataEngineEntityCollectionGetParams {
	o.SetAttributesSystemKey(attributesSystemKey)
	return o
}

// SetAttributesSystemKey adds the attributesSystemKey to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) SetAttributesSystemKey(attributesSystemKey *string) {
	o.AttributesSystemKey = attributesSystemKey
}

// WithAttributesSystemValue adds the attributesSystemValue to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) WithAttributesSystemValue(attributesSystemValue *string) *DataEngineEntityCollectionGetParams {
	o.SetAttributesSystemValue(attributesSystemValue)
	return o
}

// SetAttributesSystemValue adds the attributesSystemValue to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) SetAttributesSystemValue(attributesSystemValue *string) {
	o.AttributesSystemValue = attributesSystemValue
}

// WithCanPreview adds the canPreview to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) WithCanPreview(canPreview *bool) *DataEngineEntityCollectionGetParams {
	o.SetCanPreview(canPreview)
	return o
}

// SetCanPreview adds the canPreview to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) SetCanPreview(canPreview *bool) {
	o.CanPreview = canPreview
}

// WithContentHash adds the contentHash to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) WithContentHash(contentHash *string) *DataEngineEntityCollectionGetParams {
	o.SetContentHash(contentHash)
	return o
}

// SetContentHash adds the contentHash to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) SetContentHash(contentHash *string) {
	o.ContentHash = contentHash
}

// WithCreateTime adds the createTime to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) WithCreateTime(createTime *string) *DataEngineEntityCollectionGetParams {
	o.SetCreateTime(createTime)
	return o
}

// SetCreateTime adds the createTime to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) SetCreateTime(createTime *string) {
	o.CreateTime = createTime
}

// WithDatasourceName adds the datasourceName to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) WithDatasourceName(datasourceName *string) *DataEngineEntityCollectionGetParams {
	o.SetDatasourceName(datasourceName)
	return o
}

// SetDatasourceName adds the datasourceName to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) SetDatasourceName(datasourceName *string) {
	o.DatasourceName = datasourceName
}

// WithDatasourceUUID adds the datasourceUUID to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) WithDatasourceUUID(datasourceUUID *string) *DataEngineEntityCollectionGetParams {
	o.SetDatasourceUUID(datasourceUUID)
	return o
}

// SetDatasourceUUID adds the datasourceUuid to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) SetDatasourceUUID(datasourceUUID *string) {
	o.DatasourceUUID = datasourceUUID
}

// WithDatasourceVersionUUID adds the datasourceVersionUUID to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) WithDatasourceVersionUUID(datasourceVersionUUID *string) *DataEngineEntityCollectionGetParams {
	o.SetDatasourceVersionUUID(datasourceVersionUUID)
	return o
}

// SetDatasourceVersionUUID adds the datasourceVersionUuid to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) SetDatasourceVersionUUID(datasourceVersionUUID *string) {
	o.DatasourceVersionUUID = datasourceVersionUUID
}

// WithErrorsErrorCode adds the errorsErrorCode to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) WithErrorsErrorCode(errorsErrorCode *string) *DataEngineEntityCollectionGetParams {
	o.SetErrorsErrorCode(errorsErrorCode)
	return o
}

// SetErrorsErrorCode adds the errorsErrorCode to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) SetErrorsErrorCode(errorsErrorCode *string) {
	o.ErrorsErrorCode = errorsErrorCode
}

// WithErrorsErrorMessage adds the errorsErrorMessage to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) WithErrorsErrorMessage(errorsErrorMessage *string) *DataEngineEntityCollectionGetParams {
	o.SetErrorsErrorMessage(errorsErrorMessage)
	return o
}

// SetErrorsErrorMessage adds the errorsErrorMessage to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) SetErrorsErrorMessage(errorsErrorMessage *string) {
	o.ErrorsErrorMessage = errorsErrorMessage
}

// WithErrorsErrorTarget adds the errorsErrorTarget to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) WithErrorsErrorTarget(errorsErrorTarget *string) *DataEngineEntityCollectionGetParams {
	o.SetErrorsErrorTarget(errorsErrorTarget)
	return o
}

// SetErrorsErrorTarget adds the errorsErrorTarget to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) SetErrorsErrorTarget(errorsErrorTarget *string) {
	o.ErrorsErrorTarget = errorsErrorTarget
}

// WithExtension adds the extension to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) WithExtension(extension *string) *DataEngineEntityCollectionGetParams {
	o.SetExtension(extension)
	return o
}

// SetExtension adds the extension to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) SetExtension(extension *string) {
	o.Extension = extension
}

// WithFields adds the fields to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) WithFields(fields []string) *DataEngineEntityCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithFormat adds the format to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) WithFormat(format *string) *DataEngineEntityCollectionGetParams {
	o.SetFormat(format)
	return o
}

// SetFormat adds the format to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) SetFormat(format *string) {
	o.Format = format
}

// WithHasPii adds the hasPii to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) WithHasPii(hasPii *bool) *DataEngineEntityCollectionGetParams {
	o.SetHasPii(hasPii)
	return o
}

// SetHasPii adds the hasPii to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) SetHasPii(hasPii *bool) {
	o.HasPii = hasPii
}

// WithMaxRecords adds the maxRecords to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) WithMaxRecords(maxRecords *int64) *DataEngineEntityCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithName adds the name to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) WithName(name *string) *DataEngineEntityCollectionGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) SetName(name *string) {
	o.Name = name
}

// WithOrderBy adds the orderBy to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) WithOrderBy(orderBy []string) *DataEngineEntityCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithPermissionsKey adds the permissionsKey to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) WithPermissionsKey(permissionsKey *string) *DataEngineEntityCollectionGetParams {
	o.SetPermissionsKey(permissionsKey)
	return o
}

// SetPermissionsKey adds the permissionsKey to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) SetPermissionsKey(permissionsKey *string) {
	o.PermissionsKey = permissionsKey
}

// WithPermissionsValue adds the permissionsValue to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) WithPermissionsValue(permissionsValue *string) *DataEngineEntityCollectionGetParams {
	o.SetPermissionsValue(permissionsValue)
	return o
}

// SetPermissionsValue adds the permissionsValue to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) SetPermissionsValue(permissionsValue *string) {
	o.PermissionsValue = permissionsValue
}

// WithReturnRecords adds the returnRecords to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) WithReturnRecords(returnRecords *bool) *DataEngineEntityCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *DataEngineEntityCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSize adds the size to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) WithSize(size *int64) *DataEngineEntityCollectionGetParams {
	o.SetSize(size)
	return o
}

// SetSize adds the size to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) SetSize(size *int64) {
	o.Size = size
}

// WithType adds the typeVar to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) WithType(typeVar *string) *DataEngineEntityCollectionGetParams {
	o.SetType(typeVar)
	return o
}

// SetType adds the type to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) SetType(typeVar *string) {
	o.Type = typeVar
}

// WithUpdateTime adds the updateTime to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) WithUpdateTime(updateTime *string) *DataEngineEntityCollectionGetParams {
	o.SetUpdateTime(updateTime)
	return o
}

// SetUpdateTime adds the updateTime to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) SetUpdateTime(updateTime *string) {
	o.UpdateTime = updateTime
}

// WithURI adds the uri to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) WithURI(uri *string) *DataEngineEntityCollectionGetParams {
	o.SetURI(uri)
	return o
}

// SetURI adds the uri to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) SetURI(uri *string) {
	o.URI = uri
}

// WithUUID adds the uuid to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) WithUUID(uuid *string) *DataEngineEntityCollectionGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WithWorkspaceName adds the workspaceName to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) WithWorkspaceName(workspaceName *string) *DataEngineEntityCollectionGetParams {
	o.SetWorkspaceName(workspaceName)
	return o
}

// SetWorkspaceName adds the workspaceName to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) SetWorkspaceName(workspaceName *string) {
	o.WorkspaceName = workspaceName
}

// WithWorkspaceUUID adds the workspaceUUID to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) WithWorkspaceUUID(workspaceUUID string) *DataEngineEntityCollectionGetParams {
	o.SetWorkspaceUUID(workspaceUUID)
	return o
}

// SetWorkspaceUUID adds the workspaceUuid to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) SetWorkspaceUUID(workspaceUUID string) {
	o.WorkspaceUUID = workspaceUUID
}

// WithWorkspaceVersionUUID adds the workspaceVersionUUID to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) WithWorkspaceVersionUUID(workspaceVersionUUID *string) *DataEngineEntityCollectionGetParams {
	o.SetWorkspaceVersionUUID(workspaceVersionUUID)
	return o
}

// SetWorkspaceVersionUUID adds the workspaceVersionUuid to the data engine entity collection get params
func (o *DataEngineEntityCollectionGetParams) SetWorkspaceVersionUUID(workspaceVersionUUID *string) {
	o.WorkspaceVersionUUID = workspaceVersionUUID
}

// WriteToRequest writes these params to a swagger request
func (o *DataEngineEntityCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AccessTime != nil {

		// query param access_time
		var qrAccessTime string

		if o.AccessTime != nil {
			qrAccessTime = *o.AccessTime
		}
		qAccessTime := qrAccessTime
		if qAccessTime != "" {

			if err := r.SetQueryParam("access_time", qAccessTime); err != nil {
				return err
			}
		}
	}

	if o.AttributesContentKey != nil {

		// query param attributes.content.key
		var qrAttributesContentKey string

		if o.AttributesContentKey != nil {
			qrAttributesContentKey = *o.AttributesContentKey
		}
		qAttributesContentKey := qrAttributesContentKey
		if qAttributesContentKey != "" {

			if err := r.SetQueryParam("attributes.content.key", qAttributesContentKey); err != nil {
				return err
			}
		}
	}

	if o.AttributesContentValue != nil {

		// query param attributes.content.value
		var qrAttributesContentValue string

		if o.AttributesContentValue != nil {
			qrAttributesContentValue = *o.AttributesContentValue
		}
		qAttributesContentValue := qrAttributesContentValue
		if qAttributesContentValue != "" {

			if err := r.SetQueryParam("attributes.content.value", qAttributesContentValue); err != nil {
				return err
			}
		}
	}

	if o.AttributesCustomKey != nil {

		// query param attributes.custom.key
		var qrAttributesCustomKey string

		if o.AttributesCustomKey != nil {
			qrAttributesCustomKey = *o.AttributesCustomKey
		}
		qAttributesCustomKey := qrAttributesCustomKey
		if qAttributesCustomKey != "" {

			if err := r.SetQueryParam("attributes.custom.key", qAttributesCustomKey); err != nil {
				return err
			}
		}
	}

	if o.AttributesCustomValue != nil {

		// query param attributes.custom.value
		var qrAttributesCustomValue string

		if o.AttributesCustomValue != nil {
			qrAttributesCustomValue = *o.AttributesCustomValue
		}
		qAttributesCustomValue := qrAttributesCustomValue
		if qAttributesCustomValue != "" {

			if err := r.SetQueryParam("attributes.custom.value", qAttributesCustomValue); err != nil {
				return err
			}
		}
	}

	if o.AttributesExtendedKey != nil {

		// query param attributes.extended.key
		var qrAttributesExtendedKey string

		if o.AttributesExtendedKey != nil {
			qrAttributesExtendedKey = *o.AttributesExtendedKey
		}
		qAttributesExtendedKey := qrAttributesExtendedKey
		if qAttributesExtendedKey != "" {

			if err := r.SetQueryParam("attributes.extended.key", qAttributesExtendedKey); err != nil {
				return err
			}
		}
	}

	if o.AttributesExtendedValue != nil {

		// query param attributes.extended.value
		var qrAttributesExtendedValue string

		if o.AttributesExtendedValue != nil {
			qrAttributesExtendedValue = *o.AttributesExtendedValue
		}
		qAttributesExtendedValue := qrAttributesExtendedValue
		if qAttributesExtendedValue != "" {

			if err := r.SetQueryParam("attributes.extended.value", qAttributesExtendedValue); err != nil {
				return err
			}
		}
	}

	if o.AttributesSystemKey != nil {

		// query param attributes.system.key
		var qrAttributesSystemKey string

		if o.AttributesSystemKey != nil {
			qrAttributesSystemKey = *o.AttributesSystemKey
		}
		qAttributesSystemKey := qrAttributesSystemKey
		if qAttributesSystemKey != "" {

			if err := r.SetQueryParam("attributes.system.key", qAttributesSystemKey); err != nil {
				return err
			}
		}
	}

	if o.AttributesSystemValue != nil {

		// query param attributes.system.value
		var qrAttributesSystemValue string

		if o.AttributesSystemValue != nil {
			qrAttributesSystemValue = *o.AttributesSystemValue
		}
		qAttributesSystemValue := qrAttributesSystemValue
		if qAttributesSystemValue != "" {

			if err := r.SetQueryParam("attributes.system.value", qAttributesSystemValue); err != nil {
				return err
			}
		}
	}

	if o.CanPreview != nil {

		// query param can_preview
		var qrCanPreview bool

		if o.CanPreview != nil {
			qrCanPreview = *o.CanPreview
		}
		qCanPreview := swag.FormatBool(qrCanPreview)
		if qCanPreview != "" {

			if err := r.SetQueryParam("can_preview", qCanPreview); err != nil {
				return err
			}
		}
	}

	if o.ContentHash != nil {

		// query param content_hash
		var qrContentHash string

		if o.ContentHash != nil {
			qrContentHash = *o.ContentHash
		}
		qContentHash := qrContentHash
		if qContentHash != "" {

			if err := r.SetQueryParam("content_hash", qContentHash); err != nil {
				return err
			}
		}
	}

	if o.CreateTime != nil {

		// query param create_time
		var qrCreateTime string

		if o.CreateTime != nil {
			qrCreateTime = *o.CreateTime
		}
		qCreateTime := qrCreateTime
		if qCreateTime != "" {

			if err := r.SetQueryParam("create_time", qCreateTime); err != nil {
				return err
			}
		}
	}

	if o.DatasourceName != nil {

		// query param datasource.name
		var qrDatasourceName string

		if o.DatasourceName != nil {
			qrDatasourceName = *o.DatasourceName
		}
		qDatasourceName := qrDatasourceName
		if qDatasourceName != "" {

			if err := r.SetQueryParam("datasource.name", qDatasourceName); err != nil {
				return err
			}
		}
	}

	if o.DatasourceUUID != nil {

		// query param datasource.uuid
		var qrDatasourceUUID string

		if o.DatasourceUUID != nil {
			qrDatasourceUUID = *o.DatasourceUUID
		}
		qDatasourceUUID := qrDatasourceUUID
		if qDatasourceUUID != "" {

			if err := r.SetQueryParam("datasource.uuid", qDatasourceUUID); err != nil {
				return err
			}
		}
	}

	if o.DatasourceVersionUUID != nil {

		// query param datasource.version.uuid
		var qrDatasourceVersionUUID string

		if o.DatasourceVersionUUID != nil {
			qrDatasourceVersionUUID = *o.DatasourceVersionUUID
		}
		qDatasourceVersionUUID := qrDatasourceVersionUUID
		if qDatasourceVersionUUID != "" {

			if err := r.SetQueryParam("datasource.version.uuid", qDatasourceVersionUUID); err != nil {
				return err
			}
		}
	}

	if o.ErrorsErrorCode != nil {

		// query param errors.error.code
		var qrErrorsErrorCode string

		if o.ErrorsErrorCode != nil {
			qrErrorsErrorCode = *o.ErrorsErrorCode
		}
		qErrorsErrorCode := qrErrorsErrorCode
		if qErrorsErrorCode != "" {

			if err := r.SetQueryParam("errors.error.code", qErrorsErrorCode); err != nil {
				return err
			}
		}
	}

	if o.ErrorsErrorMessage != nil {

		// query param errors.error.message
		var qrErrorsErrorMessage string

		if o.ErrorsErrorMessage != nil {
			qrErrorsErrorMessage = *o.ErrorsErrorMessage
		}
		qErrorsErrorMessage := qrErrorsErrorMessage
		if qErrorsErrorMessage != "" {

			if err := r.SetQueryParam("errors.error.message", qErrorsErrorMessage); err != nil {
				return err
			}
		}
	}

	if o.ErrorsErrorTarget != nil {

		// query param errors.error.target
		var qrErrorsErrorTarget string

		if o.ErrorsErrorTarget != nil {
			qrErrorsErrorTarget = *o.ErrorsErrorTarget
		}
		qErrorsErrorTarget := qrErrorsErrorTarget
		if qErrorsErrorTarget != "" {

			if err := r.SetQueryParam("errors.error.target", qErrorsErrorTarget); err != nil {
				return err
			}
		}
	}

	if o.Extension != nil {

		// query param extension
		var qrExtension string

		if o.Extension != nil {
			qrExtension = *o.Extension
		}
		qExtension := qrExtension
		if qExtension != "" {

			if err := r.SetQueryParam("extension", qExtension); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.Format != nil {

		// query param format
		var qrFormat string

		if o.Format != nil {
			qrFormat = *o.Format
		}
		qFormat := qrFormat
		if qFormat != "" {

			if err := r.SetQueryParam("format", qFormat); err != nil {
				return err
			}
		}
	}

	if o.HasPii != nil {

		// query param has_pii
		var qrHasPii bool

		if o.HasPii != nil {
			qrHasPii = *o.HasPii
		}
		qHasPii := swag.FormatBool(qrHasPii)
		if qHasPii != "" {

			if err := r.SetQueryParam("has_pii", qHasPii); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.PermissionsKey != nil {

		// query param permissions.key
		var qrPermissionsKey string

		if o.PermissionsKey != nil {
			qrPermissionsKey = *o.PermissionsKey
		}
		qPermissionsKey := qrPermissionsKey
		if qPermissionsKey != "" {

			if err := r.SetQueryParam("permissions.key", qPermissionsKey); err != nil {
				return err
			}
		}
	}

	if o.PermissionsValue != nil {

		// query param permissions.value
		var qrPermissionsValue string

		if o.PermissionsValue != nil {
			qrPermissionsValue = *o.PermissionsValue
		}
		qPermissionsValue := qrPermissionsValue
		if qPermissionsValue != "" {

			if err := r.SetQueryParam("permissions.value", qPermissionsValue); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Size != nil {

		// query param size
		var qrSize int64

		if o.Size != nil {
			qrSize = *o.Size
		}
		qSize := swag.FormatInt64(qrSize)
		if qSize != "" {

			if err := r.SetQueryParam("size", qSize); err != nil {
				return err
			}
		}
	}

	if o.Type != nil {

		// query param type
		var qrType string

		if o.Type != nil {
			qrType = *o.Type
		}
		qType := qrType
		if qType != "" {

			if err := r.SetQueryParam("type", qType); err != nil {
				return err
			}
		}
	}

	if o.UpdateTime != nil {

		// query param update_time
		var qrUpdateTime string

		if o.UpdateTime != nil {
			qrUpdateTime = *o.UpdateTime
		}
		qUpdateTime := qrUpdateTime
		if qUpdateTime != "" {

			if err := r.SetQueryParam("update_time", qUpdateTime); err != nil {
				return err
			}
		}
	}

	if o.URI != nil {

		// query param uri
		var qrURI string

		if o.URI != nil {
			qrURI = *o.URI
		}
		qURI := qrURI
		if qURI != "" {

			if err := r.SetQueryParam("uri", qURI); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if o.WorkspaceName != nil {

		// query param workspace.name
		var qrWorkspaceName string

		if o.WorkspaceName != nil {
			qrWorkspaceName = *o.WorkspaceName
		}
		qWorkspaceName := qrWorkspaceName
		if qWorkspaceName != "" {

			if err := r.SetQueryParam("workspace.name", qWorkspaceName); err != nil {
				return err
			}
		}
	}

	// path param workspace.uuid
	if err := r.SetPathParam("workspace.uuid", o.WorkspaceUUID); err != nil {
		return err
	}

	if o.WorkspaceVersionUUID != nil {

		// query param workspace.version.uuid
		var qrWorkspaceVersionUUID string

		if o.WorkspaceVersionUUID != nil {
			qrWorkspaceVersionUUID = *o.WorkspaceVersionUUID
		}
		qWorkspaceVersionUUID := qrWorkspaceVersionUUID
		if qWorkspaceVersionUUID != "" {

			if err := r.SetQueryParam("workspace.version.uuid", qWorkspaceVersionUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamDataEngineEntityCollectionGet binds the parameter fields
func (o *DataEngineEntityCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamDataEngineEntityCollectionGet binds the parameter order_by
func (o *DataEngineEntityCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
