// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DataEngineEntityCollectionGetReader is a Reader for the DataEngineEntityCollectionGet structure.
type DataEngineEntityCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DataEngineEntityCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDataEngineEntityCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDataEngineEntityCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDataEngineEntityCollectionGetOK creates a DataEngineEntityCollectionGetOK with default headers values
func NewDataEngineEntityCollectionGetOK() *DataEngineEntityCollectionGetOK {
	return &DataEngineEntityCollectionGetOK{}
}

/*
DataEngineEntityCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type DataEngineEntityCollectionGetOK struct {
	Payload *models.DataEngineEntityResponse
}

// IsSuccess returns true when this data engine entity collection get o k response has a 2xx status code
func (o *DataEngineEntityCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this data engine entity collection get o k response has a 3xx status code
func (o *DataEngineEntityCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this data engine entity collection get o k response has a 4xx status code
func (o *DataEngineEntityCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this data engine entity collection get o k response has a 5xx status code
func (o *DataEngineEntityCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this data engine entity collection get o k response a status code equal to that given
func (o *DataEngineEntityCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the data engine entity collection get o k response
func (o *DataEngineEntityCollectionGetOK) Code() int {
	return 200
}

func (o *DataEngineEntityCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/entities][%d] dataEngineEntityCollectionGetOK %s", 200, payload)
}

func (o *DataEngineEntityCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/entities][%d] dataEngineEntityCollectionGetOK %s", 200, payload)
}

func (o *DataEngineEntityCollectionGetOK) GetPayload() *models.DataEngineEntityResponse {
	return o.Payload
}

func (o *DataEngineEntityCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DataEngineEntityResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDataEngineEntityCollectionGetDefault creates a DataEngineEntityCollectionGetDefault with default headers values
func NewDataEngineEntityCollectionGetDefault(code int) *DataEngineEntityCollectionGetDefault {
	return &DataEngineEntityCollectionGetDefault{
		_statusCode: code,
	}
}

/*
DataEngineEntityCollectionGetDefault describes a response with status code -1, with default header values.

Error
*/
type DataEngineEntityCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this data engine entity collection get default response has a 2xx status code
func (o *DataEngineEntityCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this data engine entity collection get default response has a 3xx status code
func (o *DataEngineEntityCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this data engine entity collection get default response has a 4xx status code
func (o *DataEngineEntityCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this data engine entity collection get default response has a 5xx status code
func (o *DataEngineEntityCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this data engine entity collection get default response a status code equal to that given
func (o *DataEngineEntityCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the data engine entity collection get default response
func (o *DataEngineEntityCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *DataEngineEntityCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/entities][%d] data_engine_entity_collection_get default %s", o._statusCode, payload)
}

func (o *DataEngineEntityCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/entities][%d] data_engine_entity_collection_get default %s", o._statusCode, payload)
}

func (o *DataEngineEntityCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DataEngineEntityCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
