// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewDataEngineEntityCustomAttributeCollectionGetParams creates a new DataEngineEntityCustomAttributeCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDataEngineEntityCustomAttributeCollectionGetParams() *DataEngineEntityCustomAttributeCollectionGetParams {
	return &DataEngineEntityCustomAttributeCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDataEngineEntityCustomAttributeCollectionGetParamsWithTimeout creates a new DataEngineEntityCustomAttributeCollectionGetParams object
// with the ability to set a timeout on a request.
func NewDataEngineEntityCustomAttributeCollectionGetParamsWithTimeout(timeout time.Duration) *DataEngineEntityCustomAttributeCollectionGetParams {
	return &DataEngineEntityCustomAttributeCollectionGetParams{
		timeout: timeout,
	}
}

// NewDataEngineEntityCustomAttributeCollectionGetParamsWithContext creates a new DataEngineEntityCustomAttributeCollectionGetParams object
// with the ability to set a context for a request.
func NewDataEngineEntityCustomAttributeCollectionGetParamsWithContext(ctx context.Context) *DataEngineEntityCustomAttributeCollectionGetParams {
	return &DataEngineEntityCustomAttributeCollectionGetParams{
		Context: ctx,
	}
}

// NewDataEngineEntityCustomAttributeCollectionGetParamsWithHTTPClient creates a new DataEngineEntityCustomAttributeCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewDataEngineEntityCustomAttributeCollectionGetParamsWithHTTPClient(client *http.Client) *DataEngineEntityCustomAttributeCollectionGetParams {
	return &DataEngineEntityCustomAttributeCollectionGetParams{
		HTTPClient: client,
	}
}

/*
DataEngineEntityCustomAttributeCollectionGetParams contains all the parameters to send to the API endpoint

	for the data engine entity custom attribute collection get operation.

	Typically these are written to a http.Request.
*/
type DataEngineEntityCustomAttributeCollectionGetParams struct {

	/* DataEngineEntityUUID.

	   Unique identifier of the entity.
	*/
	DataEngineEntityUUID string

	/* EntityName.

	   Filter by entity.name
	*/
	EntityName *string

	/* EntityUUID.

	   Filter by entity.uuid
	*/
	EntityUUID *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* Key.

	   Filter by key
	*/
	Key *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Value.

	   Filter by value
	*/
	Value *string

	/* WorkspaceName.

	   Filter by workspace.name
	*/
	WorkspaceName *string

	/* WorkspaceUUID.

	   Unique identifier of the workspace.
	*/
	WorkspaceUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the data engine entity custom attribute collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DataEngineEntityCustomAttributeCollectionGetParams) WithDefaults() *DataEngineEntityCustomAttributeCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the data engine entity custom attribute collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DataEngineEntityCustomAttributeCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := DataEngineEntityCustomAttributeCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the data engine entity custom attribute collection get params
func (o *DataEngineEntityCustomAttributeCollectionGetParams) WithTimeout(timeout time.Duration) *DataEngineEntityCustomAttributeCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the data engine entity custom attribute collection get params
func (o *DataEngineEntityCustomAttributeCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the data engine entity custom attribute collection get params
func (o *DataEngineEntityCustomAttributeCollectionGetParams) WithContext(ctx context.Context) *DataEngineEntityCustomAttributeCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the data engine entity custom attribute collection get params
func (o *DataEngineEntityCustomAttributeCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the data engine entity custom attribute collection get params
func (o *DataEngineEntityCustomAttributeCollectionGetParams) WithHTTPClient(client *http.Client) *DataEngineEntityCustomAttributeCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the data engine entity custom attribute collection get params
func (o *DataEngineEntityCustomAttributeCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithDataEngineEntityUUID adds the dataEngineEntityUUID to the data engine entity custom attribute collection get params
func (o *DataEngineEntityCustomAttributeCollectionGetParams) WithDataEngineEntityUUID(dataEngineEntityUUID string) *DataEngineEntityCustomAttributeCollectionGetParams {
	o.SetDataEngineEntityUUID(dataEngineEntityUUID)
	return o
}

// SetDataEngineEntityUUID adds the dataEngineEntityUuid to the data engine entity custom attribute collection get params
func (o *DataEngineEntityCustomAttributeCollectionGetParams) SetDataEngineEntityUUID(dataEngineEntityUUID string) {
	o.DataEngineEntityUUID = dataEngineEntityUUID
}

// WithEntityName adds the entityName to the data engine entity custom attribute collection get params
func (o *DataEngineEntityCustomAttributeCollectionGetParams) WithEntityName(entityName *string) *DataEngineEntityCustomAttributeCollectionGetParams {
	o.SetEntityName(entityName)
	return o
}

// SetEntityName adds the entityName to the data engine entity custom attribute collection get params
func (o *DataEngineEntityCustomAttributeCollectionGetParams) SetEntityName(entityName *string) {
	o.EntityName = entityName
}

// WithEntityUUID adds the entityUUID to the data engine entity custom attribute collection get params
func (o *DataEngineEntityCustomAttributeCollectionGetParams) WithEntityUUID(entityUUID *string) *DataEngineEntityCustomAttributeCollectionGetParams {
	o.SetEntityUUID(entityUUID)
	return o
}

// SetEntityUUID adds the entityUuid to the data engine entity custom attribute collection get params
func (o *DataEngineEntityCustomAttributeCollectionGetParams) SetEntityUUID(entityUUID *string) {
	o.EntityUUID = entityUUID
}

// WithFields adds the fields to the data engine entity custom attribute collection get params
func (o *DataEngineEntityCustomAttributeCollectionGetParams) WithFields(fields []string) *DataEngineEntityCustomAttributeCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the data engine entity custom attribute collection get params
func (o *DataEngineEntityCustomAttributeCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithKey adds the key to the data engine entity custom attribute collection get params
func (o *DataEngineEntityCustomAttributeCollectionGetParams) WithKey(key *string) *DataEngineEntityCustomAttributeCollectionGetParams {
	o.SetKey(key)
	return o
}

// SetKey adds the key to the data engine entity custom attribute collection get params
func (o *DataEngineEntityCustomAttributeCollectionGetParams) SetKey(key *string) {
	o.Key = key
}

// WithMaxRecords adds the maxRecords to the data engine entity custom attribute collection get params
func (o *DataEngineEntityCustomAttributeCollectionGetParams) WithMaxRecords(maxRecords *int64) *DataEngineEntityCustomAttributeCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the data engine entity custom attribute collection get params
func (o *DataEngineEntityCustomAttributeCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithOrderBy adds the orderBy to the data engine entity custom attribute collection get params
func (o *DataEngineEntityCustomAttributeCollectionGetParams) WithOrderBy(orderBy []string) *DataEngineEntityCustomAttributeCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the data engine entity custom attribute collection get params
func (o *DataEngineEntityCustomAttributeCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the data engine entity custom attribute collection get params
func (o *DataEngineEntityCustomAttributeCollectionGetParams) WithReturnRecords(returnRecords *bool) *DataEngineEntityCustomAttributeCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the data engine entity custom attribute collection get params
func (o *DataEngineEntityCustomAttributeCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the data engine entity custom attribute collection get params
func (o *DataEngineEntityCustomAttributeCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *DataEngineEntityCustomAttributeCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the data engine entity custom attribute collection get params
func (o *DataEngineEntityCustomAttributeCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithValue adds the value to the data engine entity custom attribute collection get params
func (o *DataEngineEntityCustomAttributeCollectionGetParams) WithValue(value *string) *DataEngineEntityCustomAttributeCollectionGetParams {
	o.SetValue(value)
	return o
}

// SetValue adds the value to the data engine entity custom attribute collection get params
func (o *DataEngineEntityCustomAttributeCollectionGetParams) SetValue(value *string) {
	o.Value = value
}

// WithWorkspaceName adds the workspaceName to the data engine entity custom attribute collection get params
func (o *DataEngineEntityCustomAttributeCollectionGetParams) WithWorkspaceName(workspaceName *string) *DataEngineEntityCustomAttributeCollectionGetParams {
	o.SetWorkspaceName(workspaceName)
	return o
}

// SetWorkspaceName adds the workspaceName to the data engine entity custom attribute collection get params
func (o *DataEngineEntityCustomAttributeCollectionGetParams) SetWorkspaceName(workspaceName *string) {
	o.WorkspaceName = workspaceName
}

// WithWorkspaceUUID adds the workspaceUUID to the data engine entity custom attribute collection get params
func (o *DataEngineEntityCustomAttributeCollectionGetParams) WithWorkspaceUUID(workspaceUUID string) *DataEngineEntityCustomAttributeCollectionGetParams {
	o.SetWorkspaceUUID(workspaceUUID)
	return o
}

// SetWorkspaceUUID adds the workspaceUuid to the data engine entity custom attribute collection get params
func (o *DataEngineEntityCustomAttributeCollectionGetParams) SetWorkspaceUUID(workspaceUUID string) {
	o.WorkspaceUUID = workspaceUUID
}

// WriteToRequest writes these params to a swagger request
func (o *DataEngineEntityCustomAttributeCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param data_engine_entity.uuid
	if err := r.SetPathParam("data_engine_entity.uuid", o.DataEngineEntityUUID); err != nil {
		return err
	}

	if o.EntityName != nil {

		// query param entity.name
		var qrEntityName string

		if o.EntityName != nil {
			qrEntityName = *o.EntityName
		}
		qEntityName := qrEntityName
		if qEntityName != "" {

			if err := r.SetQueryParam("entity.name", qEntityName); err != nil {
				return err
			}
		}
	}

	if o.EntityUUID != nil {

		// query param entity.uuid
		var qrEntityUUID string

		if o.EntityUUID != nil {
			qrEntityUUID = *o.EntityUUID
		}
		qEntityUUID := qrEntityUUID
		if qEntityUUID != "" {

			if err := r.SetQueryParam("entity.uuid", qEntityUUID); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.Key != nil {

		// query param key
		var qrKey string

		if o.Key != nil {
			qrKey = *o.Key
		}
		qKey := qrKey
		if qKey != "" {

			if err := r.SetQueryParam("key", qKey); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Value != nil {

		// query param value
		var qrValue string

		if o.Value != nil {
			qrValue = *o.Value
		}
		qValue := qrValue
		if qValue != "" {

			if err := r.SetQueryParam("value", qValue); err != nil {
				return err
			}
		}
	}

	if o.WorkspaceName != nil {

		// query param workspace.name
		var qrWorkspaceName string

		if o.WorkspaceName != nil {
			qrWorkspaceName = *o.WorkspaceName
		}
		qWorkspaceName := qrWorkspaceName
		if qWorkspaceName != "" {

			if err := r.SetQueryParam("workspace.name", qWorkspaceName); err != nil {
				return err
			}
		}
	}

	// path param workspace.uuid
	if err := r.SetPathParam("workspace.uuid", o.WorkspaceUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamDataEngineEntityCustomAttributeCollectionGet binds the parameter fields
func (o *DataEngineEntityCustomAttributeCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamDataEngineEntityCustomAttributeCollectionGet binds the parameter order_by
func (o *DataEngineEntityCustomAttributeCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
