// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DataEngineEntityCustomAttributeCollectionGetReader is a Reader for the DataEngineEntityCustomAttributeCollectionGet structure.
type DataEngineEntityCustomAttributeCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DataEngineEntityCustomAttributeCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDataEngineEntityCustomAttributeCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDataEngineEntityCustomAttributeCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDataEngineEntityCustomAttributeCollectionGetOK creates a DataEngineEntityCustomAttributeCollectionGetOK with default headers values
func NewDataEngineEntityCustomAttributeCollectionGetOK() *DataEngineEntityCustomAttributeCollectionGetOK {
	return &DataEngineEntityCustomAttributeCollectionGetOK{}
}

/*
DataEngineEntityCustomAttributeCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type DataEngineEntityCustomAttributeCollectionGetOK struct {
	Payload *models.DataEngineEntityCustomAttributeResponse
}

// IsSuccess returns true when this data engine entity custom attribute collection get o k response has a 2xx status code
func (o *DataEngineEntityCustomAttributeCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this data engine entity custom attribute collection get o k response has a 3xx status code
func (o *DataEngineEntityCustomAttributeCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this data engine entity custom attribute collection get o k response has a 4xx status code
func (o *DataEngineEntityCustomAttributeCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this data engine entity custom attribute collection get o k response has a 5xx status code
func (o *DataEngineEntityCustomAttributeCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this data engine entity custom attribute collection get o k response a status code equal to that given
func (o *DataEngineEntityCustomAttributeCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the data engine entity custom attribute collection get o k response
func (o *DataEngineEntityCustomAttributeCollectionGetOK) Code() int {
	return 200
}

func (o *DataEngineEntityCustomAttributeCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/entities/{data_engine_entity.uuid}/custom-attributes][%d] dataEngineEntityCustomAttributeCollectionGetOK %s", 200, payload)
}

func (o *DataEngineEntityCustomAttributeCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/entities/{data_engine_entity.uuid}/custom-attributes][%d] dataEngineEntityCustomAttributeCollectionGetOK %s", 200, payload)
}

func (o *DataEngineEntityCustomAttributeCollectionGetOK) GetPayload() *models.DataEngineEntityCustomAttributeResponse {
	return o.Payload
}

func (o *DataEngineEntityCustomAttributeCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DataEngineEntityCustomAttributeResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDataEngineEntityCustomAttributeCollectionGetDefault creates a DataEngineEntityCustomAttributeCollectionGetDefault with default headers values
func NewDataEngineEntityCustomAttributeCollectionGetDefault(code int) *DataEngineEntityCustomAttributeCollectionGetDefault {
	return &DataEngineEntityCustomAttributeCollectionGetDefault{
		_statusCode: code,
	}
}

/*
DataEngineEntityCustomAttributeCollectionGetDefault describes a response with status code -1, with default header values.

Error
*/
type DataEngineEntityCustomAttributeCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this data engine entity custom attribute collection get default response has a 2xx status code
func (o *DataEngineEntityCustomAttributeCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this data engine entity custom attribute collection get default response has a 3xx status code
func (o *DataEngineEntityCustomAttributeCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this data engine entity custom attribute collection get default response has a 4xx status code
func (o *DataEngineEntityCustomAttributeCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this data engine entity custom attribute collection get default response has a 5xx status code
func (o *DataEngineEntityCustomAttributeCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this data engine entity custom attribute collection get default response a status code equal to that given
func (o *DataEngineEntityCustomAttributeCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the data engine entity custom attribute collection get default response
func (o *DataEngineEntityCustomAttributeCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *DataEngineEntityCustomAttributeCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/entities/{data_engine_entity.uuid}/custom-attributes][%d] data_engine_entity_custom_attribute_collection_get default %s", o._statusCode, payload)
}

func (o *DataEngineEntityCustomAttributeCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/entities/{data_engine_entity.uuid}/custom-attributes][%d] data_engine_entity_custom_attribute_collection_get default %s", o._statusCode, payload)
}

func (o *DataEngineEntityCustomAttributeCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DataEngineEntityCustomAttributeCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
