// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewDataEngineEntityCustomAttributeCreateParams creates a new DataEngineEntityCustomAttributeCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDataEngineEntityCustomAttributeCreateParams() *DataEngineEntityCustomAttributeCreateParams {
	return &DataEngineEntityCustomAttributeCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDataEngineEntityCustomAttributeCreateParamsWithTimeout creates a new DataEngineEntityCustomAttributeCreateParams object
// with the ability to set a timeout on a request.
func NewDataEngineEntityCustomAttributeCreateParamsWithTimeout(timeout time.Duration) *DataEngineEntityCustomAttributeCreateParams {
	return &DataEngineEntityCustomAttributeCreateParams{
		timeout: timeout,
	}
}

// NewDataEngineEntityCustomAttributeCreateParamsWithContext creates a new DataEngineEntityCustomAttributeCreateParams object
// with the ability to set a context for a request.
func NewDataEngineEntityCustomAttributeCreateParamsWithContext(ctx context.Context) *DataEngineEntityCustomAttributeCreateParams {
	return &DataEngineEntityCustomAttributeCreateParams{
		Context: ctx,
	}
}

// NewDataEngineEntityCustomAttributeCreateParamsWithHTTPClient creates a new DataEngineEntityCustomAttributeCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewDataEngineEntityCustomAttributeCreateParamsWithHTTPClient(client *http.Client) *DataEngineEntityCustomAttributeCreateParams {
	return &DataEngineEntityCustomAttributeCreateParams{
		HTTPClient: client,
	}
}

/*
DataEngineEntityCustomAttributeCreateParams contains all the parameters to send to the API endpoint

	for the data engine entity custom attribute create operation.

	Typically these are written to a http.Request.
*/
type DataEngineEntityCustomAttributeCreateParams struct {

	/* DataEngineEntityUUID.

	   Unique identifier of the entity.
	*/
	DataEngineEntityUUID string

	/* Info.

	   The custom attribute key and value to add to the entity.
	*/
	Info *models.DataEngineEntityCustomAttribute

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	/* WorkspaceUUID.

	   Unique identifier of the workspace.
	*/
	WorkspaceUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the data engine entity custom attribute create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DataEngineEntityCustomAttributeCreateParams) WithDefaults() *DataEngineEntityCustomAttributeCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the data engine entity custom attribute create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DataEngineEntityCustomAttributeCreateParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)
	)

	val := DataEngineEntityCustomAttributeCreateParams{
		ReturnRecords: &returnRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the data engine entity custom attribute create params
func (o *DataEngineEntityCustomAttributeCreateParams) WithTimeout(timeout time.Duration) *DataEngineEntityCustomAttributeCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the data engine entity custom attribute create params
func (o *DataEngineEntityCustomAttributeCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the data engine entity custom attribute create params
func (o *DataEngineEntityCustomAttributeCreateParams) WithContext(ctx context.Context) *DataEngineEntityCustomAttributeCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the data engine entity custom attribute create params
func (o *DataEngineEntityCustomAttributeCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the data engine entity custom attribute create params
func (o *DataEngineEntityCustomAttributeCreateParams) WithHTTPClient(client *http.Client) *DataEngineEntityCustomAttributeCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the data engine entity custom attribute create params
func (o *DataEngineEntityCustomAttributeCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithDataEngineEntityUUID adds the dataEngineEntityUUID to the data engine entity custom attribute create params
func (o *DataEngineEntityCustomAttributeCreateParams) WithDataEngineEntityUUID(dataEngineEntityUUID string) *DataEngineEntityCustomAttributeCreateParams {
	o.SetDataEngineEntityUUID(dataEngineEntityUUID)
	return o
}

// SetDataEngineEntityUUID adds the dataEngineEntityUuid to the data engine entity custom attribute create params
func (o *DataEngineEntityCustomAttributeCreateParams) SetDataEngineEntityUUID(dataEngineEntityUUID string) {
	o.DataEngineEntityUUID = dataEngineEntityUUID
}

// WithInfo adds the info to the data engine entity custom attribute create params
func (o *DataEngineEntityCustomAttributeCreateParams) WithInfo(info *models.DataEngineEntityCustomAttribute) *DataEngineEntityCustomAttributeCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the data engine entity custom attribute create params
func (o *DataEngineEntityCustomAttributeCreateParams) SetInfo(info *models.DataEngineEntityCustomAttribute) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the data engine entity custom attribute create params
func (o *DataEngineEntityCustomAttributeCreateParams) WithReturnRecords(returnRecords *bool) *DataEngineEntityCustomAttributeCreateParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the data engine entity custom attribute create params
func (o *DataEngineEntityCustomAttributeCreateParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithWorkspaceUUID adds the workspaceUUID to the data engine entity custom attribute create params
func (o *DataEngineEntityCustomAttributeCreateParams) WithWorkspaceUUID(workspaceUUID string) *DataEngineEntityCustomAttributeCreateParams {
	o.SetWorkspaceUUID(workspaceUUID)
	return o
}

// SetWorkspaceUUID adds the workspaceUuid to the data engine entity custom attribute create params
func (o *DataEngineEntityCustomAttributeCreateParams) SetWorkspaceUUID(workspaceUUID string) {
	o.WorkspaceUUID = workspaceUUID
}

// WriteToRequest writes these params to a swagger request
func (o *DataEngineEntityCustomAttributeCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param data_engine_entity.uuid
	if err := r.SetPathParam("data_engine_entity.uuid", o.DataEngineEntityUUID); err != nil {
		return err
	}
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	// path param workspace.uuid
	if err := r.SetPathParam("workspace.uuid", o.WorkspaceUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
