// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DataEngineEntityCustomAttributeCreateReader is a Reader for the DataEngineEntityCustomAttributeCreate structure.
type DataEngineEntityCustomAttributeCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DataEngineEntityCustomAttributeCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewDataEngineEntityCustomAttributeCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDataEngineEntityCustomAttributeCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDataEngineEntityCustomAttributeCreateCreated creates a DataEngineEntityCustomAttributeCreateCreated with default headers values
func NewDataEngineEntityCustomAttributeCreateCreated() *DataEngineEntityCustomAttributeCreateCreated {
	return &DataEngineEntityCustomAttributeCreateCreated{}
}

/*
DataEngineEntityCustomAttributeCreateCreated describes a response with status code 201, with default header values.

Created
*/
type DataEngineEntityCustomAttributeCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.DataEngineEntityCustomAttributeResponse
}

// IsSuccess returns true when this data engine entity custom attribute create created response has a 2xx status code
func (o *DataEngineEntityCustomAttributeCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this data engine entity custom attribute create created response has a 3xx status code
func (o *DataEngineEntityCustomAttributeCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this data engine entity custom attribute create created response has a 4xx status code
func (o *DataEngineEntityCustomAttributeCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this data engine entity custom attribute create created response has a 5xx status code
func (o *DataEngineEntityCustomAttributeCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this data engine entity custom attribute create created response a status code equal to that given
func (o *DataEngineEntityCustomAttributeCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the data engine entity custom attribute create created response
func (o *DataEngineEntityCustomAttributeCreateCreated) Code() int {
	return 201
}

func (o *DataEngineEntityCustomAttributeCreateCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/workspaces/{workspace.uuid}/entities/{data_engine_entity.uuid}/custom-attributes][%d] dataEngineEntityCustomAttributeCreateCreated %s", 201, payload)
}

func (o *DataEngineEntityCustomAttributeCreateCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/workspaces/{workspace.uuid}/entities/{data_engine_entity.uuid}/custom-attributes][%d] dataEngineEntityCustomAttributeCreateCreated %s", 201, payload)
}

func (o *DataEngineEntityCustomAttributeCreateCreated) GetPayload() *models.DataEngineEntityCustomAttributeResponse {
	return o.Payload
}

func (o *DataEngineEntityCustomAttributeCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.DataEngineEntityCustomAttributeResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDataEngineEntityCustomAttributeCreateDefault creates a DataEngineEntityCustomAttributeCreateDefault with default headers values
func NewDataEngineEntityCustomAttributeCreateDefault(code int) *DataEngineEntityCustomAttributeCreateDefault {
	return &DataEngineEntityCustomAttributeCreateDefault{
		_statusCode: code,
	}
}

/*
DataEngineEntityCustomAttributeCreateDefault describes a response with status code -1, with default header values.

Error
*/
type DataEngineEntityCustomAttributeCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this data engine entity custom attribute create default response has a 2xx status code
func (o *DataEngineEntityCustomAttributeCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this data engine entity custom attribute create default response has a 3xx status code
func (o *DataEngineEntityCustomAttributeCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this data engine entity custom attribute create default response has a 4xx status code
func (o *DataEngineEntityCustomAttributeCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this data engine entity custom attribute create default response has a 5xx status code
func (o *DataEngineEntityCustomAttributeCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this data engine entity custom attribute create default response a status code equal to that given
func (o *DataEngineEntityCustomAttributeCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the data engine entity custom attribute create default response
func (o *DataEngineEntityCustomAttributeCreateDefault) Code() int {
	return o._statusCode
}

func (o *DataEngineEntityCustomAttributeCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/workspaces/{workspace.uuid}/entities/{data_engine_entity.uuid}/custom-attributes][%d] data_engine_entity_custom_attribute_create default %s", o._statusCode, payload)
}

func (o *DataEngineEntityCustomAttributeCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/workspaces/{workspace.uuid}/entities/{data_engine_entity.uuid}/custom-attributes][%d] data_engine_entity_custom_attribute_create default %s", o._statusCode, payload)
}

func (o *DataEngineEntityCustomAttributeCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DataEngineEntityCustomAttributeCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
