// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewDataEngineEntityCustomAttributeDeleteCollectionParams creates a new DataEngineEntityCustomAttributeDeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDataEngineEntityCustomAttributeDeleteCollectionParams() *DataEngineEntityCustomAttributeDeleteCollectionParams {
	return &DataEngineEntityCustomAttributeDeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDataEngineEntityCustomAttributeDeleteCollectionParamsWithTimeout creates a new DataEngineEntityCustomAttributeDeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewDataEngineEntityCustomAttributeDeleteCollectionParamsWithTimeout(timeout time.Duration) *DataEngineEntityCustomAttributeDeleteCollectionParams {
	return &DataEngineEntityCustomAttributeDeleteCollectionParams{
		timeout: timeout,
	}
}

// NewDataEngineEntityCustomAttributeDeleteCollectionParamsWithContext creates a new DataEngineEntityCustomAttributeDeleteCollectionParams object
// with the ability to set a context for a request.
func NewDataEngineEntityCustomAttributeDeleteCollectionParamsWithContext(ctx context.Context) *DataEngineEntityCustomAttributeDeleteCollectionParams {
	return &DataEngineEntityCustomAttributeDeleteCollectionParams{
		Context: ctx,
	}
}

// NewDataEngineEntityCustomAttributeDeleteCollectionParamsWithHTTPClient creates a new DataEngineEntityCustomAttributeDeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewDataEngineEntityCustomAttributeDeleteCollectionParamsWithHTTPClient(client *http.Client) *DataEngineEntityCustomAttributeDeleteCollectionParams {
	return &DataEngineEntityCustomAttributeDeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
DataEngineEntityCustomAttributeDeleteCollectionParams contains all the parameters to send to the API endpoint

	for the data engine entity custom attribute delete collection operation.

	Typically these are written to a http.Request.
*/
type DataEngineEntityCustomAttributeDeleteCollectionParams struct {

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* DataEngineEntityUUID.

	   Unique identifier of the entity.
	*/
	DataEngineEntityUUID string

	/* EntityName.

	   Filter by entity.name
	*/
	EntityName *string

	/* EntityUUID.

	   Filter by entity.uuid
	*/
	EntityUUID *string

	/* Info.

	   Info specification
	*/
	Info DataEngineEntityCustomAttributeDeleteCollectionBody

	/* Key.

	   Filter by key
	*/
	Key *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* Value.

	   Filter by value
	*/
	Value *string

	/* WorkspaceName.

	   Filter by workspace.name
	*/
	WorkspaceName *string

	/* WorkspaceUUID.

	   Unique identifier of the workspace.
	*/
	WorkspaceUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the data engine entity custom attribute delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DataEngineEntityCustomAttributeDeleteCollectionParams) WithDefaults() *DataEngineEntityCustomAttributeDeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the data engine entity custom attribute delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DataEngineEntityCustomAttributeDeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := DataEngineEntityCustomAttributeDeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the data engine entity custom attribute delete collection params
func (o *DataEngineEntityCustomAttributeDeleteCollectionParams) WithTimeout(timeout time.Duration) *DataEngineEntityCustomAttributeDeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the data engine entity custom attribute delete collection params
func (o *DataEngineEntityCustomAttributeDeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the data engine entity custom attribute delete collection params
func (o *DataEngineEntityCustomAttributeDeleteCollectionParams) WithContext(ctx context.Context) *DataEngineEntityCustomAttributeDeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the data engine entity custom attribute delete collection params
func (o *DataEngineEntityCustomAttributeDeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the data engine entity custom attribute delete collection params
func (o *DataEngineEntityCustomAttributeDeleteCollectionParams) WithHTTPClient(client *http.Client) *DataEngineEntityCustomAttributeDeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the data engine entity custom attribute delete collection params
func (o *DataEngineEntityCustomAttributeDeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithContinueOnFailure adds the continueOnFailure to the data engine entity custom attribute delete collection params
func (o *DataEngineEntityCustomAttributeDeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *DataEngineEntityCustomAttributeDeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the data engine entity custom attribute delete collection params
func (o *DataEngineEntityCustomAttributeDeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithDataEngineEntityUUID adds the dataEngineEntityUUID to the data engine entity custom attribute delete collection params
func (o *DataEngineEntityCustomAttributeDeleteCollectionParams) WithDataEngineEntityUUID(dataEngineEntityUUID string) *DataEngineEntityCustomAttributeDeleteCollectionParams {
	o.SetDataEngineEntityUUID(dataEngineEntityUUID)
	return o
}

// SetDataEngineEntityUUID adds the dataEngineEntityUuid to the data engine entity custom attribute delete collection params
func (o *DataEngineEntityCustomAttributeDeleteCollectionParams) SetDataEngineEntityUUID(dataEngineEntityUUID string) {
	o.DataEngineEntityUUID = dataEngineEntityUUID
}

// WithEntityName adds the entityName to the data engine entity custom attribute delete collection params
func (o *DataEngineEntityCustomAttributeDeleteCollectionParams) WithEntityName(entityName *string) *DataEngineEntityCustomAttributeDeleteCollectionParams {
	o.SetEntityName(entityName)
	return o
}

// SetEntityName adds the entityName to the data engine entity custom attribute delete collection params
func (o *DataEngineEntityCustomAttributeDeleteCollectionParams) SetEntityName(entityName *string) {
	o.EntityName = entityName
}

// WithEntityUUID adds the entityUUID to the data engine entity custom attribute delete collection params
func (o *DataEngineEntityCustomAttributeDeleteCollectionParams) WithEntityUUID(entityUUID *string) *DataEngineEntityCustomAttributeDeleteCollectionParams {
	o.SetEntityUUID(entityUUID)
	return o
}

// SetEntityUUID adds the entityUuid to the data engine entity custom attribute delete collection params
func (o *DataEngineEntityCustomAttributeDeleteCollectionParams) SetEntityUUID(entityUUID *string) {
	o.EntityUUID = entityUUID
}

// WithInfo adds the info to the data engine entity custom attribute delete collection params
func (o *DataEngineEntityCustomAttributeDeleteCollectionParams) WithInfo(info DataEngineEntityCustomAttributeDeleteCollectionBody) *DataEngineEntityCustomAttributeDeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the data engine entity custom attribute delete collection params
func (o *DataEngineEntityCustomAttributeDeleteCollectionParams) SetInfo(info DataEngineEntityCustomAttributeDeleteCollectionBody) {
	o.Info = info
}

// WithKey adds the key to the data engine entity custom attribute delete collection params
func (o *DataEngineEntityCustomAttributeDeleteCollectionParams) WithKey(key *string) *DataEngineEntityCustomAttributeDeleteCollectionParams {
	o.SetKey(key)
	return o
}

// SetKey adds the key to the data engine entity custom attribute delete collection params
func (o *DataEngineEntityCustomAttributeDeleteCollectionParams) SetKey(key *string) {
	o.Key = key
}

// WithReturnRecords adds the returnRecords to the data engine entity custom attribute delete collection params
func (o *DataEngineEntityCustomAttributeDeleteCollectionParams) WithReturnRecords(returnRecords *bool) *DataEngineEntityCustomAttributeDeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the data engine entity custom attribute delete collection params
func (o *DataEngineEntityCustomAttributeDeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the data engine entity custom attribute delete collection params
func (o *DataEngineEntityCustomAttributeDeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *DataEngineEntityCustomAttributeDeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the data engine entity custom attribute delete collection params
func (o *DataEngineEntityCustomAttributeDeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the data engine entity custom attribute delete collection params
func (o *DataEngineEntityCustomAttributeDeleteCollectionParams) WithSerialRecords(serialRecords *bool) *DataEngineEntityCustomAttributeDeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the data engine entity custom attribute delete collection params
func (o *DataEngineEntityCustomAttributeDeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithValue adds the value to the data engine entity custom attribute delete collection params
func (o *DataEngineEntityCustomAttributeDeleteCollectionParams) WithValue(value *string) *DataEngineEntityCustomAttributeDeleteCollectionParams {
	o.SetValue(value)
	return o
}

// SetValue adds the value to the data engine entity custom attribute delete collection params
func (o *DataEngineEntityCustomAttributeDeleteCollectionParams) SetValue(value *string) {
	o.Value = value
}

// WithWorkspaceName adds the workspaceName to the data engine entity custom attribute delete collection params
func (o *DataEngineEntityCustomAttributeDeleteCollectionParams) WithWorkspaceName(workspaceName *string) *DataEngineEntityCustomAttributeDeleteCollectionParams {
	o.SetWorkspaceName(workspaceName)
	return o
}

// SetWorkspaceName adds the workspaceName to the data engine entity custom attribute delete collection params
func (o *DataEngineEntityCustomAttributeDeleteCollectionParams) SetWorkspaceName(workspaceName *string) {
	o.WorkspaceName = workspaceName
}

// WithWorkspaceUUID adds the workspaceUUID to the data engine entity custom attribute delete collection params
func (o *DataEngineEntityCustomAttributeDeleteCollectionParams) WithWorkspaceUUID(workspaceUUID string) *DataEngineEntityCustomAttributeDeleteCollectionParams {
	o.SetWorkspaceUUID(workspaceUUID)
	return o
}

// SetWorkspaceUUID adds the workspaceUuid to the data engine entity custom attribute delete collection params
func (o *DataEngineEntityCustomAttributeDeleteCollectionParams) SetWorkspaceUUID(workspaceUUID string) {
	o.WorkspaceUUID = workspaceUUID
}

// WriteToRequest writes these params to a swagger request
func (o *DataEngineEntityCustomAttributeDeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	// path param data_engine_entity.uuid
	if err := r.SetPathParam("data_engine_entity.uuid", o.DataEngineEntityUUID); err != nil {
		return err
	}

	if o.EntityName != nil {

		// query param entity.name
		var qrEntityName string

		if o.EntityName != nil {
			qrEntityName = *o.EntityName
		}
		qEntityName := qrEntityName
		if qEntityName != "" {

			if err := r.SetQueryParam("entity.name", qEntityName); err != nil {
				return err
			}
		}
	}

	if o.EntityUUID != nil {

		// query param entity.uuid
		var qrEntityUUID string

		if o.EntityUUID != nil {
			qrEntityUUID = *o.EntityUUID
		}
		qEntityUUID := qrEntityUUID
		if qEntityUUID != "" {

			if err := r.SetQueryParam("entity.uuid", qEntityUUID); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.Key != nil {

		// query param key
		var qrKey string

		if o.Key != nil {
			qrKey = *o.Key
		}
		qKey := qrKey
		if qKey != "" {

			if err := r.SetQueryParam("key", qKey); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.Value != nil {

		// query param value
		var qrValue string

		if o.Value != nil {
			qrValue = *o.Value
		}
		qValue := qrValue
		if qValue != "" {

			if err := r.SetQueryParam("value", qValue); err != nil {
				return err
			}
		}
	}

	if o.WorkspaceName != nil {

		// query param workspace.name
		var qrWorkspaceName string

		if o.WorkspaceName != nil {
			qrWorkspaceName = *o.WorkspaceName
		}
		qWorkspaceName := qrWorkspaceName
		if qWorkspaceName != "" {

			if err := r.SetQueryParam("workspace.name", qWorkspaceName); err != nil {
				return err
			}
		}
	}

	// path param workspace.uuid
	if err := r.SetPathParam("workspace.uuid", o.WorkspaceUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
