// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DataEngineEntityCustomAttributeDeleteCollectionReader is a Reader for the DataEngineEntityCustomAttributeDeleteCollection structure.
type DataEngineEntityCustomAttributeDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DataEngineEntityCustomAttributeDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDataEngineEntityCustomAttributeDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDataEngineEntityCustomAttributeDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDataEngineEntityCustomAttributeDeleteCollectionOK creates a DataEngineEntityCustomAttributeDeleteCollectionOK with default headers values
func NewDataEngineEntityCustomAttributeDeleteCollectionOK() *DataEngineEntityCustomAttributeDeleteCollectionOK {
	return &DataEngineEntityCustomAttributeDeleteCollectionOK{}
}

/*
DataEngineEntityCustomAttributeDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type DataEngineEntityCustomAttributeDeleteCollectionOK struct {
}

// IsSuccess returns true when this data engine entity custom attribute delete collection o k response has a 2xx status code
func (o *DataEngineEntityCustomAttributeDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this data engine entity custom attribute delete collection o k response has a 3xx status code
func (o *DataEngineEntityCustomAttributeDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this data engine entity custom attribute delete collection o k response has a 4xx status code
func (o *DataEngineEntityCustomAttributeDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this data engine entity custom attribute delete collection o k response has a 5xx status code
func (o *DataEngineEntityCustomAttributeDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this data engine entity custom attribute delete collection o k response a status code equal to that given
func (o *DataEngineEntityCustomAttributeDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the data engine entity custom attribute delete collection o k response
func (o *DataEngineEntityCustomAttributeDeleteCollectionOK) Code() int {
	return 200
}

func (o *DataEngineEntityCustomAttributeDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/entities/{data_engine_entity.uuid}/custom-attributes][%d] dataEngineEntityCustomAttributeDeleteCollectionOK", 200)
}

func (o *DataEngineEntityCustomAttributeDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/entities/{data_engine_entity.uuid}/custom-attributes][%d] dataEngineEntityCustomAttributeDeleteCollectionOK", 200)
}

func (o *DataEngineEntityCustomAttributeDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewDataEngineEntityCustomAttributeDeleteCollectionDefault creates a DataEngineEntityCustomAttributeDeleteCollectionDefault with default headers values
func NewDataEngineEntityCustomAttributeDeleteCollectionDefault(code int) *DataEngineEntityCustomAttributeDeleteCollectionDefault {
	return &DataEngineEntityCustomAttributeDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
DataEngineEntityCustomAttributeDeleteCollectionDefault describes a response with status code -1, with default header values.

Error
*/
type DataEngineEntityCustomAttributeDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this data engine entity custom attribute delete collection default response has a 2xx status code
func (o *DataEngineEntityCustomAttributeDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this data engine entity custom attribute delete collection default response has a 3xx status code
func (o *DataEngineEntityCustomAttributeDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this data engine entity custom attribute delete collection default response has a 4xx status code
func (o *DataEngineEntityCustomAttributeDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this data engine entity custom attribute delete collection default response has a 5xx status code
func (o *DataEngineEntityCustomAttributeDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this data engine entity custom attribute delete collection default response a status code equal to that given
func (o *DataEngineEntityCustomAttributeDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the data engine entity custom attribute delete collection default response
func (o *DataEngineEntityCustomAttributeDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *DataEngineEntityCustomAttributeDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/entities/{data_engine_entity.uuid}/custom-attributes][%d] data_engine_entity_custom_attribute_delete_collection default %s", o._statusCode, payload)
}

func (o *DataEngineEntityCustomAttributeDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/entities/{data_engine_entity.uuid}/custom-attributes][%d] data_engine_entity_custom_attribute_delete_collection default %s", o._statusCode, payload)
}

func (o *DataEngineEntityCustomAttributeDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DataEngineEntityCustomAttributeDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
DataEngineEntityCustomAttributeDeleteCollectionBody Response for custom attributes of the entity.
swagger:model DataEngineEntityCustomAttributeDeleteCollectionBody
*/
type DataEngineEntityCustomAttributeDeleteCollectionBody struct {

	// data engine entity custom attribute response inline records
	// Read Only: true
	DataEngineEntityCustomAttributeResponseInlineRecords []*models.DataEngineEntityCustomAttribute `json:"records,omitempty"`

	// The total number of custom attributes present in a workspace.
	// Example: 100
	// Read Only: true
	TotalRecords *int64 `json:"total_records,omitempty"`
}

// Validate validates this data engine entity custom attribute delete collection body
func (o *DataEngineEntityCustomAttributeDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateDataEngineEntityCustomAttributeResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DataEngineEntityCustomAttributeDeleteCollectionBody) validateDataEngineEntityCustomAttributeResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.DataEngineEntityCustomAttributeResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.DataEngineEntityCustomAttributeResponseInlineRecords); i++ {
		if swag.IsZero(o.DataEngineEntityCustomAttributeResponseInlineRecords[i]) { // not required
			continue
		}

		if o.DataEngineEntityCustomAttributeResponseInlineRecords[i] != nil {
			if err := o.DataEngineEntityCustomAttributeResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this data engine entity custom attribute delete collection body based on the context it is used
func (o *DataEngineEntityCustomAttributeDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateDataEngineEntityCustomAttributeResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTotalRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DataEngineEntityCustomAttributeDeleteCollectionBody) contextValidateDataEngineEntityCustomAttributeResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"records", "body", []*models.DataEngineEntityCustomAttribute(o.DataEngineEntityCustomAttributeResponseInlineRecords)); err != nil {
		return err
	}

	for i := 0; i < len(o.DataEngineEntityCustomAttributeResponseInlineRecords); i++ {

		if o.DataEngineEntityCustomAttributeResponseInlineRecords[i] != nil {
			if err := o.DataEngineEntityCustomAttributeResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *DataEngineEntityCustomAttributeDeleteCollectionBody) contextValidateTotalRecords(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"total_records", "body", o.TotalRecords); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *DataEngineEntityCustomAttributeDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *DataEngineEntityCustomAttributeDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res DataEngineEntityCustomAttributeDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
