// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DataEngineEntityCustomAttributeDeleteReader is a Reader for the DataEngineEntityCustomAttributeDelete structure.
type DataEngineEntityCustomAttributeDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DataEngineEntityCustomAttributeDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDataEngineEntityCustomAttributeDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDataEngineEntityCustomAttributeDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDataEngineEntityCustomAttributeDeleteOK creates a DataEngineEntityCustomAttributeDeleteOK with default headers values
func NewDataEngineEntityCustomAttributeDeleteOK() *DataEngineEntityCustomAttributeDeleteOK {
	return &DataEngineEntityCustomAttributeDeleteOK{}
}

/*
DataEngineEntityCustomAttributeDeleteOK describes a response with status code 200, with default header values.

OK
*/
type DataEngineEntityCustomAttributeDeleteOK struct {
}

// IsSuccess returns true when this data engine entity custom attribute delete o k response has a 2xx status code
func (o *DataEngineEntityCustomAttributeDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this data engine entity custom attribute delete o k response has a 3xx status code
func (o *DataEngineEntityCustomAttributeDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this data engine entity custom attribute delete o k response has a 4xx status code
func (o *DataEngineEntityCustomAttributeDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this data engine entity custom attribute delete o k response has a 5xx status code
func (o *DataEngineEntityCustomAttributeDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this data engine entity custom attribute delete o k response a status code equal to that given
func (o *DataEngineEntityCustomAttributeDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the data engine entity custom attribute delete o k response
func (o *DataEngineEntityCustomAttributeDeleteOK) Code() int {
	return 200
}

func (o *DataEngineEntityCustomAttributeDeleteOK) Error() string {
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/entities/{data_engine_entity.uuid}/custom-attributes/{key}][%d] dataEngineEntityCustomAttributeDeleteOK", 200)
}

func (o *DataEngineEntityCustomAttributeDeleteOK) String() string {
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/entities/{data_engine_entity.uuid}/custom-attributes/{key}][%d] dataEngineEntityCustomAttributeDeleteOK", 200)
}

func (o *DataEngineEntityCustomAttributeDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewDataEngineEntityCustomAttributeDeleteDefault creates a DataEngineEntityCustomAttributeDeleteDefault with default headers values
func NewDataEngineEntityCustomAttributeDeleteDefault(code int) *DataEngineEntityCustomAttributeDeleteDefault {
	return &DataEngineEntityCustomAttributeDeleteDefault{
		_statusCode: code,
	}
}

/*
DataEngineEntityCustomAttributeDeleteDefault describes a response with status code -1, with default header values.

Error
*/
type DataEngineEntityCustomAttributeDeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this data engine entity custom attribute delete default response has a 2xx status code
func (o *DataEngineEntityCustomAttributeDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this data engine entity custom attribute delete default response has a 3xx status code
func (o *DataEngineEntityCustomAttributeDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this data engine entity custom attribute delete default response has a 4xx status code
func (o *DataEngineEntityCustomAttributeDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this data engine entity custom attribute delete default response has a 5xx status code
func (o *DataEngineEntityCustomAttributeDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this data engine entity custom attribute delete default response a status code equal to that given
func (o *DataEngineEntityCustomAttributeDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the data engine entity custom attribute delete default response
func (o *DataEngineEntityCustomAttributeDeleteDefault) Code() int {
	return o._statusCode
}

func (o *DataEngineEntityCustomAttributeDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/entities/{data_engine_entity.uuid}/custom-attributes/{key}][%d] data_engine_entity_custom_attribute_delete default %s", o._statusCode, payload)
}

func (o *DataEngineEntityCustomAttributeDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/entities/{data_engine_entity.uuid}/custom-attributes/{key}][%d] data_engine_entity_custom_attribute_delete default %s", o._statusCode, payload)
}

func (o *DataEngineEntityCustomAttributeDeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DataEngineEntityCustomAttributeDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
