// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewDataEngineEntityCustomAttributeGetParams creates a new DataEngineEntityCustomAttributeGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDataEngineEntityCustomAttributeGetParams() *DataEngineEntityCustomAttributeGetParams {
	return &DataEngineEntityCustomAttributeGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDataEngineEntityCustomAttributeGetParamsWithTimeout creates a new DataEngineEntityCustomAttributeGetParams object
// with the ability to set a timeout on a request.
func NewDataEngineEntityCustomAttributeGetParamsWithTimeout(timeout time.Duration) *DataEngineEntityCustomAttributeGetParams {
	return &DataEngineEntityCustomAttributeGetParams{
		timeout: timeout,
	}
}

// NewDataEngineEntityCustomAttributeGetParamsWithContext creates a new DataEngineEntityCustomAttributeGetParams object
// with the ability to set a context for a request.
func NewDataEngineEntityCustomAttributeGetParamsWithContext(ctx context.Context) *DataEngineEntityCustomAttributeGetParams {
	return &DataEngineEntityCustomAttributeGetParams{
		Context: ctx,
	}
}

// NewDataEngineEntityCustomAttributeGetParamsWithHTTPClient creates a new DataEngineEntityCustomAttributeGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewDataEngineEntityCustomAttributeGetParamsWithHTTPClient(client *http.Client) *DataEngineEntityCustomAttributeGetParams {
	return &DataEngineEntityCustomAttributeGetParams{
		HTTPClient: client,
	}
}

/*
DataEngineEntityCustomAttributeGetParams contains all the parameters to send to the API endpoint

	for the data engine entity custom attribute get operation.

	Typically these are written to a http.Request.
*/
type DataEngineEntityCustomAttributeGetParams struct {

	/* DataEngineEntityUUID.

	   Unique identifier of the entity.
	*/
	DataEngineEntityUUID string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* Key.

	   The key of the custom attribute to retrieve.
	*/
	Key string

	/* WorkspaceUUID.

	   Unique identifier of the workspace.
	*/
	WorkspaceUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the data engine entity custom attribute get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DataEngineEntityCustomAttributeGetParams) WithDefaults() *DataEngineEntityCustomAttributeGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the data engine entity custom attribute get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DataEngineEntityCustomAttributeGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the data engine entity custom attribute get params
func (o *DataEngineEntityCustomAttributeGetParams) WithTimeout(timeout time.Duration) *DataEngineEntityCustomAttributeGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the data engine entity custom attribute get params
func (o *DataEngineEntityCustomAttributeGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the data engine entity custom attribute get params
func (o *DataEngineEntityCustomAttributeGetParams) WithContext(ctx context.Context) *DataEngineEntityCustomAttributeGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the data engine entity custom attribute get params
func (o *DataEngineEntityCustomAttributeGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the data engine entity custom attribute get params
func (o *DataEngineEntityCustomAttributeGetParams) WithHTTPClient(client *http.Client) *DataEngineEntityCustomAttributeGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the data engine entity custom attribute get params
func (o *DataEngineEntityCustomAttributeGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithDataEngineEntityUUID adds the dataEngineEntityUUID to the data engine entity custom attribute get params
func (o *DataEngineEntityCustomAttributeGetParams) WithDataEngineEntityUUID(dataEngineEntityUUID string) *DataEngineEntityCustomAttributeGetParams {
	o.SetDataEngineEntityUUID(dataEngineEntityUUID)
	return o
}

// SetDataEngineEntityUUID adds the dataEngineEntityUuid to the data engine entity custom attribute get params
func (o *DataEngineEntityCustomAttributeGetParams) SetDataEngineEntityUUID(dataEngineEntityUUID string) {
	o.DataEngineEntityUUID = dataEngineEntityUUID
}

// WithFields adds the fields to the data engine entity custom attribute get params
func (o *DataEngineEntityCustomAttributeGetParams) WithFields(fields []string) *DataEngineEntityCustomAttributeGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the data engine entity custom attribute get params
func (o *DataEngineEntityCustomAttributeGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithKey adds the key to the data engine entity custom attribute get params
func (o *DataEngineEntityCustomAttributeGetParams) WithKey(key string) *DataEngineEntityCustomAttributeGetParams {
	o.SetKey(key)
	return o
}

// SetKey adds the key to the data engine entity custom attribute get params
func (o *DataEngineEntityCustomAttributeGetParams) SetKey(key string) {
	o.Key = key
}

// WithWorkspaceUUID adds the workspaceUUID to the data engine entity custom attribute get params
func (o *DataEngineEntityCustomAttributeGetParams) WithWorkspaceUUID(workspaceUUID string) *DataEngineEntityCustomAttributeGetParams {
	o.SetWorkspaceUUID(workspaceUUID)
	return o
}

// SetWorkspaceUUID adds the workspaceUuid to the data engine entity custom attribute get params
func (o *DataEngineEntityCustomAttributeGetParams) SetWorkspaceUUID(workspaceUUID string) {
	o.WorkspaceUUID = workspaceUUID
}

// WriteToRequest writes these params to a swagger request
func (o *DataEngineEntityCustomAttributeGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param data_engine_entity.uuid
	if err := r.SetPathParam("data_engine_entity.uuid", o.DataEngineEntityUUID); err != nil {
		return err
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param key
	if err := r.SetPathParam("key", o.Key); err != nil {
		return err
	}

	// path param workspace.uuid
	if err := r.SetPathParam("workspace.uuid", o.WorkspaceUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamDataEngineEntityCustomAttributeGet binds the parameter fields
func (o *DataEngineEntityCustomAttributeGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
