// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DataEngineEntityCustomAttributeGetReader is a Reader for the DataEngineEntityCustomAttributeGet structure.
type DataEngineEntityCustomAttributeGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DataEngineEntityCustomAttributeGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDataEngineEntityCustomAttributeGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDataEngineEntityCustomAttributeGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDataEngineEntityCustomAttributeGetOK creates a DataEngineEntityCustomAttributeGetOK with default headers values
func NewDataEngineEntityCustomAttributeGetOK() *DataEngineEntityCustomAttributeGetOK {
	return &DataEngineEntityCustomAttributeGetOK{}
}

/*
DataEngineEntityCustomAttributeGetOK describes a response with status code 200, with default header values.

OK
*/
type DataEngineEntityCustomAttributeGetOK struct {
	Payload *models.DataEngineEntityCustomAttribute
}

// IsSuccess returns true when this data engine entity custom attribute get o k response has a 2xx status code
func (o *DataEngineEntityCustomAttributeGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this data engine entity custom attribute get o k response has a 3xx status code
func (o *DataEngineEntityCustomAttributeGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this data engine entity custom attribute get o k response has a 4xx status code
func (o *DataEngineEntityCustomAttributeGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this data engine entity custom attribute get o k response has a 5xx status code
func (o *DataEngineEntityCustomAttributeGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this data engine entity custom attribute get o k response a status code equal to that given
func (o *DataEngineEntityCustomAttributeGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the data engine entity custom attribute get o k response
func (o *DataEngineEntityCustomAttributeGetOK) Code() int {
	return 200
}

func (o *DataEngineEntityCustomAttributeGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/entities/{data_engine_entity.uuid}/custom-attributes/{key}][%d] dataEngineEntityCustomAttributeGetOK %s", 200, payload)
}

func (o *DataEngineEntityCustomAttributeGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/entities/{data_engine_entity.uuid}/custom-attributes/{key}][%d] dataEngineEntityCustomAttributeGetOK %s", 200, payload)
}

func (o *DataEngineEntityCustomAttributeGetOK) GetPayload() *models.DataEngineEntityCustomAttribute {
	return o.Payload
}

func (o *DataEngineEntityCustomAttributeGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DataEngineEntityCustomAttribute)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDataEngineEntityCustomAttributeGetDefault creates a DataEngineEntityCustomAttributeGetDefault with default headers values
func NewDataEngineEntityCustomAttributeGetDefault(code int) *DataEngineEntityCustomAttributeGetDefault {
	return &DataEngineEntityCustomAttributeGetDefault{
		_statusCode: code,
	}
}

/*
DataEngineEntityCustomAttributeGetDefault describes a response with status code -1, with default header values.

Error
*/
type DataEngineEntityCustomAttributeGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this data engine entity custom attribute get default response has a 2xx status code
func (o *DataEngineEntityCustomAttributeGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this data engine entity custom attribute get default response has a 3xx status code
func (o *DataEngineEntityCustomAttributeGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this data engine entity custom attribute get default response has a 4xx status code
func (o *DataEngineEntityCustomAttributeGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this data engine entity custom attribute get default response has a 5xx status code
func (o *DataEngineEntityCustomAttributeGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this data engine entity custom attribute get default response a status code equal to that given
func (o *DataEngineEntityCustomAttributeGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the data engine entity custom attribute get default response
func (o *DataEngineEntityCustomAttributeGetDefault) Code() int {
	return o._statusCode
}

func (o *DataEngineEntityCustomAttributeGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/entities/{data_engine_entity.uuid}/custom-attributes/{key}][%d] data_engine_entity_custom_attribute_get default %s", o._statusCode, payload)
}

func (o *DataEngineEntityCustomAttributeGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/entities/{data_engine_entity.uuid}/custom-attributes/{key}][%d] data_engine_entity_custom_attribute_get default %s", o._statusCode, payload)
}

func (o *DataEngineEntityCustomAttributeGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DataEngineEntityCustomAttributeGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
