// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewDataEngineEntityGetParams creates a new DataEngineEntityGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDataEngineEntityGetParams() *DataEngineEntityGetParams {
	return &DataEngineEntityGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDataEngineEntityGetParamsWithTimeout creates a new DataEngineEntityGetParams object
// with the ability to set a timeout on a request.
func NewDataEngineEntityGetParamsWithTimeout(timeout time.Duration) *DataEngineEntityGetParams {
	return &DataEngineEntityGetParams{
		timeout: timeout,
	}
}

// NewDataEngineEntityGetParamsWithContext creates a new DataEngineEntityGetParams object
// with the ability to set a context for a request.
func NewDataEngineEntityGetParamsWithContext(ctx context.Context) *DataEngineEntityGetParams {
	return &DataEngineEntityGetParams{
		Context: ctx,
	}
}

// NewDataEngineEntityGetParamsWithHTTPClient creates a new DataEngineEntityGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewDataEngineEntityGetParamsWithHTTPClient(client *http.Client) *DataEngineEntityGetParams {
	return &DataEngineEntityGetParams{
		HTTPClient: client,
	}
}

/*
DataEngineEntityGetParams contains all the parameters to send to the API endpoint

	for the data engine entity get operation.

	Typically these are written to a http.Request.
*/
type DataEngineEntityGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* UUID.

	   Unique identifier of the entity.
	*/
	UUID string

	/* WorkspaceUUID.

	   Unique identifier of the workspace.
	*/
	WorkspaceUUID string

	/* WorkspaceVersionUUID.

	   The version of the workspace to be used. If not specified, the current version is used.

	*/
	WorkspaceVersionUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the data engine entity get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DataEngineEntityGetParams) WithDefaults() *DataEngineEntityGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the data engine entity get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DataEngineEntityGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the data engine entity get params
func (o *DataEngineEntityGetParams) WithTimeout(timeout time.Duration) *DataEngineEntityGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the data engine entity get params
func (o *DataEngineEntityGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the data engine entity get params
func (o *DataEngineEntityGetParams) WithContext(ctx context.Context) *DataEngineEntityGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the data engine entity get params
func (o *DataEngineEntityGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the data engine entity get params
func (o *DataEngineEntityGetParams) WithHTTPClient(client *http.Client) *DataEngineEntityGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the data engine entity get params
func (o *DataEngineEntityGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the data engine entity get params
func (o *DataEngineEntityGetParams) WithFields(fields []string) *DataEngineEntityGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the data engine entity get params
func (o *DataEngineEntityGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithUUID adds the uuid to the data engine entity get params
func (o *DataEngineEntityGetParams) WithUUID(uuid string) *DataEngineEntityGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the data engine entity get params
func (o *DataEngineEntityGetParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WithWorkspaceUUID adds the workspaceUUID to the data engine entity get params
func (o *DataEngineEntityGetParams) WithWorkspaceUUID(workspaceUUID string) *DataEngineEntityGetParams {
	o.SetWorkspaceUUID(workspaceUUID)
	return o
}

// SetWorkspaceUUID adds the workspaceUuid to the data engine entity get params
func (o *DataEngineEntityGetParams) SetWorkspaceUUID(workspaceUUID string) {
	o.WorkspaceUUID = workspaceUUID
}

// WithWorkspaceVersionUUID adds the workspaceVersionUUID to the data engine entity get params
func (o *DataEngineEntityGetParams) WithWorkspaceVersionUUID(workspaceVersionUUID *string) *DataEngineEntityGetParams {
	o.SetWorkspaceVersionUUID(workspaceVersionUUID)
	return o
}

// SetWorkspaceVersionUUID adds the workspaceVersionUuid to the data engine entity get params
func (o *DataEngineEntityGetParams) SetWorkspaceVersionUUID(workspaceVersionUUID *string) {
	o.WorkspaceVersionUUID = workspaceVersionUUID
}

// WriteToRequest writes these params to a swagger request
func (o *DataEngineEntityGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	// path param workspace.uuid
	if err := r.SetPathParam("workspace.uuid", o.WorkspaceUUID); err != nil {
		return err
	}

	if o.WorkspaceVersionUUID != nil {

		// query param workspace.version.uuid
		var qrWorkspaceVersionUUID string

		if o.WorkspaceVersionUUID != nil {
			qrWorkspaceVersionUUID = *o.WorkspaceVersionUUID
		}
		qWorkspaceVersionUUID := qrWorkspaceVersionUUID
		if qWorkspaceVersionUUID != "" {

			if err := r.SetQueryParam("workspace.version.uuid", qWorkspaceVersionUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamDataEngineEntityGet binds the parameter fields
func (o *DataEngineEntityGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
