// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DataEngineEntityGetReader is a Reader for the DataEngineEntityGet structure.
type DataEngineEntityGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DataEngineEntityGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDataEngineEntityGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDataEngineEntityGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDataEngineEntityGetOK creates a DataEngineEntityGetOK with default headers values
func NewDataEngineEntityGetOK() *DataEngineEntityGetOK {
	return &DataEngineEntityGetOK{}
}

/*
DataEngineEntityGetOK describes a response with status code 200, with default header values.

OK
*/
type DataEngineEntityGetOK struct {
	Payload *models.DataEngineEntity
}

// IsSuccess returns true when this data engine entity get o k response has a 2xx status code
func (o *DataEngineEntityGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this data engine entity get o k response has a 3xx status code
func (o *DataEngineEntityGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this data engine entity get o k response has a 4xx status code
func (o *DataEngineEntityGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this data engine entity get o k response has a 5xx status code
func (o *DataEngineEntityGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this data engine entity get o k response a status code equal to that given
func (o *DataEngineEntityGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the data engine entity get o k response
func (o *DataEngineEntityGetOK) Code() int {
	return 200
}

func (o *DataEngineEntityGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/entities/{uuid}][%d] dataEngineEntityGetOK %s", 200, payload)
}

func (o *DataEngineEntityGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/entities/{uuid}][%d] dataEngineEntityGetOK %s", 200, payload)
}

func (o *DataEngineEntityGetOK) GetPayload() *models.DataEngineEntity {
	return o.Payload
}

func (o *DataEngineEntityGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DataEngineEntity)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDataEngineEntityGetDefault creates a DataEngineEntityGetDefault with default headers values
func NewDataEngineEntityGetDefault(code int) *DataEngineEntityGetDefault {
	return &DataEngineEntityGetDefault{
		_statusCode: code,
	}
}

/*
DataEngineEntityGetDefault describes a response with status code -1, with default header values.

Error
*/
type DataEngineEntityGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this data engine entity get default response has a 2xx status code
func (o *DataEngineEntityGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this data engine entity get default response has a 3xx status code
func (o *DataEngineEntityGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this data engine entity get default response has a 4xx status code
func (o *DataEngineEntityGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this data engine entity get default response has a 5xx status code
func (o *DataEngineEntityGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this data engine entity get default response a status code equal to that given
func (o *DataEngineEntityGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the data engine entity get default response
func (o *DataEngineEntityGetDefault) Code() int {
	return o._statusCode
}

func (o *DataEngineEntityGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/entities/{uuid}][%d] data_engine_entity_get default %s", o._statusCode, payload)
}

func (o *DataEngineEntityGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/entities/{uuid}][%d] data_engine_entity_get default %s", o._statusCode, payload)
}

func (o *DataEngineEntityGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DataEngineEntityGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
