// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewDataEngineEventCollectionGetParams creates a new DataEngineEventCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDataEngineEventCollectionGetParams() *DataEngineEventCollectionGetParams {
	return &DataEngineEventCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDataEngineEventCollectionGetParamsWithTimeout creates a new DataEngineEventCollectionGetParams object
// with the ability to set a timeout on a request.
func NewDataEngineEventCollectionGetParamsWithTimeout(timeout time.Duration) *DataEngineEventCollectionGetParams {
	return &DataEngineEventCollectionGetParams{
		timeout: timeout,
	}
}

// NewDataEngineEventCollectionGetParamsWithContext creates a new DataEngineEventCollectionGetParams object
// with the ability to set a context for a request.
func NewDataEngineEventCollectionGetParamsWithContext(ctx context.Context) *DataEngineEventCollectionGetParams {
	return &DataEngineEventCollectionGetParams{
		Context: ctx,
	}
}

// NewDataEngineEventCollectionGetParamsWithHTTPClient creates a new DataEngineEventCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewDataEngineEventCollectionGetParamsWithHTTPClient(client *http.Client) *DataEngineEventCollectionGetParams {
	return &DataEngineEventCollectionGetParams{
		HTTPClient: client,
	}
}

/*
DataEngineEventCollectionGetParams contains all the parameters to send to the API endpoint

	for the data engine event collection get operation.

	Typically these are written to a http.Request.
*/
type DataEngineEventCollectionGetParams struct {

	/* AttributesKey.

	   Filter by attributes.key
	*/
	AttributesKey *string

	/* AttributesValue.

	   Filter by attributes.value
	*/
	AttributesValue *string

	/* CreateTime.

	   Filter by create_time
	*/
	CreateTime *string

	/* Description.

	   Filter by description
	*/
	Description *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* JobName.

	   Filter by job.name
	*/
	JobName *string

	/* JobState.

	   Filter by job.state
	*/
	JobState *string

	/* JobType.

	   Filter by job.type
	*/
	JobType *string

	/* JobUUID.

	   Filter by job.uuid
	*/
	JobUUID *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* OwnerName.

	   Filter by owner.name
	*/
	OwnerName *string

	/* ResourceName.

	   Filter by resource.name
	*/
	ResourceName *string

	/* ResourceType.

	   Filter by resource.type
	*/
	ResourceType *string

	/* ResourceUUID.

	   Filter by resource.uuid
	*/
	ResourceUUID *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Severity.

	   Filter by severity
	*/
	Severity *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	/* VisibleToName.

	   Filter by visible_to.name
	*/
	VisibleToName *string

	/* VisibleToType.

	   Filter by visible_to.type
	*/
	VisibleToType *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the data engine event collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DataEngineEventCollectionGetParams) WithDefaults() *DataEngineEventCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the data engine event collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DataEngineEventCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := DataEngineEventCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the data engine event collection get params
func (o *DataEngineEventCollectionGetParams) WithTimeout(timeout time.Duration) *DataEngineEventCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the data engine event collection get params
func (o *DataEngineEventCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the data engine event collection get params
func (o *DataEngineEventCollectionGetParams) WithContext(ctx context.Context) *DataEngineEventCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the data engine event collection get params
func (o *DataEngineEventCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the data engine event collection get params
func (o *DataEngineEventCollectionGetParams) WithHTTPClient(client *http.Client) *DataEngineEventCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the data engine event collection get params
func (o *DataEngineEventCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAttributesKey adds the attributesKey to the data engine event collection get params
func (o *DataEngineEventCollectionGetParams) WithAttributesKey(attributesKey *string) *DataEngineEventCollectionGetParams {
	o.SetAttributesKey(attributesKey)
	return o
}

// SetAttributesKey adds the attributesKey to the data engine event collection get params
func (o *DataEngineEventCollectionGetParams) SetAttributesKey(attributesKey *string) {
	o.AttributesKey = attributesKey
}

// WithAttributesValue adds the attributesValue to the data engine event collection get params
func (o *DataEngineEventCollectionGetParams) WithAttributesValue(attributesValue *string) *DataEngineEventCollectionGetParams {
	o.SetAttributesValue(attributesValue)
	return o
}

// SetAttributesValue adds the attributesValue to the data engine event collection get params
func (o *DataEngineEventCollectionGetParams) SetAttributesValue(attributesValue *string) {
	o.AttributesValue = attributesValue
}

// WithCreateTime adds the createTime to the data engine event collection get params
func (o *DataEngineEventCollectionGetParams) WithCreateTime(createTime *string) *DataEngineEventCollectionGetParams {
	o.SetCreateTime(createTime)
	return o
}

// SetCreateTime adds the createTime to the data engine event collection get params
func (o *DataEngineEventCollectionGetParams) SetCreateTime(createTime *string) {
	o.CreateTime = createTime
}

// WithDescription adds the description to the data engine event collection get params
func (o *DataEngineEventCollectionGetParams) WithDescription(description *string) *DataEngineEventCollectionGetParams {
	o.SetDescription(description)
	return o
}

// SetDescription adds the description to the data engine event collection get params
func (o *DataEngineEventCollectionGetParams) SetDescription(description *string) {
	o.Description = description
}

// WithFields adds the fields to the data engine event collection get params
func (o *DataEngineEventCollectionGetParams) WithFields(fields []string) *DataEngineEventCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the data engine event collection get params
func (o *DataEngineEventCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithJobName adds the jobName to the data engine event collection get params
func (o *DataEngineEventCollectionGetParams) WithJobName(jobName *string) *DataEngineEventCollectionGetParams {
	o.SetJobName(jobName)
	return o
}

// SetJobName adds the jobName to the data engine event collection get params
func (o *DataEngineEventCollectionGetParams) SetJobName(jobName *string) {
	o.JobName = jobName
}

// WithJobState adds the jobState to the data engine event collection get params
func (o *DataEngineEventCollectionGetParams) WithJobState(jobState *string) *DataEngineEventCollectionGetParams {
	o.SetJobState(jobState)
	return o
}

// SetJobState adds the jobState to the data engine event collection get params
func (o *DataEngineEventCollectionGetParams) SetJobState(jobState *string) {
	o.JobState = jobState
}

// WithJobType adds the jobType to the data engine event collection get params
func (o *DataEngineEventCollectionGetParams) WithJobType(jobType *string) *DataEngineEventCollectionGetParams {
	o.SetJobType(jobType)
	return o
}

// SetJobType adds the jobType to the data engine event collection get params
func (o *DataEngineEventCollectionGetParams) SetJobType(jobType *string) {
	o.JobType = jobType
}

// WithJobUUID adds the jobUUID to the data engine event collection get params
func (o *DataEngineEventCollectionGetParams) WithJobUUID(jobUUID *string) *DataEngineEventCollectionGetParams {
	o.SetJobUUID(jobUUID)
	return o
}

// SetJobUUID adds the jobUuid to the data engine event collection get params
func (o *DataEngineEventCollectionGetParams) SetJobUUID(jobUUID *string) {
	o.JobUUID = jobUUID
}

// WithMaxRecords adds the maxRecords to the data engine event collection get params
func (o *DataEngineEventCollectionGetParams) WithMaxRecords(maxRecords *int64) *DataEngineEventCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the data engine event collection get params
func (o *DataEngineEventCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithOrderBy adds the orderBy to the data engine event collection get params
func (o *DataEngineEventCollectionGetParams) WithOrderBy(orderBy []string) *DataEngineEventCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the data engine event collection get params
func (o *DataEngineEventCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithOwnerName adds the ownerName to the data engine event collection get params
func (o *DataEngineEventCollectionGetParams) WithOwnerName(ownerName *string) *DataEngineEventCollectionGetParams {
	o.SetOwnerName(ownerName)
	return o
}

// SetOwnerName adds the ownerName to the data engine event collection get params
func (o *DataEngineEventCollectionGetParams) SetOwnerName(ownerName *string) {
	o.OwnerName = ownerName
}

// WithResourceName adds the resourceName to the data engine event collection get params
func (o *DataEngineEventCollectionGetParams) WithResourceName(resourceName *string) *DataEngineEventCollectionGetParams {
	o.SetResourceName(resourceName)
	return o
}

// SetResourceName adds the resourceName to the data engine event collection get params
func (o *DataEngineEventCollectionGetParams) SetResourceName(resourceName *string) {
	o.ResourceName = resourceName
}

// WithResourceType adds the resourceType to the data engine event collection get params
func (o *DataEngineEventCollectionGetParams) WithResourceType(resourceType *string) *DataEngineEventCollectionGetParams {
	o.SetResourceType(resourceType)
	return o
}

// SetResourceType adds the resourceType to the data engine event collection get params
func (o *DataEngineEventCollectionGetParams) SetResourceType(resourceType *string) {
	o.ResourceType = resourceType
}

// WithResourceUUID adds the resourceUUID to the data engine event collection get params
func (o *DataEngineEventCollectionGetParams) WithResourceUUID(resourceUUID *string) *DataEngineEventCollectionGetParams {
	o.SetResourceUUID(resourceUUID)
	return o
}

// SetResourceUUID adds the resourceUuid to the data engine event collection get params
func (o *DataEngineEventCollectionGetParams) SetResourceUUID(resourceUUID *string) {
	o.ResourceUUID = resourceUUID
}

// WithReturnRecords adds the returnRecords to the data engine event collection get params
func (o *DataEngineEventCollectionGetParams) WithReturnRecords(returnRecords *bool) *DataEngineEventCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the data engine event collection get params
func (o *DataEngineEventCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the data engine event collection get params
func (o *DataEngineEventCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *DataEngineEventCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the data engine event collection get params
func (o *DataEngineEventCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSeverity adds the severity to the data engine event collection get params
func (o *DataEngineEventCollectionGetParams) WithSeverity(severity *string) *DataEngineEventCollectionGetParams {
	o.SetSeverity(severity)
	return o
}

// SetSeverity adds the severity to the data engine event collection get params
func (o *DataEngineEventCollectionGetParams) SetSeverity(severity *string) {
	o.Severity = severity
}

// WithUUID adds the uuid to the data engine event collection get params
func (o *DataEngineEventCollectionGetParams) WithUUID(uuid *string) *DataEngineEventCollectionGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the data engine event collection get params
func (o *DataEngineEventCollectionGetParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WithVisibleToName adds the visibleToName to the data engine event collection get params
func (o *DataEngineEventCollectionGetParams) WithVisibleToName(visibleToName *string) *DataEngineEventCollectionGetParams {
	o.SetVisibleToName(visibleToName)
	return o
}

// SetVisibleToName adds the visibleToName to the data engine event collection get params
func (o *DataEngineEventCollectionGetParams) SetVisibleToName(visibleToName *string) {
	o.VisibleToName = visibleToName
}

// WithVisibleToType adds the visibleToType to the data engine event collection get params
func (o *DataEngineEventCollectionGetParams) WithVisibleToType(visibleToType *string) *DataEngineEventCollectionGetParams {
	o.SetVisibleToType(visibleToType)
	return o
}

// SetVisibleToType adds the visibleToType to the data engine event collection get params
func (o *DataEngineEventCollectionGetParams) SetVisibleToType(visibleToType *string) {
	o.VisibleToType = visibleToType
}

// WriteToRequest writes these params to a swagger request
func (o *DataEngineEventCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AttributesKey != nil {

		// query param attributes.key
		var qrAttributesKey string

		if o.AttributesKey != nil {
			qrAttributesKey = *o.AttributesKey
		}
		qAttributesKey := qrAttributesKey
		if qAttributesKey != "" {

			if err := r.SetQueryParam("attributes.key", qAttributesKey); err != nil {
				return err
			}
		}
	}

	if o.AttributesValue != nil {

		// query param attributes.value
		var qrAttributesValue string

		if o.AttributesValue != nil {
			qrAttributesValue = *o.AttributesValue
		}
		qAttributesValue := qrAttributesValue
		if qAttributesValue != "" {

			if err := r.SetQueryParam("attributes.value", qAttributesValue); err != nil {
				return err
			}
		}
	}

	if o.CreateTime != nil {

		// query param create_time
		var qrCreateTime string

		if o.CreateTime != nil {
			qrCreateTime = *o.CreateTime
		}
		qCreateTime := qrCreateTime
		if qCreateTime != "" {

			if err := r.SetQueryParam("create_time", qCreateTime); err != nil {
				return err
			}
		}
	}

	if o.Description != nil {

		// query param description
		var qrDescription string

		if o.Description != nil {
			qrDescription = *o.Description
		}
		qDescription := qrDescription
		if qDescription != "" {

			if err := r.SetQueryParam("description", qDescription); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.JobName != nil {

		// query param job.name
		var qrJobName string

		if o.JobName != nil {
			qrJobName = *o.JobName
		}
		qJobName := qrJobName
		if qJobName != "" {

			if err := r.SetQueryParam("job.name", qJobName); err != nil {
				return err
			}
		}
	}

	if o.JobState != nil {

		// query param job.state
		var qrJobState string

		if o.JobState != nil {
			qrJobState = *o.JobState
		}
		qJobState := qrJobState
		if qJobState != "" {

			if err := r.SetQueryParam("job.state", qJobState); err != nil {
				return err
			}
		}
	}

	if o.JobType != nil {

		// query param job.type
		var qrJobType string

		if o.JobType != nil {
			qrJobType = *o.JobType
		}
		qJobType := qrJobType
		if qJobType != "" {

			if err := r.SetQueryParam("job.type", qJobType); err != nil {
				return err
			}
		}
	}

	if o.JobUUID != nil {

		// query param job.uuid
		var qrJobUUID string

		if o.JobUUID != nil {
			qrJobUUID = *o.JobUUID
		}
		qJobUUID := qrJobUUID
		if qJobUUID != "" {

			if err := r.SetQueryParam("job.uuid", qJobUUID); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.OwnerName != nil {

		// query param owner.name
		var qrOwnerName string

		if o.OwnerName != nil {
			qrOwnerName = *o.OwnerName
		}
		qOwnerName := qrOwnerName
		if qOwnerName != "" {

			if err := r.SetQueryParam("owner.name", qOwnerName); err != nil {
				return err
			}
		}
	}

	if o.ResourceName != nil {

		// query param resource.name
		var qrResourceName string

		if o.ResourceName != nil {
			qrResourceName = *o.ResourceName
		}
		qResourceName := qrResourceName
		if qResourceName != "" {

			if err := r.SetQueryParam("resource.name", qResourceName); err != nil {
				return err
			}
		}
	}

	if o.ResourceType != nil {

		// query param resource.type
		var qrResourceType string

		if o.ResourceType != nil {
			qrResourceType = *o.ResourceType
		}
		qResourceType := qrResourceType
		if qResourceType != "" {

			if err := r.SetQueryParam("resource.type", qResourceType); err != nil {
				return err
			}
		}
	}

	if o.ResourceUUID != nil {

		// query param resource.uuid
		var qrResourceUUID string

		if o.ResourceUUID != nil {
			qrResourceUUID = *o.ResourceUUID
		}
		qResourceUUID := qrResourceUUID
		if qResourceUUID != "" {

			if err := r.SetQueryParam("resource.uuid", qResourceUUID); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Severity != nil {

		// query param severity
		var qrSeverity string

		if o.Severity != nil {
			qrSeverity = *o.Severity
		}
		qSeverity := qrSeverity
		if qSeverity != "" {

			if err := r.SetQueryParam("severity", qSeverity); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if o.VisibleToName != nil {

		// query param visible_to.name
		var qrVisibleToName string

		if o.VisibleToName != nil {
			qrVisibleToName = *o.VisibleToName
		}
		qVisibleToName := qrVisibleToName
		if qVisibleToName != "" {

			if err := r.SetQueryParam("visible_to.name", qVisibleToName); err != nil {
				return err
			}
		}
	}

	if o.VisibleToType != nil {

		// query param visible_to.type
		var qrVisibleToType string

		if o.VisibleToType != nil {
			qrVisibleToType = *o.VisibleToType
		}
		qVisibleToType := qrVisibleToType
		if qVisibleToType != "" {

			if err := r.SetQueryParam("visible_to.type", qVisibleToType); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamDataEngineEventCollectionGet binds the parameter fields
func (o *DataEngineEventCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamDataEngineEventCollectionGet binds the parameter order_by
func (o *DataEngineEventCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
