// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DataEngineEventCollectionGetReader is a Reader for the DataEngineEventCollectionGet structure.
type DataEngineEventCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DataEngineEventCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDataEngineEventCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDataEngineEventCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDataEngineEventCollectionGetOK creates a DataEngineEventCollectionGetOK with default headers values
func NewDataEngineEventCollectionGetOK() *DataEngineEventCollectionGetOK {
	return &DataEngineEventCollectionGetOK{}
}

/*
DataEngineEventCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type DataEngineEventCollectionGetOK struct {
	Payload *models.DataEngineEventResponse
}

// IsSuccess returns true when this data engine event collection get o k response has a 2xx status code
func (o *DataEngineEventCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this data engine event collection get o k response has a 3xx status code
func (o *DataEngineEventCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this data engine event collection get o k response has a 4xx status code
func (o *DataEngineEventCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this data engine event collection get o k response has a 5xx status code
func (o *DataEngineEventCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this data engine event collection get o k response a status code equal to that given
func (o *DataEngineEventCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the data engine event collection get o k response
func (o *DataEngineEventCollectionGetOK) Code() int {
	return 200
}

func (o *DataEngineEventCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/events][%d] dataEngineEventCollectionGetOK %s", 200, payload)
}

func (o *DataEngineEventCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/events][%d] dataEngineEventCollectionGetOK %s", 200, payload)
}

func (o *DataEngineEventCollectionGetOK) GetPayload() *models.DataEngineEventResponse {
	return o.Payload
}

func (o *DataEngineEventCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DataEngineEventResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDataEngineEventCollectionGetDefault creates a DataEngineEventCollectionGetDefault with default headers values
func NewDataEngineEventCollectionGetDefault(code int) *DataEngineEventCollectionGetDefault {
	return &DataEngineEventCollectionGetDefault{
		_statusCode: code,
	}
}

/*
DataEngineEventCollectionGetDefault describes a response with status code -1, with default header values.

Error
*/
type DataEngineEventCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this data engine event collection get default response has a 2xx status code
func (o *DataEngineEventCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this data engine event collection get default response has a 3xx status code
func (o *DataEngineEventCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this data engine event collection get default response has a 4xx status code
func (o *DataEngineEventCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this data engine event collection get default response has a 5xx status code
func (o *DataEngineEventCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this data engine event collection get default response a status code equal to that given
func (o *DataEngineEventCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the data engine event collection get default response
func (o *DataEngineEventCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *DataEngineEventCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/events][%d] data_engine_event_collection_get default %s", o._statusCode, payload)
}

func (o *DataEngineEventCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/events][%d] data_engine_event_collection_get default %s", o._statusCode, payload)
}

func (o *DataEngineEventCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DataEngineEventCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
