// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DataEngineEventGetReader is a Reader for the DataEngineEventGet structure.
type DataEngineEventGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DataEngineEventGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDataEngineEventGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDataEngineEventGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDataEngineEventGetOK creates a DataEngineEventGetOK with default headers values
func NewDataEngineEventGetOK() *DataEngineEventGetOK {
	return &DataEngineEventGetOK{}
}

/*
DataEngineEventGetOK describes a response with status code 200, with default header values.

OK
*/
type DataEngineEventGetOK struct {
	Payload *models.DataEngineEvent
}

// IsSuccess returns true when this data engine event get o k response has a 2xx status code
func (o *DataEngineEventGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this data engine event get o k response has a 3xx status code
func (o *DataEngineEventGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this data engine event get o k response has a 4xx status code
func (o *DataEngineEventGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this data engine event get o k response has a 5xx status code
func (o *DataEngineEventGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this data engine event get o k response a status code equal to that given
func (o *DataEngineEventGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the data engine event get o k response
func (o *DataEngineEventGetOK) Code() int {
	return 200
}

func (o *DataEngineEventGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/events/{uuid}][%d] dataEngineEventGetOK %s", 200, payload)
}

func (o *DataEngineEventGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/events/{uuid}][%d] dataEngineEventGetOK %s", 200, payload)
}

func (o *DataEngineEventGetOK) GetPayload() *models.DataEngineEvent {
	return o.Payload
}

func (o *DataEngineEventGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DataEngineEvent)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDataEngineEventGetDefault creates a DataEngineEventGetDefault with default headers values
func NewDataEngineEventGetDefault(code int) *DataEngineEventGetDefault {
	return &DataEngineEventGetDefault{
		_statusCode: code,
	}
}

/*
	DataEngineEventGetDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 4 | The event does not exist. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type DataEngineEventGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this data engine event get default response has a 2xx status code
func (o *DataEngineEventGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this data engine event get default response has a 3xx status code
func (o *DataEngineEventGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this data engine event get default response has a 4xx status code
func (o *DataEngineEventGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this data engine event get default response has a 5xx status code
func (o *DataEngineEventGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this data engine event get default response a status code equal to that given
func (o *DataEngineEventGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the data engine event get default response
func (o *DataEngineEventGetDefault) Code() int {
	return o._statusCode
}

func (o *DataEngineEventGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/events/{uuid}][%d] data_engine_event_get default %s", o._statusCode, payload)
}

func (o *DataEngineEventGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/events/{uuid}][%d] data_engine_event_get default %s", o._statusCode, payload)
}

func (o *DataEngineEventGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DataEngineEventGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
