// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DataEngineGetReader is a Reader for the DataEngineGet structure.
type DataEngineGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DataEngineGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDataEngineGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDataEngineGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDataEngineGetOK creates a DataEngineGetOK with default headers values
func NewDataEngineGetOK() *DataEngineGetOK {
	return &DataEngineGetOK{}
}

/*
DataEngineGetOK describes a response with status code 200, with default header values.

OK
*/
type DataEngineGetOK struct {
	Payload *models.DataEngine
}

// IsSuccess returns true when this data engine get o k response has a 2xx status code
func (o *DataEngineGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this data engine get o k response has a 3xx status code
func (o *DataEngineGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this data engine get o k response has a 4xx status code
func (o *DataEngineGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this data engine get o k response has a 5xx status code
func (o *DataEngineGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this data engine get o k response a status code equal to that given
func (o *DataEngineGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the data engine get o k response
func (o *DataEngineGetOK) Code() int {
	return 200
}

func (o *DataEngineGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine][%d] dataEngineGetOK %s", 200, payload)
}

func (o *DataEngineGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine][%d] dataEngineGetOK %s", 200, payload)
}

func (o *DataEngineGetOK) GetPayload() *models.DataEngine {
	return o.Payload
}

func (o *DataEngineGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DataEngine)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDataEngineGetDefault creates a DataEngineGetDefault with default headers values
func NewDataEngineGetDefault(code int) *DataEngineGetDefault {
	return &DataEngineGetDefault{
		_statusCode: code,
	}
}

/*
DataEngineGetDefault describes a response with status code -1, with default header values.

Error
*/
type DataEngineGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this data engine get default response has a 2xx status code
func (o *DataEngineGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this data engine get default response has a 3xx status code
func (o *DataEngineGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this data engine get default response has a 4xx status code
func (o *DataEngineGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this data engine get default response has a 5xx status code
func (o *DataEngineGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this data engine get default response a status code equal to that given
func (o *DataEngineGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the data engine get default response
func (o *DataEngineGetDefault) Code() int {
	return o._statusCode
}

func (o *DataEngineGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine][%d] data_engine_get default %s", o._statusCode, payload)
}

func (o *DataEngineGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine][%d] data_engine_get default %s", o._statusCode, payload)
}

func (o *DataEngineGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DataEngineGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
