// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DataEngineGovernanceAuditCountGetReader is a Reader for the DataEngineGovernanceAuditCountGet structure.
type DataEngineGovernanceAuditCountGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DataEngineGovernanceAuditCountGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDataEngineGovernanceAuditCountGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDataEngineGovernanceAuditCountGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDataEngineGovernanceAuditCountGetOK creates a DataEngineGovernanceAuditCountGetOK with default headers values
func NewDataEngineGovernanceAuditCountGetOK() *DataEngineGovernanceAuditCountGetOK {
	return &DataEngineGovernanceAuditCountGetOK{}
}

/*
DataEngineGovernanceAuditCountGetOK describes a response with status code 200, with default header values.

OK
*/
type DataEngineGovernanceAuditCountGetOK struct {
	Payload *models.DataEngineGovernanceAuditCount
}

// IsSuccess returns true when this data engine governance audit count get o k response has a 2xx status code
func (o *DataEngineGovernanceAuditCountGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this data engine governance audit count get o k response has a 3xx status code
func (o *DataEngineGovernanceAuditCountGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this data engine governance audit count get o k response has a 4xx status code
func (o *DataEngineGovernanceAuditCountGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this data engine governance audit count get o k response has a 5xx status code
func (o *DataEngineGovernanceAuditCountGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this data engine governance audit count get o k response a status code equal to that given
func (o *DataEngineGovernanceAuditCountGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the data engine governance audit count get o k response
func (o *DataEngineGovernanceAuditCountGetOK) Code() int {
	return 200
}

func (o *DataEngineGovernanceAuditCountGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/governance/impacted-files/{workspace.uuid}/{guardrail_policy.uuid}][%d] dataEngineGovernanceAuditCountGetOK %s", 200, payload)
}

func (o *DataEngineGovernanceAuditCountGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/governance/impacted-files/{workspace.uuid}/{guardrail_policy.uuid}][%d] dataEngineGovernanceAuditCountGetOK %s", 200, payload)
}

func (o *DataEngineGovernanceAuditCountGetOK) GetPayload() *models.DataEngineGovernanceAuditCount {
	return o.Payload
}

func (o *DataEngineGovernanceAuditCountGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DataEngineGovernanceAuditCount)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDataEngineGovernanceAuditCountGetDefault creates a DataEngineGovernanceAuditCountGetDefault with default headers values
func NewDataEngineGovernanceAuditCountGetDefault(code int) *DataEngineGovernanceAuditCountGetDefault {
	return &DataEngineGovernanceAuditCountGetDefault{
		_statusCode: code,
	}
}

/*
DataEngineGovernanceAuditCountGetDefault describes a response with status code -1, with default header values.

Error in retrieving the audit counts.
*/
type DataEngineGovernanceAuditCountGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this data engine governance audit count get default response has a 2xx status code
func (o *DataEngineGovernanceAuditCountGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this data engine governance audit count get default response has a 3xx status code
func (o *DataEngineGovernanceAuditCountGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this data engine governance audit count get default response has a 4xx status code
func (o *DataEngineGovernanceAuditCountGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this data engine governance audit count get default response has a 5xx status code
func (o *DataEngineGovernanceAuditCountGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this data engine governance audit count get default response a status code equal to that given
func (o *DataEngineGovernanceAuditCountGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the data engine governance audit count get default response
func (o *DataEngineGovernanceAuditCountGetDefault) Code() int {
	return o._statusCode
}

func (o *DataEngineGovernanceAuditCountGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/governance/impacted-files/{workspace.uuid}/{guardrail_policy.uuid}][%d] data_engine_governance_audit_count_get default %s", o._statusCode, payload)
}

func (o *DataEngineGovernanceAuditCountGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/governance/impacted-files/{workspace.uuid}/{guardrail_policy.uuid}][%d] data_engine_governance_audit_count_get default %s", o._statusCode, payload)
}

func (o *DataEngineGovernanceAuditCountGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DataEngineGovernanceAuditCountGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
