// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewDataEngineGovernanceAuditImpactedFilesCollectionGetParams creates a new DataEngineGovernanceAuditImpactedFilesCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDataEngineGovernanceAuditImpactedFilesCollectionGetParams() *DataEngineGovernanceAuditImpactedFilesCollectionGetParams {
	return &DataEngineGovernanceAuditImpactedFilesCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDataEngineGovernanceAuditImpactedFilesCollectionGetParamsWithTimeout creates a new DataEngineGovernanceAuditImpactedFilesCollectionGetParams object
// with the ability to set a timeout on a request.
func NewDataEngineGovernanceAuditImpactedFilesCollectionGetParamsWithTimeout(timeout time.Duration) *DataEngineGovernanceAuditImpactedFilesCollectionGetParams {
	return &DataEngineGovernanceAuditImpactedFilesCollectionGetParams{
		timeout: timeout,
	}
}

// NewDataEngineGovernanceAuditImpactedFilesCollectionGetParamsWithContext creates a new DataEngineGovernanceAuditImpactedFilesCollectionGetParams object
// with the ability to set a context for a request.
func NewDataEngineGovernanceAuditImpactedFilesCollectionGetParamsWithContext(ctx context.Context) *DataEngineGovernanceAuditImpactedFilesCollectionGetParams {
	return &DataEngineGovernanceAuditImpactedFilesCollectionGetParams{
		Context: ctx,
	}
}

// NewDataEngineGovernanceAuditImpactedFilesCollectionGetParamsWithHTTPClient creates a new DataEngineGovernanceAuditImpactedFilesCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewDataEngineGovernanceAuditImpactedFilesCollectionGetParamsWithHTTPClient(client *http.Client) *DataEngineGovernanceAuditImpactedFilesCollectionGetParams {
	return &DataEngineGovernanceAuditImpactedFilesCollectionGetParams{
		HTTPClient: client,
	}
}

/*
DataEngineGovernanceAuditImpactedFilesCollectionGetParams contains all the parameters to send to the API endpoint

	for the data engine governance audit impacted files collection get operation.

	Typically these are written to a http.Request.
*/
type DataEngineGovernanceAuditImpactedFilesCollectionGetParams struct {

	/* Actions.

	   Filter by actions
	*/
	Actions *string

	/* ConditionsMet.

	   Filter by conditions_met
	*/
	ConditionsMet *string

	/* DataCollectionUUID.

	   Filter by data_collection.uuid
	*/
	DataCollectionUUID *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* FileName.

	   Filter by file.name
	*/
	FileName *string

	/* FileSize.

	   Filter by file.size
	*/
	FileSize *int64

	/* FileUUID.

	   Filter by file.uuid
	*/
	FileUUID *string

	/* GuardrailPolicyUUID.

	   Unique identifier of the guardrail policy.
	*/
	GuardrailPolicyUUID string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Timestamp.

	   Filter by timestamp
	*/
	Timestamp *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	/* WorkspaceUUID.

	   Unique identifier of the workspace.
	*/
	WorkspaceUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the data engine governance audit impacted files collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DataEngineGovernanceAuditImpactedFilesCollectionGetParams) WithDefaults() *DataEngineGovernanceAuditImpactedFilesCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the data engine governance audit impacted files collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DataEngineGovernanceAuditImpactedFilesCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := DataEngineGovernanceAuditImpactedFilesCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the data engine governance audit impacted files collection get params
func (o *DataEngineGovernanceAuditImpactedFilesCollectionGetParams) WithTimeout(timeout time.Duration) *DataEngineGovernanceAuditImpactedFilesCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the data engine governance audit impacted files collection get params
func (o *DataEngineGovernanceAuditImpactedFilesCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the data engine governance audit impacted files collection get params
func (o *DataEngineGovernanceAuditImpactedFilesCollectionGetParams) WithContext(ctx context.Context) *DataEngineGovernanceAuditImpactedFilesCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the data engine governance audit impacted files collection get params
func (o *DataEngineGovernanceAuditImpactedFilesCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the data engine governance audit impacted files collection get params
func (o *DataEngineGovernanceAuditImpactedFilesCollectionGetParams) WithHTTPClient(client *http.Client) *DataEngineGovernanceAuditImpactedFilesCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the data engine governance audit impacted files collection get params
func (o *DataEngineGovernanceAuditImpactedFilesCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithActions adds the actions to the data engine governance audit impacted files collection get params
func (o *DataEngineGovernanceAuditImpactedFilesCollectionGetParams) WithActions(actions *string) *DataEngineGovernanceAuditImpactedFilesCollectionGetParams {
	o.SetActions(actions)
	return o
}

// SetActions adds the actions to the data engine governance audit impacted files collection get params
func (o *DataEngineGovernanceAuditImpactedFilesCollectionGetParams) SetActions(actions *string) {
	o.Actions = actions
}

// WithConditionsMet adds the conditionsMet to the data engine governance audit impacted files collection get params
func (o *DataEngineGovernanceAuditImpactedFilesCollectionGetParams) WithConditionsMet(conditionsMet *string) *DataEngineGovernanceAuditImpactedFilesCollectionGetParams {
	o.SetConditionsMet(conditionsMet)
	return o
}

// SetConditionsMet adds the conditionsMet to the data engine governance audit impacted files collection get params
func (o *DataEngineGovernanceAuditImpactedFilesCollectionGetParams) SetConditionsMet(conditionsMet *string) {
	o.ConditionsMet = conditionsMet
}

// WithDataCollectionUUID adds the dataCollectionUUID to the data engine governance audit impacted files collection get params
func (o *DataEngineGovernanceAuditImpactedFilesCollectionGetParams) WithDataCollectionUUID(dataCollectionUUID *string) *DataEngineGovernanceAuditImpactedFilesCollectionGetParams {
	o.SetDataCollectionUUID(dataCollectionUUID)
	return o
}

// SetDataCollectionUUID adds the dataCollectionUuid to the data engine governance audit impacted files collection get params
func (o *DataEngineGovernanceAuditImpactedFilesCollectionGetParams) SetDataCollectionUUID(dataCollectionUUID *string) {
	o.DataCollectionUUID = dataCollectionUUID
}

// WithFields adds the fields to the data engine governance audit impacted files collection get params
func (o *DataEngineGovernanceAuditImpactedFilesCollectionGetParams) WithFields(fields []string) *DataEngineGovernanceAuditImpactedFilesCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the data engine governance audit impacted files collection get params
func (o *DataEngineGovernanceAuditImpactedFilesCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithFileName adds the fileName to the data engine governance audit impacted files collection get params
func (o *DataEngineGovernanceAuditImpactedFilesCollectionGetParams) WithFileName(fileName *string) *DataEngineGovernanceAuditImpactedFilesCollectionGetParams {
	o.SetFileName(fileName)
	return o
}

// SetFileName adds the fileName to the data engine governance audit impacted files collection get params
func (o *DataEngineGovernanceAuditImpactedFilesCollectionGetParams) SetFileName(fileName *string) {
	o.FileName = fileName
}

// WithFileSize adds the fileSize to the data engine governance audit impacted files collection get params
func (o *DataEngineGovernanceAuditImpactedFilesCollectionGetParams) WithFileSize(fileSize *int64) *DataEngineGovernanceAuditImpactedFilesCollectionGetParams {
	o.SetFileSize(fileSize)
	return o
}

// SetFileSize adds the fileSize to the data engine governance audit impacted files collection get params
func (o *DataEngineGovernanceAuditImpactedFilesCollectionGetParams) SetFileSize(fileSize *int64) {
	o.FileSize = fileSize
}

// WithFileUUID adds the fileUUID to the data engine governance audit impacted files collection get params
func (o *DataEngineGovernanceAuditImpactedFilesCollectionGetParams) WithFileUUID(fileUUID *string) *DataEngineGovernanceAuditImpactedFilesCollectionGetParams {
	o.SetFileUUID(fileUUID)
	return o
}

// SetFileUUID adds the fileUuid to the data engine governance audit impacted files collection get params
func (o *DataEngineGovernanceAuditImpactedFilesCollectionGetParams) SetFileUUID(fileUUID *string) {
	o.FileUUID = fileUUID
}

// WithGuardrailPolicyUUID adds the guardrailPolicyUUID to the data engine governance audit impacted files collection get params
func (o *DataEngineGovernanceAuditImpactedFilesCollectionGetParams) WithGuardrailPolicyUUID(guardrailPolicyUUID string) *DataEngineGovernanceAuditImpactedFilesCollectionGetParams {
	o.SetGuardrailPolicyUUID(guardrailPolicyUUID)
	return o
}

// SetGuardrailPolicyUUID adds the guardrailPolicyUuid to the data engine governance audit impacted files collection get params
func (o *DataEngineGovernanceAuditImpactedFilesCollectionGetParams) SetGuardrailPolicyUUID(guardrailPolicyUUID string) {
	o.GuardrailPolicyUUID = guardrailPolicyUUID
}

// WithMaxRecords adds the maxRecords to the data engine governance audit impacted files collection get params
func (o *DataEngineGovernanceAuditImpactedFilesCollectionGetParams) WithMaxRecords(maxRecords *int64) *DataEngineGovernanceAuditImpactedFilesCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the data engine governance audit impacted files collection get params
func (o *DataEngineGovernanceAuditImpactedFilesCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithOrderBy adds the orderBy to the data engine governance audit impacted files collection get params
func (o *DataEngineGovernanceAuditImpactedFilesCollectionGetParams) WithOrderBy(orderBy []string) *DataEngineGovernanceAuditImpactedFilesCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the data engine governance audit impacted files collection get params
func (o *DataEngineGovernanceAuditImpactedFilesCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the data engine governance audit impacted files collection get params
func (o *DataEngineGovernanceAuditImpactedFilesCollectionGetParams) WithReturnRecords(returnRecords *bool) *DataEngineGovernanceAuditImpactedFilesCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the data engine governance audit impacted files collection get params
func (o *DataEngineGovernanceAuditImpactedFilesCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the data engine governance audit impacted files collection get params
func (o *DataEngineGovernanceAuditImpactedFilesCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *DataEngineGovernanceAuditImpactedFilesCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the data engine governance audit impacted files collection get params
func (o *DataEngineGovernanceAuditImpactedFilesCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithTimestamp adds the timestamp to the data engine governance audit impacted files collection get params
func (o *DataEngineGovernanceAuditImpactedFilesCollectionGetParams) WithTimestamp(timestamp *string) *DataEngineGovernanceAuditImpactedFilesCollectionGetParams {
	o.SetTimestamp(timestamp)
	return o
}

// SetTimestamp adds the timestamp to the data engine governance audit impacted files collection get params
func (o *DataEngineGovernanceAuditImpactedFilesCollectionGetParams) SetTimestamp(timestamp *string) {
	o.Timestamp = timestamp
}

// WithUUID adds the uuid to the data engine governance audit impacted files collection get params
func (o *DataEngineGovernanceAuditImpactedFilesCollectionGetParams) WithUUID(uuid *string) *DataEngineGovernanceAuditImpactedFilesCollectionGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the data engine governance audit impacted files collection get params
func (o *DataEngineGovernanceAuditImpactedFilesCollectionGetParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WithWorkspaceUUID adds the workspaceUUID to the data engine governance audit impacted files collection get params
func (o *DataEngineGovernanceAuditImpactedFilesCollectionGetParams) WithWorkspaceUUID(workspaceUUID string) *DataEngineGovernanceAuditImpactedFilesCollectionGetParams {
	o.SetWorkspaceUUID(workspaceUUID)
	return o
}

// SetWorkspaceUUID adds the workspaceUuid to the data engine governance audit impacted files collection get params
func (o *DataEngineGovernanceAuditImpactedFilesCollectionGetParams) SetWorkspaceUUID(workspaceUUID string) {
	o.WorkspaceUUID = workspaceUUID
}

// WriteToRequest writes these params to a swagger request
func (o *DataEngineGovernanceAuditImpactedFilesCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Actions != nil {

		// query param actions
		var qrActions string

		if o.Actions != nil {
			qrActions = *o.Actions
		}
		qActions := qrActions
		if qActions != "" {

			if err := r.SetQueryParam("actions", qActions); err != nil {
				return err
			}
		}
	}

	if o.ConditionsMet != nil {

		// query param conditions_met
		var qrConditionsMet string

		if o.ConditionsMet != nil {
			qrConditionsMet = *o.ConditionsMet
		}
		qConditionsMet := qrConditionsMet
		if qConditionsMet != "" {

			if err := r.SetQueryParam("conditions_met", qConditionsMet); err != nil {
				return err
			}
		}
	}

	if o.DataCollectionUUID != nil {

		// query param data_collection.uuid
		var qrDataCollectionUUID string

		if o.DataCollectionUUID != nil {
			qrDataCollectionUUID = *o.DataCollectionUUID
		}
		qDataCollectionUUID := qrDataCollectionUUID
		if qDataCollectionUUID != "" {

			if err := r.SetQueryParam("data_collection.uuid", qDataCollectionUUID); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.FileName != nil {

		// query param file.name
		var qrFileName string

		if o.FileName != nil {
			qrFileName = *o.FileName
		}
		qFileName := qrFileName
		if qFileName != "" {

			if err := r.SetQueryParam("file.name", qFileName); err != nil {
				return err
			}
		}
	}

	if o.FileSize != nil {

		// query param file.size
		var qrFileSize int64

		if o.FileSize != nil {
			qrFileSize = *o.FileSize
		}
		qFileSize := swag.FormatInt64(qrFileSize)
		if qFileSize != "" {

			if err := r.SetQueryParam("file.size", qFileSize); err != nil {
				return err
			}
		}
	}

	if o.FileUUID != nil {

		// query param file.uuid
		var qrFileUUID string

		if o.FileUUID != nil {
			qrFileUUID = *o.FileUUID
		}
		qFileUUID := qrFileUUID
		if qFileUUID != "" {

			if err := r.SetQueryParam("file.uuid", qFileUUID); err != nil {
				return err
			}
		}
	}

	// path param guardrail_policy.uuid
	if err := r.SetPathParam("guardrail_policy.uuid", o.GuardrailPolicyUUID); err != nil {
		return err
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Timestamp != nil {

		// query param timestamp
		var qrTimestamp string

		if o.Timestamp != nil {
			qrTimestamp = *o.Timestamp
		}
		qTimestamp := qrTimestamp
		if qTimestamp != "" {

			if err := r.SetQueryParam("timestamp", qTimestamp); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	// path param workspace.uuid
	if err := r.SetPathParam("workspace.uuid", o.WorkspaceUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamDataEngineGovernanceAuditImpactedFilesCollectionGet binds the parameter fields
func (o *DataEngineGovernanceAuditImpactedFilesCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamDataEngineGovernanceAuditImpactedFilesCollectionGet binds the parameter order_by
func (o *DataEngineGovernanceAuditImpactedFilesCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
