// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewDataEngineGovernanceFilePreviewJobCreateParams creates a new DataEngineGovernanceFilePreviewJobCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDataEngineGovernanceFilePreviewJobCreateParams() *DataEngineGovernanceFilePreviewJobCreateParams {
	return &DataEngineGovernanceFilePreviewJobCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDataEngineGovernanceFilePreviewJobCreateParamsWithTimeout creates a new DataEngineGovernanceFilePreviewJobCreateParams object
// with the ability to set a timeout on a request.
func NewDataEngineGovernanceFilePreviewJobCreateParamsWithTimeout(timeout time.Duration) *DataEngineGovernanceFilePreviewJobCreateParams {
	return &DataEngineGovernanceFilePreviewJobCreateParams{
		timeout: timeout,
	}
}

// NewDataEngineGovernanceFilePreviewJobCreateParamsWithContext creates a new DataEngineGovernanceFilePreviewJobCreateParams object
// with the ability to set a context for a request.
func NewDataEngineGovernanceFilePreviewJobCreateParamsWithContext(ctx context.Context) *DataEngineGovernanceFilePreviewJobCreateParams {
	return &DataEngineGovernanceFilePreviewJobCreateParams{
		Context: ctx,
	}
}

// NewDataEngineGovernanceFilePreviewJobCreateParamsWithHTTPClient creates a new DataEngineGovernanceFilePreviewJobCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewDataEngineGovernanceFilePreviewJobCreateParamsWithHTTPClient(client *http.Client) *DataEngineGovernanceFilePreviewJobCreateParams {
	return &DataEngineGovernanceFilePreviewJobCreateParams{
		HTTPClient: client,
	}
}

/*
DataEngineGovernanceFilePreviewJobCreateParams contains all the parameters to send to the API endpoint

	for the data engine governance file preview job create operation.

	Typically these are written to a http.Request.
*/
type DataEngineGovernanceFilePreviewJobCreateParams struct {

	/* Info.

	   File info retrieval request.
	*/
	Info *models.DataEngineGovernanceFilePreviewJob

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the data engine governance file preview job create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DataEngineGovernanceFilePreviewJobCreateParams) WithDefaults() *DataEngineGovernanceFilePreviewJobCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the data engine governance file preview job create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DataEngineGovernanceFilePreviewJobCreateParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)
	)

	val := DataEngineGovernanceFilePreviewJobCreateParams{
		ReturnRecords: &returnRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the data engine governance file preview job create params
func (o *DataEngineGovernanceFilePreviewJobCreateParams) WithTimeout(timeout time.Duration) *DataEngineGovernanceFilePreviewJobCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the data engine governance file preview job create params
func (o *DataEngineGovernanceFilePreviewJobCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the data engine governance file preview job create params
func (o *DataEngineGovernanceFilePreviewJobCreateParams) WithContext(ctx context.Context) *DataEngineGovernanceFilePreviewJobCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the data engine governance file preview job create params
func (o *DataEngineGovernanceFilePreviewJobCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the data engine governance file preview job create params
func (o *DataEngineGovernanceFilePreviewJobCreateParams) WithHTTPClient(client *http.Client) *DataEngineGovernanceFilePreviewJobCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the data engine governance file preview job create params
func (o *DataEngineGovernanceFilePreviewJobCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the data engine governance file preview job create params
func (o *DataEngineGovernanceFilePreviewJobCreateParams) WithInfo(info *models.DataEngineGovernanceFilePreviewJob) *DataEngineGovernanceFilePreviewJobCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the data engine governance file preview job create params
func (o *DataEngineGovernanceFilePreviewJobCreateParams) SetInfo(info *models.DataEngineGovernanceFilePreviewJob) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the data engine governance file preview job create params
func (o *DataEngineGovernanceFilePreviewJobCreateParams) WithReturnRecords(returnRecords *bool) *DataEngineGovernanceFilePreviewJobCreateParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the data engine governance file preview job create params
func (o *DataEngineGovernanceFilePreviewJobCreateParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WriteToRequest writes these params to a swagger request
func (o *DataEngineGovernanceFilePreviewJobCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
