// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DataEngineGovernanceFilePreviewJobCreateReader is a Reader for the DataEngineGovernanceFilePreviewJobCreate structure.
type DataEngineGovernanceFilePreviewJobCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DataEngineGovernanceFilePreviewJobCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewDataEngineGovernanceFilePreviewJobCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDataEngineGovernanceFilePreviewJobCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDataEngineGovernanceFilePreviewJobCreateCreated creates a DataEngineGovernanceFilePreviewJobCreateCreated with default headers values
func NewDataEngineGovernanceFilePreviewJobCreateCreated() *DataEngineGovernanceFilePreviewJobCreateCreated {
	return &DataEngineGovernanceFilePreviewJobCreateCreated{}
}

/*
DataEngineGovernanceFilePreviewJobCreateCreated describes a response with status code 201, with default header values.

Created
*/
type DataEngineGovernanceFilePreviewJobCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.DataEngineGovernanceFilePreviewJob
}

// IsSuccess returns true when this data engine governance file preview job create created response has a 2xx status code
func (o *DataEngineGovernanceFilePreviewJobCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this data engine governance file preview job create created response has a 3xx status code
func (o *DataEngineGovernanceFilePreviewJobCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this data engine governance file preview job create created response has a 4xx status code
func (o *DataEngineGovernanceFilePreviewJobCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this data engine governance file preview job create created response has a 5xx status code
func (o *DataEngineGovernanceFilePreviewJobCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this data engine governance file preview job create created response a status code equal to that given
func (o *DataEngineGovernanceFilePreviewJobCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the data engine governance file preview job create created response
func (o *DataEngineGovernanceFilePreviewJobCreateCreated) Code() int {
	return 201
}

func (o *DataEngineGovernanceFilePreviewJobCreateCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/governance/file-preview/jobs][%d] dataEngineGovernanceFilePreviewJobCreateCreated %s", 201, payload)
}

func (o *DataEngineGovernanceFilePreviewJobCreateCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/governance/file-preview/jobs][%d] dataEngineGovernanceFilePreviewJobCreateCreated %s", 201, payload)
}

func (o *DataEngineGovernanceFilePreviewJobCreateCreated) GetPayload() *models.DataEngineGovernanceFilePreviewJob {
	return o.Payload
}

func (o *DataEngineGovernanceFilePreviewJobCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.DataEngineGovernanceFilePreviewJob)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDataEngineGovernanceFilePreviewJobCreateDefault creates a DataEngineGovernanceFilePreviewJobCreateDefault with default headers values
func NewDataEngineGovernanceFilePreviewJobCreateDefault(code int) *DataEngineGovernanceFilePreviewJobCreateDefault {
	return &DataEngineGovernanceFilePreviewJobCreateDefault{
		_statusCode: code,
	}
}

/*
DataEngineGovernanceFilePreviewJobCreateDefault describes a response with status code -1, with default header values.

Error in creating the file preview job.
*/
type DataEngineGovernanceFilePreviewJobCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this data engine governance file preview job create default response has a 2xx status code
func (o *DataEngineGovernanceFilePreviewJobCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this data engine governance file preview job create default response has a 3xx status code
func (o *DataEngineGovernanceFilePreviewJobCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this data engine governance file preview job create default response has a 4xx status code
func (o *DataEngineGovernanceFilePreviewJobCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this data engine governance file preview job create default response has a 5xx status code
func (o *DataEngineGovernanceFilePreviewJobCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this data engine governance file preview job create default response a status code equal to that given
func (o *DataEngineGovernanceFilePreviewJobCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the data engine governance file preview job create default response
func (o *DataEngineGovernanceFilePreviewJobCreateDefault) Code() int {
	return o._statusCode
}

func (o *DataEngineGovernanceFilePreviewJobCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/governance/file-preview/jobs][%d] data_engine_governance_file_preview_job_create default %s", o._statusCode, payload)
}

func (o *DataEngineGovernanceFilePreviewJobCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/governance/file-preview/jobs][%d] data_engine_governance_file_preview_job_create default %s", o._statusCode, payload)
}

func (o *DataEngineGovernanceFilePreviewJobCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DataEngineGovernanceFilePreviewJobCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
