// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DataEngineGovernanceFilePreviewJobGetReader is a Reader for the DataEngineGovernanceFilePreviewJobGet structure.
type DataEngineGovernanceFilePreviewJobGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DataEngineGovernanceFilePreviewJobGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDataEngineGovernanceFilePreviewJobGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDataEngineGovernanceFilePreviewJobGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDataEngineGovernanceFilePreviewJobGetOK creates a DataEngineGovernanceFilePreviewJobGetOK with default headers values
func NewDataEngineGovernanceFilePreviewJobGetOK() *DataEngineGovernanceFilePreviewJobGetOK {
	return &DataEngineGovernanceFilePreviewJobGetOK{}
}

/*
DataEngineGovernanceFilePreviewJobGetOK describes a response with status code 200, with default header values.

OK
*/
type DataEngineGovernanceFilePreviewJobGetOK struct {
	Payload *models.DataEngineGovernanceFilePreviewJob
}

// IsSuccess returns true when this data engine governance file preview job get o k response has a 2xx status code
func (o *DataEngineGovernanceFilePreviewJobGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this data engine governance file preview job get o k response has a 3xx status code
func (o *DataEngineGovernanceFilePreviewJobGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this data engine governance file preview job get o k response has a 4xx status code
func (o *DataEngineGovernanceFilePreviewJobGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this data engine governance file preview job get o k response has a 5xx status code
func (o *DataEngineGovernanceFilePreviewJobGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this data engine governance file preview job get o k response a status code equal to that given
func (o *DataEngineGovernanceFilePreviewJobGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the data engine governance file preview job get o k response
func (o *DataEngineGovernanceFilePreviewJobGetOK) Code() int {
	return 200
}

func (o *DataEngineGovernanceFilePreviewJobGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/governance/file-preview/jobs/{uuid}][%d] dataEngineGovernanceFilePreviewJobGetOK %s", 200, payload)
}

func (o *DataEngineGovernanceFilePreviewJobGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/governance/file-preview/jobs/{uuid}][%d] dataEngineGovernanceFilePreviewJobGetOK %s", 200, payload)
}

func (o *DataEngineGovernanceFilePreviewJobGetOK) GetPayload() *models.DataEngineGovernanceFilePreviewJob {
	return o.Payload
}

func (o *DataEngineGovernanceFilePreviewJobGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DataEngineGovernanceFilePreviewJob)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDataEngineGovernanceFilePreviewJobGetDefault creates a DataEngineGovernanceFilePreviewJobGetDefault with default headers values
func NewDataEngineGovernanceFilePreviewJobGetDefault(code int) *DataEngineGovernanceFilePreviewJobGetDefault {
	return &DataEngineGovernanceFilePreviewJobGetDefault{
		_statusCode: code,
	}
}

/*
DataEngineGovernanceFilePreviewJobGetDefault describes a response with status code -1, with default header values.

Error in retrieving the job details.
*/
type DataEngineGovernanceFilePreviewJobGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this data engine governance file preview job get default response has a 2xx status code
func (o *DataEngineGovernanceFilePreviewJobGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this data engine governance file preview job get default response has a 3xx status code
func (o *DataEngineGovernanceFilePreviewJobGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this data engine governance file preview job get default response has a 4xx status code
func (o *DataEngineGovernanceFilePreviewJobGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this data engine governance file preview job get default response has a 5xx status code
func (o *DataEngineGovernanceFilePreviewJobGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this data engine governance file preview job get default response a status code equal to that given
func (o *DataEngineGovernanceFilePreviewJobGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the data engine governance file preview job get default response
func (o *DataEngineGovernanceFilePreviewJobGetDefault) Code() int {
	return o._statusCode
}

func (o *DataEngineGovernanceFilePreviewJobGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/governance/file-preview/jobs/{uuid}][%d] data_engine_governance_file_preview_job_get default %s", o._statusCode, payload)
}

func (o *DataEngineGovernanceFilePreviewJobGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/governance/file-preview/jobs/{uuid}][%d] data_engine_governance_file_preview_job_get default %s", o._statusCode, payload)
}

func (o *DataEngineGovernanceFilePreviewJobGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DataEngineGovernanceFilePreviewJobGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
