// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewDataEngineGovernancePoliciesClassificationCategoryCreateParams creates a new DataEngineGovernancePoliciesClassificationCategoryCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDataEngineGovernancePoliciesClassificationCategoryCreateParams() *DataEngineGovernancePoliciesClassificationCategoryCreateParams {
	return &DataEngineGovernancePoliciesClassificationCategoryCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDataEngineGovernancePoliciesClassificationCategoryCreateParamsWithTimeout creates a new DataEngineGovernancePoliciesClassificationCategoryCreateParams object
// with the ability to set a timeout on a request.
func NewDataEngineGovernancePoliciesClassificationCategoryCreateParamsWithTimeout(timeout time.Duration) *DataEngineGovernancePoliciesClassificationCategoryCreateParams {
	return &DataEngineGovernancePoliciesClassificationCategoryCreateParams{
		timeout: timeout,
	}
}

// NewDataEngineGovernancePoliciesClassificationCategoryCreateParamsWithContext creates a new DataEngineGovernancePoliciesClassificationCategoryCreateParams object
// with the ability to set a context for a request.
func NewDataEngineGovernancePoliciesClassificationCategoryCreateParamsWithContext(ctx context.Context) *DataEngineGovernancePoliciesClassificationCategoryCreateParams {
	return &DataEngineGovernancePoliciesClassificationCategoryCreateParams{
		Context: ctx,
	}
}

// NewDataEngineGovernancePoliciesClassificationCategoryCreateParamsWithHTTPClient creates a new DataEngineGovernancePoliciesClassificationCategoryCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewDataEngineGovernancePoliciesClassificationCategoryCreateParamsWithHTTPClient(client *http.Client) *DataEngineGovernancePoliciesClassificationCategoryCreateParams {
	return &DataEngineGovernancePoliciesClassificationCategoryCreateParams{
		HTTPClient: client,
	}
}

/*
DataEngineGovernancePoliciesClassificationCategoryCreateParams contains all the parameters to send to the API endpoint

	for the data engine governance policies classification category create operation.

	Typically these are written to a http.Request.
*/
type DataEngineGovernancePoliciesClassificationCategoryCreateParams struct {

	/* Info.

	   Category information.
	*/
	Info *models.DataEngineGovernancePoliciesClassificationCategory

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the data engine governance policies classification category create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DataEngineGovernancePoliciesClassificationCategoryCreateParams) WithDefaults() *DataEngineGovernancePoliciesClassificationCategoryCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the data engine governance policies classification category create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DataEngineGovernancePoliciesClassificationCategoryCreateParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)
	)

	val := DataEngineGovernancePoliciesClassificationCategoryCreateParams{
		ReturnRecords: &returnRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the data engine governance policies classification category create params
func (o *DataEngineGovernancePoliciesClassificationCategoryCreateParams) WithTimeout(timeout time.Duration) *DataEngineGovernancePoliciesClassificationCategoryCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the data engine governance policies classification category create params
func (o *DataEngineGovernancePoliciesClassificationCategoryCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the data engine governance policies classification category create params
func (o *DataEngineGovernancePoliciesClassificationCategoryCreateParams) WithContext(ctx context.Context) *DataEngineGovernancePoliciesClassificationCategoryCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the data engine governance policies classification category create params
func (o *DataEngineGovernancePoliciesClassificationCategoryCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the data engine governance policies classification category create params
func (o *DataEngineGovernancePoliciesClassificationCategoryCreateParams) WithHTTPClient(client *http.Client) *DataEngineGovernancePoliciesClassificationCategoryCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the data engine governance policies classification category create params
func (o *DataEngineGovernancePoliciesClassificationCategoryCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the data engine governance policies classification category create params
func (o *DataEngineGovernancePoliciesClassificationCategoryCreateParams) WithInfo(info *models.DataEngineGovernancePoliciesClassificationCategory) *DataEngineGovernancePoliciesClassificationCategoryCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the data engine governance policies classification category create params
func (o *DataEngineGovernancePoliciesClassificationCategoryCreateParams) SetInfo(info *models.DataEngineGovernancePoliciesClassificationCategory) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the data engine governance policies classification category create params
func (o *DataEngineGovernancePoliciesClassificationCategoryCreateParams) WithReturnRecords(returnRecords *bool) *DataEngineGovernancePoliciesClassificationCategoryCreateParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the data engine governance policies classification category create params
func (o *DataEngineGovernancePoliciesClassificationCategoryCreateParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WriteToRequest writes these params to a swagger request
func (o *DataEngineGovernancePoliciesClassificationCategoryCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
